package moon.logprocess.module;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@Accessors(chain=true)
@EqualsAndHashCode(callSuper=false)
public class App {
	
	public static final String APP_ID 			= "APP_ID";
	public static final String APP_GRP_ID		= "APP_GRP_ID";
	public static final String OS 				= "OS";
	public static final String PUSH_CERT 		= "PUSH_CERT";
	public static final String PUSH_PWD 		= "ENC_2_PA";
	public static final String PUSH_SOUND 		= "PUSH_SOUND";
	public static final String GCM_API_KEY1 	= "GCM_API_KEY1";
	public static final String GCM_API_KEY2 	= "GCM_API_KEY2";
	public static final String GCM_API_KEY3 	= "GCM_API_KEY3";
	public static final String APP_KEY 			= "APP_KEY";
	public static final String AUTO_BLOCK_START_HOUR = "AUTO_BLOCK_START";
	public static final String AUTO_BLOCK_END_HOUR = "AUTO_BLOCK_END";
	public static final String PRIVATE_FLAG	 = 	"PRV_FLAG";
	public static final String DENY_APP_VER = "DENY_APP_VER";
	public static final String GCM_PROJECT_NUM = "GCM_PROJECT_NUM";
	
	public static final String UNKNOWN = "U";
	public static final String ANDROID = "A";
	public static final String IOS = "I";
	
	private Map<Integer, String> appOsMap = new ConcurrentHashMap<Integer, String>();
	private Map<String, String> appKeyMap = new ConcurrentHashMap<String, String>();
	
	private int appGrpId;
	private long appId;
	private int iOsBadgeCount = 0;
	private String apnsPushCert;
	private String apnsPushPwd;
	private String gcmApiKey;
	private String pushSound;
	private int autoBlockStartHour;
	private int autoBlockEndHour;
	private String privateFlag = "N";
	private String denyAppVersion = "";
	private long gcmProjectNum;
	
	public void putOs(int appId, String appOs) {
		appOsMap.put(appId, appOs);
	}
	
	public String getOs(int appId) {
		return appOsMap.get(appId);
	}
	
	public void putAppKey(String appOs, String appKey) {
		appKeyMap.put(appOs, appKey);
	}
	
	public String getAppKey(String appOs) {
		return appKeyMap.get(appOs);
	}
}
