package moon.logprocess.db;

import java.util.Iterator;
import java.util.List;

import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.util.StringUtil;

public class TrackingPreparedStatementGroup extends PreparedStatementGroup {
			
	
		
	// prepareStatement
	public eMsPreparedStatement PPS_FIRST_CHECK = null;
	public eMsPreparedStatement PPS_SECOND_CHECK = null;
		
	public List LIST_UPDATE_FIRST_OK_COMMON_INFO = null;
	public List LIST_UPDATE_FIRST_OK_LIST_INFO = null;
	
	public List LIST_UPDATE_SECOND_OK_COMMON_INFO = null; 
	public List LIST_UPDATE_SECOND_OK_LIST_INFO = null;
	
	public List LIST_UPDATE_FINAL_COMMON_INFO = null;
	public List LIST_UPDATE_FINAL_LIST_INFO = null;
	
	public eMsPreparedStatement PPS_UPDATE_MEMBER_INFO = null;
	public List LIST_INSERT_MEMBER_INFO = null;
	
	//ssfire
	public List LIST_UPDATE_FIRST_OK_LIST_OPOINT_INFO = null;
	
	
	// query
	public String QUERY_FIRST_CHECK = null;
	public String QUERY_SECOND_CHECK = null;
	
	public List QUERY_UPDATE_FIRST_OK_COMMON_INFO = null;
	public List QUERY_UPDATE_FIRST_OK_LIST_INFO = null;
	
	public List QUERY_UPDATE_SECOND_OK_COMMON_INFO = null;
	public List QUERY_UPDATE_SECOND_OK_LIST_INFO = null;
	
	public List QUERY_UPDATE_FINAL_COMMON_INFO = null;
	public List QUERY_UPDATE_FINAL_LIST_INFO = null;
	
	public String QUERY_UPDATE_MEMBER_INFO = null;
	public List QUERY_INSERT_MEMBER_INFO = null;
	
	//ssfire
	public List QUERY_UPDATE_FIRST_OK_LIST_OPOINT_INFO = null;
	
	
	// ppt setting
	public void create(eMsConnection conn,String list_table,String mobile_type) throws Exception{
		String query = "";
		
		String open_table = StringUtil.replace(list_table, "LIST", "OPEN");
		String click_table = StringUtil.replace(list_table, "LIST", "CLICK");
		
		//PPS_FIRST_CHECK
		query = ppsParseSQL(QUERY_FIRST_CHECK,"LIST_TABLE", list_table,"@{","}");		
		query = ppsParseSQL(query,"OPEN_TABLE", open_table,"@{","}");		
		query = ppsParseSQL(query,"CLICK_TABLE", click_table,"@{","}");		
		PPS_FIRST_CHECK = conn.prepareStatement(query, "${", "}");
		
		//PPS_SECOND_CHECK
		query = ppsParseSQL(QUERY_SECOND_CHECK,"LIST_TABLE", list_table,"@{","}");	
		query = ppsParseSQL(query,"OPEN_TABLE", open_table,"@{","}");		
		query = ppsParseSQL(query,"CLICK_TABLE", click_table,"@{","}");	
		PPS_SECOND_CHECK = conn.prepareStatement(query, "${", "}");
		
		LIST_UPDATE_FIRST_OK_COMMON_INFO = setPptList( conn, QUERY_UPDATE_FIRST_OK_COMMON_INFO, list_table);		
		LIST_UPDATE_FIRST_OK_LIST_INFO = setPptList( conn, QUERY_UPDATE_FIRST_OK_LIST_INFO, list_table);
		
		LIST_UPDATE_SECOND_OK_COMMON_INFO = setPptList( conn, QUERY_UPDATE_SECOND_OK_COMMON_INFO, list_table);		
		LIST_UPDATE_SECOND_OK_LIST_INFO = setPptList( conn, QUERY_UPDATE_SECOND_OK_LIST_INFO, list_table);
		
		LIST_UPDATE_FINAL_COMMON_INFO = setPptList( conn, QUERY_UPDATE_FINAL_COMMON_INFO, list_table);		
		LIST_UPDATE_FINAL_LIST_INFO = setPptList( conn, QUERY_UPDATE_FINAL_LIST_INFO, list_table);
		
		
		//alpha 2
		if(QUERY_UPDATE_MEMBER_INFO != null){
			query = ppsParseSQL(QUERY_UPDATE_MEMBER_INFO,"LIST_TABLE", list_table,"@{","}");	
			query = ppsParseSQL(query,"OPEN_TABLE", open_table,"@{","}");		
			query = ppsParseSQL(query,"CLICK_TABLE", click_table,"@{","}");	
			PPS_UPDATE_MEMBER_INFO = conn.prepareStatement(query, "${", "}");
			
			LIST_INSERT_MEMBER_INFO = setPptList( conn, QUERY_INSERT_MEMBER_INFO, list_table);
		}
		
		//ssfire
		LIST_UPDATE_FIRST_OK_LIST_OPOINT_INFO = setPptList( conn, QUERY_UPDATE_FIRST_OK_LIST_OPOINT_INFO, list_table);
		
	}
	
	
	public void close(){
		eMsPreparedStatement pps = null;
		
		if(PPS_FIRST_CHECK != null){
			PPS_FIRST_CHECK.close();
			PPS_FIRST_CHECK = null;
		}
		
		if(PPS_SECOND_CHECK != null){
			PPS_SECOND_CHECK.close();
			PPS_SECOND_CHECK = null;
		}
		
		if(LIST_UPDATE_FIRST_OK_COMMON_INFO != null){
			for( Iterator iter = LIST_UPDATE_FIRST_OK_COMMON_INFO.iterator() ;  iter.hasNext() ; ){
				pps = (eMsPreparedStatement)iter.next();
				pps.close();
			}
			LIST_UPDATE_FIRST_OK_COMMON_INFO = null;
		}
		
		if(LIST_UPDATE_FIRST_OK_LIST_INFO != null){
			for( Iterator iter = LIST_UPDATE_FIRST_OK_LIST_INFO.iterator() ;  iter.hasNext() ; ){
				pps = (eMsPreparedStatement)iter.next();
				pps.close();
			}
			LIST_UPDATE_FIRST_OK_LIST_INFO = null;
		}
		if(LIST_UPDATE_SECOND_OK_COMMON_INFO != null){
			for( Iterator iter = LIST_UPDATE_SECOND_OK_COMMON_INFO.iterator() ;  iter.hasNext() ; ){
				pps = (eMsPreparedStatement)iter.next();
				pps.close();
			}
			LIST_UPDATE_SECOND_OK_COMMON_INFO = null;
		}
		if(LIST_UPDATE_SECOND_OK_LIST_INFO != null){
			for( Iterator iter = LIST_UPDATE_SECOND_OK_LIST_INFO.iterator() ;  iter.hasNext() ; ){
				pps = (eMsPreparedStatement)iter.next();
				pps.close();
			}
			LIST_UPDATE_SECOND_OK_COMMON_INFO = null;
		}
		
		if(LIST_UPDATE_FINAL_COMMON_INFO != null){
			for( Iterator iter = LIST_UPDATE_FINAL_COMMON_INFO.iterator() ;  iter.hasNext() ; ){
				pps = (eMsPreparedStatement)iter.next();
				pps.close();
			}
			LIST_UPDATE_FINAL_COMMON_INFO = null;
		}
		if(LIST_UPDATE_FINAL_LIST_INFO != null){
			for( Iterator iter = LIST_UPDATE_FINAL_LIST_INFO.iterator() ;  iter.hasNext() ; ){
				pps = (eMsPreparedStatement)iter.next();
				pps.close();
			}
			LIST_UPDATE_FINAL_LIST_INFO = null;
		}
		
		
		
		//alpha 2
		if(PPS_UPDATE_MEMBER_INFO != null){
			PPS_UPDATE_MEMBER_INFO.close();
			PPS_UPDATE_MEMBER_INFO = null;
		}
		
		if(LIST_INSERT_MEMBER_INFO != null){
			for( Iterator iter = LIST_INSERT_MEMBER_INFO.iterator() ;  iter.hasNext() ; ){
				pps = (eMsPreparedStatement)iter.next();
				pps.close();
			}
			LIST_INSERT_MEMBER_INFO = null;
		}
		
		//ssfire
		if(LIST_UPDATE_FIRST_OK_LIST_OPOINT_INFO != null){
			for( Iterator iter = LIST_UPDATE_FIRST_OK_LIST_OPOINT_INFO.iterator() ;  iter.hasNext() ; ){
				pps = (eMsPreparedStatement)iter.next();
				pps.close();
			}
			LIST_UPDATE_FIRST_OK_LIST_OPOINT_INFO = null;
		}
		
	}
	
}
