package moon.logprocess.db;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import lombok.extern.slf4j.Slf4j;
import mars.tracking.parser.TrackingApacheLogParser;
import pluto.util.StringUtil;

@Slf4j
public abstract class PreparedStatementGroup {
	
	
	
	//======================================================================
	public static Hashtable PPS_GRP_MAP = new Hashtable();	

	public static void map_clean(){
		
		if(PPS_GRP_MAP.size() <= 0){
			return;
		}
			
		
		Object obj = null;
		TrackingPreparedStatementGroup ppsGrp = null;
		TrackingPreparedStatementGroupMobile ppsMobileGrp = null;
		
		
		log.info("[USE: PPS_GRP_MAP SIZE]"+PreparedStatementGroup.PPS_GRP_MAP.size());
		
		Enumeration e = PreparedStatementGroup.PPS_GRP_MAP.elements();		
		for ( ; e.hasMoreElements() ;) {
			obj = e.nextElement(); 
			
			if( obj instanceof TrackingPreparedStatementGroup ) {
				ppsGrp = (TrackingPreparedStatementGroup)obj;
				log.info("[CLOSE:ppsGrp NAME]"+ppsGrp.getGRP_NAME());
				ppsGrp.close();
			}else if( obj instanceof TrackingPreparedStatementGroupMobile ) {
				ppsMobileGrp = (TrackingPreparedStatementGroupMobile)obj;
				log.info("[CLOSE:ppsMobileGrp NAME]"+ppsMobileGrp.getGRP_NAME());
				ppsMobileGrp.close();
			}else{
				if(ppsGrp != null) {
					ppsGrp.close();
				}
			}
		}
		PreparedStatementGroup.PPS_GRP_MAP.clear();	
	}
	//======================================================================
	
	protected String GRP_NAME = null;
	
	public String getGRP_NAME() {
		return GRP_NAME;
	}

	public void setGRP_NAME(String grp_name) {
		GRP_NAME = grp_name;
	}

	// ppt setting
	public abstract void create(eMsConnection conn,String list_table,String mobile_type) throws Exception;	
	
	public abstract void close();
	
	//ppt list setting
	protected List setPptList(eMsConnection conn, List queryList, String list_table) throws Exception{
		List return_list = null;
		String query = "";
		eMsPreparedStatement pps = null;
		
		// EMS_MASS_SEND_LIST_01 ==> EMS_MASS_SEND_OPEN_01, EMS_MASS_SEND_CLICK_01
		String open_table = StringUtil.replace(list_table, "LIST", "OPEN");
		String click_table = StringUtil.replace(list_table, "LIST", "CLICK");
		
		if(queryList !=null && queryList.size()>0){
			return_list = new ArrayList();
			
			for( Iterator iter = queryList.iterator() ;  iter.hasNext() ; ){
				query = (String)iter.next();
				if(query.trim().length()<6) continue;
				
				query = ppsParseSQL( query ,"LIST_TABLE", list_table,"@{","}");
				query = ppsParseSQL(query,"OPEN_TABLE", open_table,"@{","}");
				query = ppsParseSQL(query,"CLICK_TABLE", click_table,"@{","}");
				
				pps = conn.prepareStatement(query, "${", "}");
				
				return_list.add(pps);
			}
		}
		
		return return_list;
	}
	
	protected List setPptListMobile(eMsConnection conn, List queryList, String list_table, String mobile_type) throws Exception{
		List return_list = null;
		String query = "";
		eMsPreparedStatement pps = null;
		
		String open_table = StringUtil.replace(list_table, "LIST", "OPEN");
		String click_table = StringUtil.replace(list_table, "LIST", "CLICK");
		
		if(queryList !=null && queryList.size()>0){
			return_list = new ArrayList();
			
			for( Iterator iter = queryList.iterator() ;  iter.hasNext() ; ){
				query = (String)iter.next();
				if(query.trim().length()<6) continue;
				
				query = ppsParseSQL( query ,"LIST_TABLE", list_table,"@{","}");
				query = ppsParseSQL(query,"OPEN_TABLE", open_table+"_MOBILE","@{","}");
				query = ppsParseSQL(query,"CLICK_TABLE", click_table,"@{","}");
				query = ppsParseSQL(query,"MOBILE_TYPE", mobile_type,"@{","}");
				
				pps = conn.prepareStatement(query, "${", "}");
				
				return_list.add(pps);
			}
		}
		
		return return_list;
	}	
	

	
	public String ppsParseSQL(String source, String mapping, String value,String start, String end) {

		if( mapping == null || source == null )
			return source;

		return replace_target(source, start + mapping + end, value);
	}
	
	public static String replace_target(String target, String from, String to) {
		if( target == null || from == null || to == null )
			return null;

		int idx1 = 0;
		int idx2;

		while ((idx2 = target.indexOf(from, idx1)) != -1) {
			target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
			idx1 = idx2 + to.length();
		}
		return target;
	}
}
