package moon.logprocess.db;

import jupiter.mass.log.updator.MassSendSepCodeLogUpdatorPps;
import lombok.extern.slf4j.Slf4j;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;

@Slf4j
public class MassPushPreparedStatementGroup extends MassPreparedStatementGroup{
	
	//upstream 
	public eMsPreparedStatement PPS_UPDATE_DELIVER_60 = null;
	protected String	QUERY_UPDATE_DELIVER_60			= null;
	
	public MassPushPreparedStatementGroup(String list_table){
		super(list_table);
		
		TABLE_LIST = list_table;
		
		try{
				QUERY_UPDATE_START_60 			= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_START_60,"LIST_TABLE",list_table,"@{","}");
				QUERY_UPDATE_SUCCESS_60 		= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_SUCCESS_60,"LIST_TABLE",list_table,"@{","}");
				QUERY_UPDATE_ERROR_60 			= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_ERROR_60,"LIST_TABLE",list_table,"@{","}");
		}catch (Exception e){
			log.error("MassPreparedStatementGroup Constructor Parse Query Error.", e);
			QUERY_UPDATE_START_60 			= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_START_60,"LIST_TABLE",list_table,"@{","}");
			QUERY_UPDATE_SUCCESS_60 		= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_SUCCESS_60,"LIST_TABLE",list_table,"@{","}");
			QUERY_UPDATE_ERROR_60 			= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_ERROR_60,"LIST_TABLE",list_table,"@{","}");
		}
		
//		QUERY_UPDATE_START_60 			= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_START_60,"LIST_TABLE",list_table_add_hint,"@{","}");
//		QUERY_UPDATE_SUCCESS_60 		= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_SUCCESS_60,"LIST_TABLE",list_table_add_hint,"@{","}");
//		QUERY_UPDATE_ERROR_60 			= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_ERROR_60,"LIST_TABLE",list_table_add_hint,"@{","}");
		QUERY_SELECT_CURRENT_ERROR_CODE	= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_SELECT_CURRENT_ERROR_CODE,"LIST_TABLE",list_table,"@{","}");
		
		//2016.03.22 bhkim hardbounce
		QUERY_UPDATE_HARDBOUNCE_SUMMARY	= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_HARDBOUNCE_SUMMARY,"LIST_TABLE",list_table,"@{","}");
		QUERY_INSERT_HARDBOUNCE_SUMMARY	= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_INSERT_HARDBOUNCE_SUMMARY,"LIST_TABLE",list_table,"@{","}");
		
		//upstream
		QUERY_UPDATE_DELIVER_60 		= ppsParseSQL(MassSendSepCodeLogUpdatorPps.QUERY_UPDATE_DELIVER_60,"LIST_TABLE",list_table,"@{","}");
		
		if(log.isDebugEnabled()){
			log.debug("[QUERY_UPDATE_START_60]"+QUERY_UPDATE_START_60);
			log.debug("[QUERY_UPDATE_SUCCESS_60]"+QUERY_UPDATE_SUCCESS_60);
			log.debug("[QUERY_UPDATE_ERROR_60]"+QUERY_UPDATE_ERROR_60);
			log.debug("[QUERY_SELECT_CURRENT_ERROR_CODE]"+QUERY_SELECT_CURRENT_ERROR_CODE);
			
			//2016.03.22 bhkim hardbounce
			log.debug("[QUERY_UPDATE_HARDBOUNCE_SUMMARY]"+QUERY_UPDATE_HARDBOUNCE_SUMMARY);
			log.debug("[QUERY_INSERT_HARDBOUNCE_SUMMARY]"+QUERY_INSERT_HARDBOUNCE_SUMMARY);
			
			log.debug("[QUERY_UPDATE_DELIVER_60]"+QUERY_UPDATE_DELIVER_60);
		}
	}
	

	public void create(eMsConnection conn) throws Exception{
		PPS_UPDATE_START_60 = conn.prepareStatement(QUERY_UPDATE_START_60, "${", "}");
		PPS_UPDATE_SUCCESS_60 = conn.prepareStatement(QUERY_UPDATE_SUCCESS_60, "${", "}");
		PPS_UPDATE_ERROR_60 = conn.prepareStatement(QUERY_UPDATE_ERROR_60, "${", "}");
		PPS_SELECT_CURRENT_ERROR_CODE = conn.prepareStatement(QUERY_SELECT_CURRENT_ERROR_CODE, "${", "}");
		
		//2016.03.22 bhkim hardbounce
		PPS_UPDATE_HARDBOUNCE_SUMMARY = conn.prepareStatement(QUERY_UPDATE_HARDBOUNCE_SUMMARY, "${", "}");
		PPS_INSERT_HARDBOUNCE_SUMMARY = conn.prepareStatement(QUERY_INSERT_HARDBOUNCE_SUMMARY, "${", "}");
		//upstream
		PPS_UPDATE_DELIVER_60 = conn.prepareStatement(QUERY_UPDATE_DELIVER_60, "${", "}");
	}
	
	public void close(){
		PPS_UPDATE_START_60.close();
		PPS_UPDATE_START_60 = null;
		
		PPS_UPDATE_SUCCESS_60.close();
		PPS_UPDATE_SUCCESS_60 = null;
		
		PPS_UPDATE_ERROR_60.close();
		PPS_UPDATE_ERROR_60 = null;
		
		PPS_SELECT_CURRENT_ERROR_CODE.close();
		PPS_SELECT_CURRENT_ERROR_CODE = null;
		
		//2016.03.22 bhkim hardbounce
		PPS_UPDATE_HARDBOUNCE_SUMMARY.close();
		PPS_UPDATE_HARDBOUNCE_SUMMARY = null;
				
		PPS_INSERT_HARDBOUNCE_SUMMARY.close();
		PPS_INSERT_HARDBOUNCE_SUMMARY = null;
		
		//upstream
		PPS_UPDATE_DELIVER_60.close();
		PPS_UPDATE_DELIVER_60 = null;
	}
	
	
	
	private String ppsParseSQL(String source, String mapping, String value,String start, String end) {

		if( mapping == null || source == null )
			return source;

		return replace_target(source, start + mapping + end, value);
	}
	
	public static String replace_target(String target, String from, String to) {
		if( target == null || from == null || to == null )
			return null;

		int idx1 = 0;
		int idx2;

		while ((idx2 = target.indexOf(from, idx1)) != -1) {
			target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
			idx1 = idx2 + to.length();
		}
		return target;
	}
}
