package moon.logprocess.bean;

import moon.logprocess.task.AutoRemainSendTask;

public class AutoRemainBean {
	private String workday = "";
	
	private String seqno = "";
	
	private String cycle_type = "";
	
	private String end_date = "";
	
	private String target_cnt = "";
	
	private String pushed_cnt = "";
	
	private String check_time = "";
	
	private int act_cnt = 0;
	
	
	
	public AutoRemainBean(){
		
	}
	
	public AutoRemainBean(String workday,String seqno,String cycle_type, String end_date, String target_cnt, String pushed_cnt, String check_time){
		this.workday = workday;
		this.seqno = seqno;
		this.cycle_type = cycle_type; 
		this.end_date = end_date; 
		this.target_cnt = target_cnt; 
		this.pushed_cnt = pushed_cnt; 
		this.check_time = check_time; 
	}
	
	
	//------------------------------------------------------
	/**
	 * return bean id 
	 */
	public String getBeanId(){
		return this.workday+"_"+this.seqno;
	}
	
	/**
	 * 
	 * @return
	 */
	public boolean actCheck(){
		if(act_cnt< AutoRemainSendTask.REMAIN_ACT_CNT ){
			act_cnt++;
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * pushed_cnt가 같은지를 반환한다. 
	 * @param p_cnt : 비교할 pushed_cnt
	 * @return
	 */
	public boolean samePushCnt(String p_cnt){
		if(pushed_cnt.equals(p_cnt)){
			return true;
		}			
		
		return false;
	}
	
	/**
	 * check_time 이 30분 전시간 이전이면 pushed_cnt가 변화가 없는지 30분이 넘었다는 뜻이다.
	 * 이러한 상황을 boolean으로 알려준다.
	 * 
	 * @param before_30min : 현재시간에서 30분 전 시간
	 * @return
	 */
	public boolean doActTime(String before_30min){ 
		if(Double.parseDouble(check_time)<Double.parseDouble(before_30min)){
			return true;
		}
		
		return false;		
	}
	
	//------------------------------------------------------

	public int getAct_cnt() {
		return act_cnt;
	}

	public void setAct_cnt(int act_cnt) {
		this.act_cnt = act_cnt;
	}

	public String getCheck_time() {
		return check_time;
	}

	public void setCheck_time(String check_time) {
		this.check_time = check_time;
	}

	public String getCycle_type() {
		return cycle_type;
	}

	public void setCycle_type(String cycle_type) {
		this.cycle_type = cycle_type;
	}

	public String getEnd_date() {
		return end_date;
	}

	public void setEnd_date(String end_date) {
		this.end_date = end_date;
	}

	public String getPushed_cnt() {
		return pushed_cnt;
	}

	public void setPushed_cnt(String pushed_cnt) {
		this.pushed_cnt = pushed_cnt;
	}

	public String getSeqno() {
		return seqno;
	}

	public void setSeqno(String seqno) {
		this.seqno = seqno;
	}

	public String getTarget_cnt() {
		return target_cnt;
	}

	public void setTarget_cnt(String target_cnt) {
		this.target_cnt = target_cnt;
	}

	public String getWorkday() {
		return workday;
	}

	public void setWorkday(String workday) {
		this.workday = workday;
	}
}
