/*
 * @(#)SmsContentPD.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.sms.producer;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import mercury.contents.common.producer.ContentPD;
import pluto.lang.eMsTypes;

/**
 * SMS 제작물 producer
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class SmsContentPD extends ContentPD {
	
	
	protected static Class DEFAULT_MAPPING_GENERATOR_CLASS = null;
	protected static Class TEST_DEFAULT_MAPPING_GENERATOR_CLASS = null;
	
	public static void init( Object tmp ) throws Exception{
		Properties prop = ( Properties )tmp;
		
		DEFAULT_MAPPING_GENERATOR_CLASS = Class.forName( prop.getProperty( "default.mapping.generator.class" ) );
		TEST_DEFAULT_MAPPING_GENERATOR_CLASS = Class.forName( prop.getProperty( "test.default.mapping.generator.class" ) );
	}
	
	protected Class INSTANCE_DEFAULT_MAPPING_GENERATOR_CLASS = null;
	
	protected ContentInfo SEND_CONTENT_INFO = null;
	
	protected Properties SCHEDULE_INFO = null;
	
	protected String POST_ID = null;
	
	/** Creates a new instance of SmsContentPD */
	public SmsContentPD() {
		super();
		INSTANCE_DEFAULT_MAPPING_GENERATOR_CLASS = DEFAULT_MAPPING_GENERATOR_CLASS;
	}
	
	/** 처리한 결과로 생성된 ContentInfo를 반환한다.
	 * @return 생성된 ContentInfo
	 */
	public ContentInfo getContentInfo() {
		return this.SEND_CONTENT_INFO;
	}
	
	protected void initProperty(Properties info) throws Exception{
		this.SCHEDULE_INFO = info;
		this.POST_ID = this.SCHEDULE_INFO.getProperty("POST_ID");
		setName( this.POST_ID + " 's SmsContentPD" );
	}
	
	/** Content를 처리하는 로직을 정의한다.
	 * @param info 발송 스케쥴 정보
	 * @throws Exception 생성에러
	 */
	public void process_main() throws Exception {
		
		
		this.SEND_CONTENT_INFO = null;
		
		if (log.isDebugEnabled())  log.debug( getName() + " pass result contents " );
		
		/**BodyParser Instance 준비
		 */
		BodyParser __BODY_PARSER__ = (BodyParser)InstanceFactory.getInstance( this.SCHEDULE_INFO , eMsTypes.BODYPARSER_INSTANCE );
		__BODY_PARSER__.setContents( this.SCHEDULE_INFO.getProperty("SMS_MSG") );
		
		/**Message Instance준비
		 */
		Message __MESSAGE__ = (Message)InstanceFactory.getInstance(this.SCHEDULE_INFO , eMsTypes.MESSAGE_INSTANCE );
		
		// 메세지에 파서 지정
		__MESSAGE__.setContent(__BODY_PARSER__);
		
		MailBody __MAILBODY__ = (MailBody)InstanceFactory.getInstance( this.SCHEDULE_INFO , eMsTypes.MAILBODY_INSTANCE );
		
		/** MailBody에 Message 지정한다.
		 */
		__MAILBODY__.setMessage( __MESSAGE__ );
		
		/* 발송할 사항에 대해서 ContentInfoManager에 등록을 한다. 그래야지 재발송이 가능하니깐.
		 */
		this.SEND_CONTENT_INFO = new ContentInfo();
		
		this.SEND_CONTENT_INFO.setID( this.POST_ID );
		
		this.SEND_CONTENT_INFO.setScheduleInfo( this.SCHEDULE_INFO );
		
		this.SEND_CONTENT_INFO.setMappingHeader( this.SCHEDULE_INFO.getProperty( "MAPPINGHEADER" ) );
				
		this.SEND_CONTENT_INFO.setMailBody( __MAILBODY__ );
		
		this.SEND_CONTENT_INFO.setReturnPath( this.SCHEDULE_INFO.getProperty("CALLBACK") );
		
		this.SEND_CONTENT_INFO.setSendType( this.SCHEDULE_INFO.getProperty("SEND_TYPE") );
		
		if (log.isDebugEnabled())  log.debug( getName() + " pass regist contensts infomation " );
	}	

	protected void initResource() throws Exception {
		// TODO Auto-generated method stub

	}
	protected void exec_close() {
		// TODO Auto-generated method stub

	}
	protected void initError(Throwable thw) {
		// TODO Auto-generated method stub

	}
	protected void mainError(Throwable thw) {
		// TODO Auto-generated method stub

	}
}
