/*
 * @(#)SmsBodyParser.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.sms.parser;

import mercury.contents.common.parser.SimpleBodyParser;
import pluto.util.StringConvertUtil;

/**
 * SMS 컨텐츠에 관련된 작업을 처리함.
 * 
 * @version
 * @author dragon
 *  
 */
public class SmsBodyParser extends SimpleBodyParser {
	/** Creates a new instance of SmsBodyParser */
	public SmsBodyParser() {
		super();
		setName("SmsBodyParser");
	}

	public synchronized void setContents(String src) throws Exception {

		this.origin = src;
		this.contents = src;
	}

	public void setContents(String original, String contents, String name) throws Exception {

		this.origin = original;
		this.contents = contents;
		setName(name);
	}
	/**
	 * info1의 내용을 매핑하여 컨텐츠를 반환함. <br>
	 * 특이사항 >> info2를 전혀 사용하지 않고 있음
	 * 
	 * @param info1
	 * @param info2
	 * @return
	 * @throws Exception
	 */
	public String convert(Object info1, Object info2) throws Exception {

		StringBuffer buffer = new StringBuffer(1024);

		StringConvertUtil.ConvertString(buffer, this.contents, info1, "${", "}", false, false);
		return buffer.toString();
	}
}
