/*
 * @(#)SingleRcptTrackingContentPD.java            2008. 5. 19.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.mass.webproducer;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.parser.LinkParser;
import mercury.contents.common.producer.CommonContentPD;
import mercury.contents.common.util.LinkContent;
import mercury.contents.common.util.MappingImgStripper;
import mercury.contents.common.util.TrackingInfoConvertor;
import mercury.contents.mass.research.ResearchMetaData;
import mercury.contents.mass.research.ResearchModifier;
import mercury.contents.mass.webpoll.WebPollModifier;
import mercury.contents.mass.webresearch.WebResearchMetaData;
import mercury.contents.mass.webresearch.WebResearchModifier;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

/**
 * (웹게시설문포함)원투원인 경우 트래킹 정보 삽입해서 컨텐츠 만드는 녀석
 * 
 * @version
 * @author jini
 *  
 */
@Slf4j
public class SingleRcptTrackingContentPD extends CommonContentPD {

	/**
	 * 클릭정보를 EBAD0051테이블에 INSERT하는 쿼리
	 */
	protected static String			QUERY_INSERT_LINKINFO					= null;
	
	protected static String			QUERY_UPDATE_LINKINFO					= null;

	/**
	 * 설문 정보를 EBAD0061테이블에 INSERT하는 쿼리
	 */
	protected static String			QUERY_INSERT_RESEARCH_INFO				= null;

	/**
	 * 초기 발송이나 테스트 발송일 경우에 다시 트래킹 정보를 작성하기 위하여 기존의 정보를 삭제하는 쿼리
	 */
	protected static String			QUERY_DELETE_TRACKING_INFO				= null;

	/**
	 * 설문일경우 CONTENT_PATTERN을 업데이트하는 쿼리
	 */
	protected static String			QUERY_UPDATE_RESEARCH_CONTENT_PATTERN	= null;
	
	/**
	 * 설문HTML 정보가져오는 쿼리
	 */
	protected static String 		QUERY_SELECT_POLLHTML_INFO = null;

	/**
	 * 트래킹 URL
	 */
	protected static String			TRACKING_URL							= null;

	/**
	 * 트래킹 URL
	 */
	protected static String			ALPHA2_TRACKING_URL							= null;

	/**
	 * 일단은 모두 매핑 헤더가 동일하므로 그냥 간다.
	 */
	public static String			DEFAULT_SINGLE_MAPPING_HEADER			= null;

	static {
		try {
			QUERY_INSERT_LINKINFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_INSERT_LINKINFO");
			QUERY_UPDATE_LINKINFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_UPDATE_LINKINFO");
			QUERY_INSERT_RESEARCH_INFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_INSERT_RESEARCH_INFO");
			QUERY_UPDATE_RESEARCH_CONTENT_PATTERN = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_UPDATE_RESEARCH_CONTENT_PATTERN");
			QUERY_DELETE_TRACKING_INFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_DELETE_TRACKING_INFO");
			QUERY_SELECT_POLLHTML_INFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_SELECT_POLLHTML_INFO");
					
		}
		catch(Exception e) {
			log.error("Exception",e);
		}

		DEFAULT_SINGLE_MAPPING_HEADER = eMsSystem.getProperty("default.single.mapping.header");

		////////////////////////////////////////////////////////////////////////////////////////
		//add by suckhong 구매연동을 위하여 암호화 되지 않은 p_id값과  m_id값을 클릭에 추가 하여 발송한다.
		TRACKING_URL = eMsSystem.getProperty("tracking.url").concat("?${enc_mid}&${enc_s_type}&p_id=${real_p_id}&m_id=${m_id}&s_tp=${s_type}&");

		ALPHA2_TRACKING_URL = eMsSystem.getProperty("alpha2.tracking.url");
	}

	protected String				instance_TRACKING_URL					= null;

	protected String				instance_ADD_URL_STRING					= null;

	/** Creates a new instance of MassDirectContentPD */
	public SingleRcptTrackingContentPD() {
	}

	protected void initProperty(Properties info) throws Exception {
		super.initProperty(info);

		this.POST_ID = this.SCHEDULE_INFO.getProperty("POST_ID");

		setName(this.POST_ID + "_MassTrackingContentPD");
		/**
		 * 파일이름 지정
		 */
		this.WORK_FILE_ID = this.POST_ID.concat("_o_real_").concat(Cal.getSerialDate());

		this.TMP_BUFFER.setLength(0);
		this.TMP_BUFFER.append(TRACKING_URL);
		this.TMP_BUFFER.append(TrackingInfoConvertor.enc_LIST_TABLE(this.SCHEDULE_INFO.getProperty("LIST_TABLE")));
		this.TMP_BUFFER.append("&");
		this.TMP_BUFFER.append(TrackingInfoConvertor.enc_MAIL_ID(this.POST_ID));
		this.TMP_BUFFER.append("&");
		this.TMP_BUFFER.append(TrackingInfoConvertor.enc_CLOSE(this.SCHEDULE_INFO.getProperty("CLOSE_DATE")));
		this.TMP_BUFFER.append("&");

		this.instance_TRACKING_URL = this.TMP_BUFFER.toString();

		this.instance_ATTACH_CONTENT_SELECT_QUERY = StringUtil.ConvertString(SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS",
				"QUERY_SELECT_ATTACH_CONTENT"), this.SCHEDULE_INFO, "${", "}");
	}

	protected String execute_ContentProcess(String source) throws Exception {

		if (log.isDebugEnabled()) 
			log.debug("src=>", source);
		String strip_img_source = MappingImgStripper.process(source);
		if (log.isDebugEnabled()) 
			log.debug("result=>", source);
		/**
		 * 트래킹 유무에 따라 파싱 아니면 그냥 저장
		 */
		if( this.SCHEDULE_INFO.getProperty("TRACKING_YN", "N").equalsIgnoreCase("Y")
				&& this.SCHEDULE_INFO.getProperty("CONTENT_TYPE", "T").equalsIgnoreCase("H") ) {
			// 트래킹을 할경우에는 트래킹 파싱 로직을 호출한다.
			// 컨텐트를 저장하는 로직은 execute_ContentTrackingParsing 안에서 호출을 한다.
			// 링크를 파싱할때 임시로 사용하는 버퍼를 만들어서 보내는 로직으로 변경 2004.11.02
			StringBuffer tmpBuffer = null;
			try {
				tmpBuffer = new StringBuffer(2048);
				return execute_ContentTrackingParsing(strip_img_source, tmpBuffer);
			}
			finally {
				tmpBuffer = null;
			}
		}
		// 트래킹 파싱이 없을 경우 그냥 컨텐트를 저장한다.
		return strip_img_source;
	}

	protected String getMappingHeader() throws Exception {

		return this.SCHEDULE_INFO.getProperty("MAPPINGHEADER", DEFAULT_SINGLE_MAPPING_HEADER);
	}

	protected String execute_ContentTrackingParsing(String source, StringBuffer tmpBuffer) throws Exception {

		/**
		 * 링크정보를 전송할 녀석이다
		 */
		LinkContent __LINK_CONTENT__ = null;

		int __LINK_INDEX__ = 0;

		boolean TRACKING_INFO_PROCESS = this.SCHEDULE_INFO.getProperty("CONTENT_INFO_UPDATE_FLAG", "Y").equals("Y");

		if( this.SCHEDULE_INFO.getProperty("CLICK_YN", "N").equalsIgnoreCase("Y") ) {
			// 링크파싱한 결과를 저장하기 위한 버퍼 초기화
			this.TMP_BUFFER.setLength(0);

			log.debug( "Start Link Parsing");

			LinkParser __LINK_PARSER__ = new LinkParser();
			__LINK_PARSER__.parse(source);
			
			String addedParam = this.SCHEDULE_INFO.getProperty("WEB_TRACKING_FLAG","N").equals("Y")?
					ALPHA2_TRACKING_URL:"";

			for (Iterator iter = __LINK_PARSER__.iterator(); iter.hasNext();) {
				Object __TMP_CONTENT__ = iter.next();

				if( __TMP_CONTENT__ instanceof LinkContent ) {
					// 링크 인덱스를 하나 올리고
					__LINK_INDEX__++;
					__LINK_CONTENT__ = (LinkContent) __TMP_CONTENT__;

					if( __LINK_CONTENT__.getUrl().startsWith("http") ) {
						tmpBuffer.setLength(0);
						tmpBuffer.append(instance_TRACKING_URL);

						tmpBuffer.append(TrackingInfoConvertor.enc_KIND("C"));
						tmpBuffer.append("&");
						tmpBuffer.append(TrackingInfoConvertor.enc_CID(__LINK_CONTENT__.getID()));
						
						// 웹트랙 분석을 위해서 수정
						if( addedParam.length() > 0 ) 							
						    tmpBuffer.append("&WEBTRACK=${FIELD1}${FIELD2}${FIELD3}${FIELD4}");						    
						
						////////////////////////////////////////////////////////////////////
						//add hong 암호화 되지 않은 c_id추가
						tmpBuffer.append("&c_id=");
						tmpBuffer.append(__LINK_CONTENT__.getID());
						
						tmpBuffer.append("&URL=");
						tmpBuffer.append(__LINK_CONTENT__.getUrl());							

						if( instance_ADD_URL_STRING != null ) {
							if( __LINK_CONTENT__.getUrl().indexOf("?") > 0 ) {
								tmpBuffer.append("&");
							}
							else {
								tmpBuffer.append("?");
							}
							tmpBuffer.append(instance_ADD_URL_STRING);
						}

						this.TMP_BUFFER.append(__LINK_CONTENT__.getLinkConvert(tmpBuffer.toString()));
					}
					else { // http로 시작하지 않는 URL일 경우
						this.TMP_BUFFER.append(__TMP_CONTENT__.toString());
						iter.remove();
					}
				}
				else { // 링크부분이 아닐경우
					this.TMP_BUFFER.append(__TMP_CONTENT__.toString());
					iter.remove();
				}
			}
			// __LINK_PARSER__ for loop end

			source = this.TMP_BUFFER.toString();

			//트래킹 정보를 처리하려면 일단 기존 입력된 정보를 다~~~ 지워야 하쥐...
			if( TRACKING_INFO_PROCESS ) {
				log.debug( "Delete Current Link Info");
				deleteTrackingInfo();
				
				log.debug( "Insert Parsed Link Info");
				StroreTrackingInfoToDB(__LINK_PARSER__);
			}
			else {
				log.debug( "Skip Parsed Link Info");
			}

			log.debug( "End Link Parsing");
		}
		// Tracking YN if end 클릭 트래킹 파싱종료

		/**
		 * 설문은 기본으로 파싱을 한다.
		 * 웹에서 처리하는 것으로 수정을 했다.
		 */
		if( source.indexOf("${map_link}") > -1 )	//웹게시설문일 경우 
		{
			log.info("[WEB RESEARCH START!!!!!!!!!!!]");
			WebPollModifier __WEB_POLL_MODIFIER__ = new WebPollModifier(this.SCHEDULE_INFO);
			WebResearchModifier __WEB_RESEARCH_MODIFIER__ = new WebResearchModifier(this.SCHEDULE_INFO);
			if(__WEB_POLL_MODIFIER__.process(source, __LINK_INDEX__++))
			{
				source = __WEB_POLL_MODIFIER__.getModify();
			}
			log.info("[WEB RESEARCH END!!!!!!!!!!!]");
		}else{					
			ResearchModifier __RESEARCH_MODIFIER__ = new ResearchModifier(this.SCHEDULE_INFO);
	
			if( __RESEARCH_MODIFIER__.process(source, __LINK_INDEX__++) ) {
				if( TRACKING_INFO_PROCESS ) {
					log.debug( "Research data DB update");
	
					setResearchInfo(__RESEARCH_MODIFIER__);
	
				}
				else {
					log.debug( "JOB_STATUS : " + this.SCHEDULE_INFO.getProperty("JOB_STATUS", "35"));
					log.debug( "SO DB INSERT SKIP ");
				}
	
				source = __RESEARCH_MODIFIER__.getModify();
			}
		}
		log.debug( "Research Parsing [END]");

		this.TMP_BUFFER.setLength(0);
		/**
		 * Include 와 같이 Content 윗단에 추가되는 부분
		 */
		String addedInclude = this.SCHEDULE_INFO.getProperty("WEB_TRACKING_INCLUDE", "" );
		
		this.TMP_BUFFER.append( addedInclude );
		this.TMP_BUFFER.append(source);
		int __BODY_INDEX__ = source.toLowerCase().indexOf("</body");
		
		__BODY_INDEX__ += addedInclude.length();

		/**
		 * 열독률이 체크가 되었다면 추가한다.
		 */
		if( this.SCHEDULE_INFO.getProperty("DUR_YN", "N").equalsIgnoreCase("Y") ) {
			tmpBuffer.setLength(0);
			tmpBuffer.append("\r\n<iframe src=\"");
			tmpBuffer.append(instance_TRACKING_URL);

			tmpBuffer.append(TrackingInfoConvertor.enc_KIND("D"));
			tmpBuffer.append("\" frameborder=\"0\" width=\"1\" height=\"1\"></iframe>\r\n");

			if( __BODY_INDEX__ > 0 ) {
				this.TMP_BUFFER.insert(__BODY_INDEX__, tmpBuffer.toString());
			}
			else {
				this.TMP_BUFFER.append(tmpBuffer.toString());
			}
		}

		/**
		 * 오픈이 체크가 되었다면 추가한다.
		 */
		if( this.SCHEDULE_INFO.getProperty("OPEN_YN", "N").equalsIgnoreCase("Y") ) {
			tmpBuffer.setLength(0);
			tmpBuffer.append("<div style=\"display:none\">");
			tmpBuffer.append("<img src=\"");
			tmpBuffer.append(instance_TRACKING_URL);

			tmpBuffer.append(TrackingInfoConvertor.enc_KIND("O"));
			tmpBuffer.append("\" width=1 height=1>");
			tmpBuffer.append("</div>");

			if( __BODY_INDEX__ > 0 ) {
				this.TMP_BUFFER.insert(__BODY_INDEX__, tmpBuffer.toString());
			}
			else {
				this.TMP_BUFFER.append(tmpBuffer.toString());
			}
		}

		return this.TMP_BUFFER.toString();
	}

	/**
	 * 파싱된 링크 정보를 데이터 베이스로 반영하는 로직이당...
	 */
	protected void StroreTrackingInfoToDB(List __LINK_INFOS__) throws Exception {
		// 연결 갱신
		this.refreshDBConnection();

		eMsPreparedStatement __PS_INSERT_LINKINFO__ = null;
		eMsPreparedStatement __PS_UPDATE_LINKINFO__ = null;

		Exception ex = null;

		try {
			// 파싱된 링크정보를 데이터 베이스에 반영을 한다.
			__PS_INSERT_LINKINFO__ = this.EMS_CONNECTION.prepareStatement(QUERY_INSERT_LINKINFO, "${", "}");
			__PS_UPDATE_LINKINFO__ = this.EMS_CONNECTION.prepareStatement(QUERY_UPDATE_LINKINFO, "${", "}");

			LinkContent __LINK_CONTENT__ = null;

			String __TMP_CONTENT__ = null;

			Properties __LINK_UPDATE_PROPERTIES__ = new Properties();
			

			//이숍,E스토어,기획전 ID값 버퍼
			String __GUME_ID_BUFFER_ECPID__ = "";
			String __GUME_ID_BUFFER_HI_PRDID__ = "";
			String __GUME_ID_BUFFER_PLANSEQ__ = "";
			//링크정보 업데이트 쿼리에서 사용할때 전체 스케쥴 정보를 넣어준다.
			//그래야 업데이트가 가능하니까...
			__LINK_UPDATE_PROPERTIES__.putAll(this.SCHEDULE_INFO);

			for (Iterator __ITERATOR__ = __LINK_INFOS__.iterator(); __ITERATOR__.hasNext();) {
				__LINK_CONTENT__ = (LinkContent) __ITERATOR__.next();

				__TMP_CONTENT__ = __LINK_CONTENT__.getContent();

				if( __TMP_CONTENT__.length() > eMsLocale.LINK_LENGTH_LIMIT ) {
					__TMP_CONTENT__ = __TMP_CONTENT__.substring(0, eMsLocale.LINK_LENGTH_LIMIT);
				}

				__LINK_UPDATE_PROPERTIES__.setProperty("CLICK_ID", __LINK_CONTENT__.getID());
				__LINK_UPDATE_PROPERTIES__.setProperty("CLICK_DESC", __TMP_CONTENT__);
				__LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL", __LINK_CONTENT__.getUrl());
				
				
				
				
				////////////////////////////////////////////////////////////
				// add by suckhong
				String Gume_id_value_eshop = null;	//상품 클릭 여부의 eshop delimiter 값
				String Gume_id_value_estore = null;	//상품 클릭 여부의 estore delimiter 값
				String Gume_id_value_plan = null;	//상품 클릭 여부의 기획전 delimiter 값
				
				String Url = null;	//해당 Url값
				int Url_lenght = 0; //해당 Url 길이 
				int Gume_length = 0;	//구매 아이디 까지의 길이
				
				Gume_id_value_eshop = eMsSystem.getProperty("gume.click.delimiter1");
				Gume_id_value_estore = eMsSystem.getProperty("gume.click.delimiter2");
				Gume_id_value_plan = eMsSystem.getProperty("gume.click.delimiter3");
				
				Url = __LINK_CONTENT__.getUrl();

				//상품 클릭(ecpid,hi_prdid,planPrd)이라면
				if(Url.indexOf(Gume_id_value_eshop) > 0 || Url.indexOf(Gume_id_value_estore) > 0 || Url.indexOf(Gume_id_value_plan) > 0){
					//eshop상품(ecpid)클릭 이라면
					if(Url.indexOf(Gume_id_value_eshop) > 0){
						__LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL_GUME_YN", "true");	//상품클릭 여부를 0051테이블에 true로 업데이트
						Gume_length = Url.indexOf(Gume_id_value_eshop)+Gume_id_value_eshop.length()+1; //코드값 앞까지의 길이를 구하고					
						if(Url.indexOf("&") > 0 && (Url.indexOf(Gume_id_value_eshop)<Url.indexOf("&"))){	//코드값뒤에 &여부에 따라 해당 코드값만 잘라내어 버퍼에 추가
							__GUME_ID_BUFFER_ECPID__+=("|"+Url.substring(Gume_length, Url.indexOf("&"))+"|");
						}
						else{
							__GUME_ID_BUFFER_ECPID__+=("|"+Url.substring(Gume_length)+"|");
						}
					}
					else if(Url.indexOf(Gume_id_value_estore) > 0){	//estore상품(hi_prdid)클릭 이라면
						__LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL_GUME_YN", "true");	//상품클릭 여부를 0051테이블에 true로 업데이트
						if(Url.indexOf("&") > 0 && (Url.indexOf(Gume_id_value_estore)<Url.indexOf("&"))){	//코드값뒤에 &여부에 따라 해당 코드값만 잘라내어 버퍼에 추가
							__GUME_ID_BUFFER_HI_PRDID__+=("|"+Url.substring(Gume_length, Url.indexOf("&"))+"|");
						}
						else{
							__GUME_ID_BUFFER_HI_PRDID__+=("|"+Url.substring(Gume_length)+"|");
						}
					}
					else if(Url.indexOf(Gume_id_value_plan) > 0){	//estore상품(hi_prdid)클릭 이라면{//기획전(planseq)클릭 이라면
						__LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL_GUME_YN", "planseq");	//상품클릭 여부를 0051테이블에 planseq로 업데이트
						Gume_length = Url.indexOf(Gume_id_value_plan)+Gume_id_value_plan.length()+1; //코드값 앞까지의 길이를 구하고					
						if(Url.indexOf("&") > 0 && (Url.indexOf(Gume_id_value_plan)<Url.indexOf("&"))){	//코드값뒤에 &여부에 따라 해당 코드값만 잘라내어 버퍼에 추가							
							__GUME_ID_BUFFER_PLANSEQ__+=("|"+Url.substring(Gume_length, Url.indexOf("&"))+"|");
						}
						else{
							__GUME_ID_BUFFER_PLANSEQ__+=("|"+Url.substring(Gume_length)+"|");
						}
					}
					
				}
				else{
					__LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL_GUME_YN", "false");
				}
				
				///////////////////////////////////////////////////////////////
				
				
				try {
					__PS_INSERT_LINKINFO__.executeUpdate(__LINK_UPDATE_PROPERTIES__);
				}
				catch(SQLException e) {				
					log.error(getName(), e);
				}
			}
			__LINK_UPDATE_PROPERTIES__.setProperty("GUME_ID_ECPID", __GUME_ID_BUFFER_ECPID__);
			__LINK_UPDATE_PROPERTIES__.setProperty("GUME_ID_HI_PRDID", __GUME_ID_BUFFER_HI_PRDID__);
			__LINK_UPDATE_PROPERTIES__.setProperty("GUME_ID_PLANSEQ", __GUME_ID_BUFFER_PLANSEQ__);
			
			try {
			__PS_UPDATE_LINKINFO__.executeUpdate(__LINK_UPDATE_PROPERTIES__);
			}
			catch(SQLException e) {
				log.info(getName(), e);
			}
		}
		catch(Throwable e) {
			log.error(getName(), e);
			ex = new Exception(e.toString());
			throw ex;
		}
		finally {
			try {
				__PS_INSERT_LINKINFO__.close();
				__PS_UPDATE_LINKINFO__.close();
			}
			catch(Exception e) {
			}
		}
	}

	protected void deleteTrackingInfo() throws Exception {
		this.refreshDBConnection();

		eMsStatement stmt = null;
		try {
			stmt = this.EMS_CONNECTION.createStatement();
			// 버퍼를사용한 쿼리 변경으로 ... 2004.11.02
			this.TMP_BUFFER.setLength(0);
			StringConvertUtil.ConvertString(this.TMP_BUFFER, QUERY_DELETE_TRACKING_INFO, this.SCHEDULE_INFO, "${", "}", true, false);
			stmt.executeUpdate(this.TMP_BUFFER.toString());
		}
		finally {
			this.EMS_CONNECTION.recycleStatement(stmt);
		}
	}

	/**
	 * 설문정보를 인서트하는 로직인다.
	 */
	protected void setResearchInfo(List __RESEARCH_MODIFIER__) throws Exception {
		// 연결 갱신
		this.refreshDBConnection();

		// 쿼리를 변환하여 실행하는 로직에서 PS를사용하여 인서트하는 로직으로 변경 2004.11.02
		eMsPreparedStatement __PS_INSERT_REINFO__ = null;

		eMsStatement stmt = null;
		try {
			stmt = this.EMS_CONNECTION.createStatement();
			stmt.executeUpdate(QUERY_UPDATE_RESEARCH_CONTENT_PATTERN, this.SCHEDULE_INFO, "${", "}");
			// 파싱된 링크정보를 데이터 베이스에 반영을 한다.
			__PS_INSERT_REINFO__ = this.EMS_CONNECTION.prepareStatement(QUERY_INSERT_RESEARCH_INFO, "${", "}");

			// 설문정보를 담아 업데이트할 Properties
			Properties __RESEARCH_PROPERTIES__ = new Properties();

			//링크정보 업데이트 쿼리에서 사용할때 전체 스케쥴 정보를 넣어준다.
			//그래야 업데이트가 가능하니까...
			__RESEARCH_PROPERTIES__.putAll(this.SCHEDULE_INFO);

			for (Iterator iter = __RESEARCH_MODIFIER__.iterator(); iter.hasNext();) {
				ResearchMetaData tmp = (ResearchMetaData) iter.next();

				__RESEARCH_PROPERTIES__.setProperty("CLICK_ID", tmp.getClickId());
				__RESEARCH_PROPERTIES__.setProperty("CLICK_DESC", tmp.getDesc());
				__RESEARCH_PROPERTIES__.setProperty("Q_NO", tmp.getName());
				__RESEARCH_PROPERTIES__.setProperty("ANSWER_B", tmp.getValue());
				__RESEARCH_PROPERTIES__.setProperty("Q_TYPE", tmp.getType());
				
				__PS_INSERT_REINFO__.executeUpdate(__RESEARCH_PROPERTIES__);
			}
		}
		catch(Throwable e) {
			throw new Exception(e.toString());
		}
		finally {
			this.EMS_CONNECTION.recycleStatement(stmt);
			try {
				if(__PS_INSERT_REINFO__ != null) {
					__PS_INSERT_REINFO__.close();
				}
			}
			catch(Exception e) {
			}
		}
	}
	
	/**
	 * 웹게시설문정보를 인서트하는 로직인다.
	 */
	protected void setWebResearchInfo(List __RESEARCH_MODIFIER__) throws Exception {
		// 연결 갱신
		this.refreshDBConnection();

		// 쿼리를 변환하여 실행하는 로직에서 PS를사용하여 인서트하는 로직으로 변경 2004.11.02
		eMsPreparedStatement __PS_INSERT_REINFO__ = null;

		eMsStatement stmt = null;
		try {
			stmt = this.EMS_CONNECTION.createStatement();
			stmt.executeUpdate(QUERY_UPDATE_RESEARCH_CONTENT_PATTERN, this.SCHEDULE_INFO, "${", "}");
			// 파싱된 링크정보를 데이터 베이스에 반영을 한다.
			__PS_INSERT_REINFO__ = this.EMS_CONNECTION.prepareStatement(QUERY_INSERT_RESEARCH_INFO, "${", "}");

			// 설문정보를 담아 업데이트할 Properties
			Properties __RESEARCH_PROPERTIES__ = new Properties();

			//링크정보 업데이트 쿼리에서 사용할때 전체 스케쥴 정보를 넣어준다.
			//그래야 업데이트가 가능하니까...
			__RESEARCH_PROPERTIES__.putAll(this.SCHEDULE_INFO);

			for (Iterator iter = __RESEARCH_MODIFIER__.iterator(); iter.hasNext();) {
				WebResearchMetaData tmp = (WebResearchMetaData) iter.next();

				__RESEARCH_PROPERTIES__.setProperty("CLICK_ID", tmp.getClickId());
				__RESEARCH_PROPERTIES__.setProperty("CLICK_DESC", tmp.getDesc());
				__RESEARCH_PROPERTIES__.setProperty("Q_NO", tmp.getName());
				__RESEARCH_PROPERTIES__.setProperty("ANSWER_B", tmp.getValue());
				__RESEARCH_PROPERTIES__.setProperty("Q_TYPE", tmp.getType());
								
				__PS_INSERT_REINFO__.executeUpdate(__RESEARCH_PROPERTIES__);
			}
		}
		catch(Throwable e) {
			throw new Exception(e.toString());
		}
		finally {
			this.EMS_CONNECTION.recycleStatement(stmt);
			try {
				if(__PS_INSERT_REINFO__ != null) {
					__PS_INSERT_REINFO__.close();
				}
			}
			catch(Exception e) {
			}
		}
	}
}

