/*
 * @(#)ResearchModifier.java            2004. 11. 26.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.mass.research;

import java.util.Properties;
import java.util.Vector;

import lombok.extern.slf4j.Slf4j;
import pluto.config.eMsSystem;
import pluto.lang.eMsTypes;
import pluto.util.StringConvertUtil;

/**
 * 설문 제작물을 만든다
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class ResearchModifier extends Vector {
	
	public static String RESEARCH_FORM_START = null;
	public static String RESEARCH_SUBMIT_BUTTON = null;
	
	private String body = null;
	private int link_index = 0;
	
	FormTokenizer myFormTokenizer = new FormTokenizer();
	
	private String PARSED_RESULT_STRING = null;
	
	static {
		RESEARCH_FORM_START = eMsSystem.getProperty("ems.research.tag","defaultadd");
		RESEARCH_SUBMIT_BUTTON = eMsSystem.getProperty("ems.submit.button","submit button");
	}
	
	protected Properties SCHEDULE_INFO = null;
	
	/** Creates new ResearchModifier */
	public ResearchModifier() throws Exception {
	}
	
	public ResearchModifier( Properties prop ) throws Exception {
		SCHEDULE_INFO = prop;
	}
	
	public String getModify() {
		return this.PARSED_RESULT_STRING;
	}
	
	public boolean process(String content , int idx) {
		
		this.body = content;
		this.link_index = idx + 1;
		
		String source = this.body.toLowerCase();
		
		if( source.indexOf( "${map_re}" ) < 0 ) return false;
		
		if( source.indexOf( "<form" ) < 0 ) {
			this.body = addForm( this.body );
			source = this.body.toLowerCase();
		}
		
		int idx1 = 0;
		int idx2 = 0;
		
		int idxSF = 0;
		int idxEF = 0;
		
		StringBuffer buffer = null;
		
		try{
			buffer = new StringBuffer(1024);
			buffer.setLength( 0 );
			while( true ) {
				idx1 = source.indexOf( "<form" , idx2 );
				
				if( idx1 < 0 ) break;
				
				buffer.append( this.body.substring( idx2 , idx1 ) );
				
				idxSF = source.indexOf( ">" , idx1 );
				
				/**form 을 제외한 알맹이 시작을 찾는다.
				 */
				if( idxSF < 0 ) break;
				idxSF++;
				
				idxEF = source.indexOf( "</form" , idx1 );
				
				if( idxEF < 0 ) break;
				
				idx2 = source.indexOf( ">" , idxEF );
				
				if( idx2 < 0 ) break;
				
				idx2++;
				
				if( source.substring( idx1 , idx2 ).indexOf( "${map_re}" ) > 0 ) {
					/**form 을 제외한 알맹이만 파싱한다.
					 */
					try {
						buffer.append( convertForm( this.body.substring( idxSF , idxEF ) ) );
					}
					catch( Exception e ) {
						log.error("Exception",e);
						buffer.append( this.body.substring( idx1 , idx2 ) );
					}
				}
				else{
					buffer.append( this.body.substring( idx1 , idx2 ) );
				}
			}
			
			if( idx1 < 0 ) buffer.append( this.body.substring( idx2 ) );
			
			if( idx2 < 0 ) buffer.append( this.body.substring( idx1 ) );
			
			this.PARSED_RESULT_STRING = buffer.toString();
		}
		catch( RuntimeException e ){
			throw e;
		}
		finally{
			buffer = null;
		}
		return true;
	}
	
	/**form 구역을 파싱한다.
	 */
	protected String convertForm( String src ) throws Exception {
		StringBuffer buffer = null;
		
		try{
			buffer = new StringBuffer(1024);
			buffer.setLength( 0 );
			
			StringConvertUtil.ConvertString(  buffer , RESEARCH_FORM_START , this.SCHEDULE_INFO , "${" , "}" , false , true );
			//buffer.append( StringUtil.ConvertContainKeyOnlyString( RESEARCH_FORM_START , this.SCHEDULE_INFO , "${" , "}" )  );
			buffer.append( "\r\n");
			buffer.append( "<input type=\"hidden\" name=\"emsinfo_" );
			buffer.append( String.valueOf( this.link_index++ ) );
			buffer.append( "\" value=\"-1\">\r\n" );
			
			myFormTokenizer.process( src );
			
			/**form tag 정보를 append 한다.
			 */
			for( int i=0; i<myFormTokenizer.size(); i++) {
				AnsProperty oneAp = (AnsProperty)myFormTokenizer.elementAt(i);
				String name = oneAp.getNAME();
				short type = oneAp.getTYPE();
				Vector values = oneAp.getVALUE();
				
				for( int j=0; j<values.size(); j++) {
					String typeStr = null;
					switch( type ) {
						case eMsTypes.FORM_SELECT_TYPE: {
							typeStr = eMsTypes.FORM_SELECT_DISPLAY;
							break;
						}
						case eMsTypes.FORM_TEXT_TYPE: {
							typeStr = eMsTypes.FORM_TEXT_DISPLAY;
							break;
						}
						case eMsTypes.FORM_RADIO_TYPE: {
							typeStr = eMsTypes.FORM_RADIO_DISPLAY;
							break;
						}
						case eMsTypes.FORM_CHECKBOX_TYPE: {
							typeStr = eMsTypes.FORM_CHECKBOX_DISPLAY;
							break;
						}
						case eMsTypes.FORM_TEXTAREA_TYPE: {
							typeStr = eMsTypes.FORM_TEXTAREA_DISPLAY;
							break;
						}
						default: {
							typeStr = "Unknown";
						}
					}
					
					String oneValue = (String)values.elementAt(j);
					String tempValue = type + "_" + name + "_" + oneValue;
					String desc = name + "(" + oneValue + ") : " + typeStr;
					String tempName = "emsinfo_" + this.link_index;
					
					this.addElement( new ResearchMetaData(this.link_index, desc , name, oneValue, type ) );
					
					if (log.isDebugEnabled())  log.debug( "Debug: " + desc );
					buffer.append("<input type=\"hidden\" name=\"" );
					buffer.append( tempName );
					buffer.append( "\" value=\"" );
					buffer.append( tempValue );
					buffer.append( "\">\r\n" );
					
					this.link_index++;
				}
			}
			// 데이터 추가가 종료된다.
			
			/**원래 form 내용을 append하고 form tag를 종료한다.
			 */
			buffer.append( src );
			buffer.append( "\r\n</form>" );
			
			return buffer.toString().replaceAll( "\\$\\{map_re\\}" , RESEARCH_SUBMIT_BUTTON);
		}
		catch( Exception e ){
			throw e;
		}
		finally{
			buffer = null;
		}
	}
	
	protected String addForm( String source ) {
		String src = source.toLowerCase();
		
		int idx1 = src.indexOf( "<body" );
		
		if( idx1 < 0 ) return src;
		
		int idx2 = src.indexOf( ">" , idx1 );
		
		if( idx2 < 0 ) return src;
		
		int insert_start_point = idx2 + 1;
		
		idx1 = src.indexOf( "</body" , insert_start_point );
		
		if( idx1 < 0 ) return src;
		
		StringBuffer buffer = null;
		try{
			buffer = new StringBuffer(1024);
			buffer.setLength( 0 );
			buffer.append( source );
			buffer.insert( idx1 , "</form>" );
			buffer.insert( insert_start_point , "<form>" );
			
			return buffer.toString();
		}
		finally{
			buffer = null;
		}
	}
}
