/*
 * @(#)ResearchMetaData.java            2004. 11. 26.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.mass.research;

import pluto.lang.eMsTypes;

/**
 * 설문 문항들 정보, 설문 문항의 각 답변당 생성된다
 * 
 * @version
 * @author dragon
 *  
 */
public class ResearchMetaData {
	public String	DESC;

	public String	NAME;

	public String	VALUE;

	public String	CLICKID;

	public String	TYPE;

	private short	type;

	protected ResearchMetaData(int clickIdInt, String desc, String name, String value, short type) {
		this.CLICKID = Integer.toString(clickIdInt);

		while (this.CLICKID.length() < 3) {
			this.CLICKID = "0".concat(this.CLICKID);
		}

		this.DESC = desc;
		this.NAME = name;
		this.VALUE = value;
		this.TYPE = Short.toString(type);
		this.type = type;
	}

	public String getClickId() {
		return this.CLICKID;
	}

	public String getDesc() {
		return this.DESC;
	}

	public String getName() {
		return this.NAME;
	}

	public String getValue() {
		if( (type == eMsTypes.FORM_TEXT_TYPE || type == eMsTypes.FORM_TEXTAREA_TYPE) && this.VALUE.length() < 1 ) {
			return "ZZZZZ";
		}
		return this.VALUE;
	}

	public String getType() {
		return this.TYPE;
	}
}
