/*
 * @(#)FormTokenizer.java            2004. 11. 26.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.mass.research;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Vector;

import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.util.StringUtil;
/**
 *  설문 제작물을 설문 항목들을 꺼내 AnsProperty에 각각 담아 메모리에 적재시킨다
 * 
 * @version		
 * @author 		dragon
 *
 */
public class FormTokenizer extends Vector
{
	private static final String TAG_START = "<";
	private static final String TAG_END = ">";
	
	protected static ByteArrayOutputStream INNER_BUFFER = new ByteArrayOutputStream( 1024 );
	
	/** Creates new HTMLTokenizer */
	public FormTokenizer() {
		super();
	}
	
	public void process( File src ) throws Exception
	{
		String body = null;
		
		synchronized( INNER_BUFFER ){
			INNER_BUFFER.reset();
			FileElement.putFileBody( src , INNER_BUFFER );
			body = INNER_BUFFER.toString( eMsLocale.FILE_SYSTEM_IN_CHAR_SET );
		}
		
		process( body );
	}
	
	/**
	 */
	public void process( String src )
	{
		/**파싱을 시작하기 전에 초기화 한다.
		 */
		this.clear();

		String source = src.toLowerCase();
		
		int idx1 = 0;
		int idx2 = 0;
		int idx3 = 0;
		
		String tag = null;
		
		while( true )
		{
			idx1 = source.indexOf( TAG_START , idx2 );
			
			if( idx1 < 0 ) break;
			
			idx2 = source.indexOf( TAG_END , idx1 );
			
			if( idx2 < 0 ) break;
			
			idx2++;
			
			tag = source.substring( idx1 , idx2 );
			
			/**테그가 결정되면 각 테그 별로 처리루틴을 돌린다.
			 */
			// select
			if( tag.startsWith( "<select " ) )
			{
				idx3 = source.indexOf( "/select>" , idx2 );
				
				/**select의 닫는 테그가 존재하지 않으면 그냥 select만 추가하고 지나간다.
				 */
				if( idx3 < 0 )
				{
					continue;
				}
				idx2 =idx3+8;
				parseSelect( src.substring( idx1 , idx2) );
				continue;
			}
			
			//input
			if( tag.startsWith( "<input " ) )
			{
				parseInput( src.substring( idx1 , idx2) );
				continue;
			}
			
			//textarea
			if( tag.startsWith( "<textarea " ) )
			{
				idx3 = source.indexOf( "/textarea>" , idx2 );
				/**select의 닫는 테그가 존재하지 않으면 그냥 select만 추가하고 지나간다.
				 */
				if( idx3 < 0 )
				{
					continue;
				}
				idx2 =idx3+10;
				parseTextArea( source.substring( idx1 , idx2) );
				continue;
			}
		}
		
		/**설문 값들을 골라내는 작업을 종료하고 이제 컨텐트를 재조립한다.
		 */
	}
	
	private void parseSelect( String src )
	{
		String source = src.toLowerCase();
		
		int idx3 = 0;
		int idx1 = 0;
		int idx2 = source.indexOf( TAG_END );
		
		if( idx2 < 0 ) return;
		String tag = src.substring( 0 , idx2 + 1 );
		
		String name = StringUtil.getAttribute(tag,"name");
		
		String tmpValue = null;
		
		Vector listValue = new Vector();
		/**option value를 쭉~~~! 검색해서 Vector에 적재한다.
		 */
		while( true )
		{
			idx1 = source.indexOf( "<option" , idx2 );
			
			if( idx1 < 0 ) break;
			
			idx2 = source.indexOf( TAG_END , idx1 );
			
			if( idx2 < 0 ) break;
			
			idx2++;
			
			tmpValue = StringUtil.getAttribute( src.substring( idx1 , idx2 ) , "value" );
			
			// value가 세팅되지 않았으면<option ... > </option> 사이 값이 value가 된다.
			if( tmpValue == null || tmpValue.length() == 0 )
			{
				idx3 = source.indexOf( "</option" , idx2 );
				if( idx3 < 0 ) continue;
				
				tmpValue = src.substring( idx2 , idx3 );
			}
			
			listValue.addElement( tmpValue );
		}
		
		AnsProperty ans = new AnsProperty();
		ans.setNAME( name );
		ans.setTYPE( eMsTypes.FORM_SELECT_TYPE );
		ans.setVALUE( listValue );
		
		this.addElement( ans );
	}
	
	private void parseInput( String tag )
	{
		String type = StringUtil.getAttribute(tag,"type");
		String name = StringUtil.getAttribute(tag,"name");
		
		//DHTML Editing control에서는 TEXT타입에서는 TYPE을 명시하지 않음.
		if( type == null || type.equals("") ) type = "text";
		
		/**일관적인 판단을 위하여 type을 소문자로 변환한다.
		 */
		type = type.toLowerCase();
		
		/**text 에 대한 처리
		 */
		if( type.equals("text") )
		{
			AnsProperty ans = new AnsProperty();
			ans.setNAME( name );
			ans.setTYPE( eMsTypes.FORM_TEXT_TYPE );
			this.addElement( ans );
			return;
		}
		
		/**라디오 버튼 처리
		 */
		if( type.equals("radio") )
		{
			String value = StringUtil.getAttribute(tag,"value");
			
			/**기존에 있는 값이 있는 지를 검사하여 기존 값이 있으면 더한다.
			 */
			for( int i=0; i<this.size(); i++)
			{
				AnsProperty tempap = (AnsProperty)this.elementAt(i);
				
				if( tempap.getNAME().equals(name) && tempap.getTYPE() == eMsTypes.FORM_RADIO_TYPE )
				{
					tempap.addVALUE(value);
					return;
				}
			}
			
			/**기존 값이 없으면 생성하여 추가한다.
			 */
			AnsProperty oneap = new AnsProperty();
			oneap.setNAME( name );
			oneap.setTYPE( eMsTypes.FORM_RADIO_TYPE );
			oneap.addVALUE(value);
			this.addElement( oneap );
			return;
		}
		
		/**체크박스 처리
		 */
		if( type.equals("checkbox") )
		{
			String value = StringUtil.getAttribute(tag,"value");
			
			for( int i=0; i<this.size(); i++)
			{
				AnsProperty tempap = (AnsProperty)this.elementAt(i);
				
				if( tempap.getNAME().equals(name) && tempap.getTYPE() == eMsTypes.FORM_CHECKBOX_TYPE )
				{
					tempap.addVALUE(value);
					return;
				}
			}
			
			AnsProperty oneap = new AnsProperty();
			oneap.setNAME( name );
			oneap.setTYPE( eMsTypes.FORM_CHECKBOX_TYPE );
			oneap.addVALUE(value);
			this.addElement( oneap );
		}
	}
	
	private void parseTextArea( String tag )
	{
		String name = StringUtil.getAttribute(tag,"name");
		
		if( name == null || name.length() == 0 ) return;
		
		AnsProperty oneap = new AnsProperty();
		oneap.setNAME( name );
		oneap.setTYPE( eMsTypes.FORM_TEXTAREA_TYPE );
		this.addElement( oneap );
	}
}
