/*
 * @(#)MultipleRcptTrackingContentPD.java            2004. 11. 26.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.mass.producer;

import java.util.Iterator;
import java.util.Properties;

import mercury.contents.auto.producer.BasicContentPD;
import mercury.contents.common.parser.LinkParser;
import mercury.contents.common.util.LinkContent;
import pluto.config.eMsSystem;
import lombok.extern.slf4j.Slf4j;
import pluto.util.convert.TrackingInfoConvertor;
import mercury.contents.mass.webproducer.SingleRcptTrackingContentPD;

/**
 * 동보 메일의 경우 컨텐츠 만드는 녀석 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class MultipleRcptTrackingContentPD extends SingleRcptTrackingContentPD {
	protected static String BULK_TRACKING_URL = null;
	
	static {
		BULK_TRACKING_URL = eMsSystem.getProperty("tracking.url").concat("?");
	}
	
	/** Creates a new instance of MulitpleRcptTrackingContentPD */
	public MultipleRcptTrackingContentPD() {
		super();
	}
	
	protected void initProperty( Properties info) throws Exception {
		super.initProperty(info);
		
		this.POST_ID = this.SCHEDULE_INFO.getProperty("POST_ID");
		
		setName( this.POST_ID + "_MulitpleRcptTrackingContentPD" );
		/**파일이름 지정
		 */
		this.WORK_FILE_ID =  this.POST_ID + "_b_real";
		
		
		this.TMP_BUFFER.setLength(0);
		this.TMP_BUFFER.append( BULK_TRACKING_URL );
		this.TMP_BUFFER.append( TrackingInfoConvertor.enc_MAIL_ID( this.POST_ID ) );
		this.TMP_BUFFER.append( "&" );
		this.TMP_BUFFER.append( TrackingInfoConvertor.enc_CLOSE(  this.SCHEDULE_INFO.getProperty("CLOSE_DATE") ) );
		this.TMP_BUFFER.append( "&" );
		this.TMP_BUFFER.append( TrackingInfoConvertor.enc_SEND_TYPE( "BULK" ) );
		this.TMP_BUFFER.append( "&" );
		
		this.instance_TRACKING_URL = this.TMP_BUFFER.toString();
	}
	
	protected String execute_ContentTrackingParsing( String source  ) throws Exception {
		LinkContent __LINK_CONTENT__ = null;
		
		int __LINK_INDEX__ = 0;
		
		StringBuffer __RESULT_CONTENT_BUFFER__ = new StringBuffer( source.length() + 1024 );
		
		boolean TRACKING_INFO_PROCESS = this.SCHEDULE_INFO.getProperty("CONTENT_INFO_UPDATE_FLAG","Y").equals("Y");
		
		if( this.SCHEDULE_INFO.getProperty("CLICK_YN","N").equalsIgnoreCase("Y") ) {
			log.debug("Start Link Parsing");
			
			LinkParser __LINK_PARSER__ = new LinkParser();
			
			__LINK_PARSER__.parse( source );
			
			for( Iterator iter =  __LINK_PARSER__.iterator(); iter.hasNext() ; ) {
				Object __TMP_CONTENT__ = iter.next();
				
				if( __TMP_CONTENT__ instanceof LinkContent ){
					/**링크 인덱스를 하나 올리고
					 */
					__LINK_INDEX__ ++;
					
					__LINK_CONTENT__ = ( LinkContent )__TMP_CONTENT__;
					
					if( __LINK_CONTENT__.getUrl().startsWith( "http" )  ) {
						this.TMP_BUFFER.setLength(0);
						this.TMP_BUFFER.append( instance_TRACKING_URL );
						
						this.TMP_BUFFER.append( TrackingInfoConvertor.enc_KIND( "C" ) );
						this.TMP_BUFFER.append( "&" );
						this.TMP_BUFFER.append( TrackingInfoConvertor.enc_CID( __LINK_CONTENT__.getID() ) );
						this.TMP_BUFFER.append( "&URL=" );
						this.TMP_BUFFER.append( __LINK_CONTENT__.getUrl() );
						
						__RESULT_CONTENT_BUFFER__.append( __LINK_CONTENT__.getLinkConvert( this.TMP_BUFFER.toString() ) );
					}
					else{ // http로 시작하지 않는 URL일 경우
						__RESULT_CONTENT_BUFFER__.append( __TMP_CONTENT__.toString() );
						iter.remove();
					}
				}
				else{ // 링크부분이 아닐경우
					__RESULT_CONTENT_BUFFER__.append( __TMP_CONTENT__.toString() );
					iter.remove();
				}
			}// __LINK_PARSER__ for loop end
			
			/**트래킹 정보를 처리하려면 일단 기존 입력된 정보를 다~~~ 지워야 하쥐...
			 */
			if( TRACKING_INFO_PROCESS ) {
				log.debug("Delete Current Link Info");
				deleteTrackingInfo();

				log.debug("Insert Parsed Link Info");
				StroreTrackingInfoToDB(__LINK_PARSER__ );
			}
			else{
				log.debug("Skip Parsed Link Info");
			}
			
			source = __RESULT_CONTENT_BUFFER__.toString();
			log.debug("End Link Parsing");
		}// Tracking YN if end 클릭 트래킹 파싱종료
		
		__RESULT_CONTENT_BUFFER__.setLength( 0 );
		__RESULT_CONTENT_BUFFER__.append( source );
		int __BODY_INDEX__ = source.toLowerCase().indexOf("</body");
		
		if( this.SCHEDULE_INFO.getProperty("DUR_YN","N").equalsIgnoreCase("Y") ) {
			this.TMP_BUFFER.setLength(0);
			this.TMP_BUFFER.append( "\r\n<iframe src=\"" );
			this.TMP_BUFFER.append( instance_TRACKING_URL );
			this.TMP_BUFFER.append( "&" );
			this.TMP_BUFFER.append( TrackingInfoConvertor.enc_KIND( "D" ) );
			this.TMP_BUFFER.append("\" frameborder=\"0\" width=\"1\" height=\"1\"></iframe>\r\n");
			
			if( __BODY_INDEX__ > 0 ){
				__RESULT_CONTENT_BUFFER__.insert( __BODY_INDEX__ , this.TMP_BUFFER.toString() );
			}
			else{
				__RESULT_CONTENT_BUFFER__.append( this.TMP_BUFFER.toString() );
			}
		}
		
		/**오픈이 체크가 되었다면 추가한다.
		 */
		if( this.SCHEDULE_INFO.getProperty("OPEN_YN","N").equalsIgnoreCase("Y") ) {
			this.TMP_BUFFER.setLength(0);
			this.TMP_BUFFER.append( "<img src=\"" );
			this.TMP_BUFFER.append( instance_TRACKING_URL );
			this.TMP_BUFFER.append( "&" );
			this.TMP_BUFFER.append( TrackingInfoConvertor.enc_KIND( "O" ) );
			this.TMP_BUFFER.append("\" width=1 height=1>");
			
			if( __BODY_INDEX__ > 0 ){
				__RESULT_CONTENT_BUFFER__.insert( __BODY_INDEX__ , this.TMP_BUFFER.toString() );
			}
			else{
				__RESULT_CONTENT_BUFFER__.append( this.TMP_BUFFER.toString() );
			}
		}
		
		return __RESULT_CONTENT_BUFFER__.toString();
	}
}

