/*
 * @(#)MimeHeaderToken.java            2004. 11. 26.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.common.util.mime;

/**
 *  ATOM, QUOTEDSTRING, COMMENT, EOF 정보를 메시지로 출력
 * 
 * @version		
 * @author 		dragon
 *
 */
public class MimeHeaderToken {
	public static final int ATOM = -1;
	public static final int QUOTEDSTRING = -2;
	public static final int COMMENT = -3;
	public static final int EOF = -4;

	private int type;
	private String value;
	
	public MimeHeaderToken(int i, String s) {
		type = i;
		value = s;
	}
	
	public int getType() {
		return type;
	}
	
	public String getValue() {
		return value;
	}
	
	public String toString(){
		switch( type ){
			case ATOM:{
				return "ATOM : " + value;
			}
			case QUOTEDSTRING:{
				return "QUOTEDSTRING : " + value;
			}
			case COMMENT:{
				return "COMMENT : " + value;
			}
			case EOF:{
				return "EOF : " + value;
			}
			default:{
				return "unknown";
			}
		}
	}
}

