/*
 * @(#)MappingImgStripper.java            2004. 11. 26.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.util;

import java.util.Vector;

import lombok.extern.slf4j.Slf4j;
import pluto.config.eMsSystem;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class MappingImgStripper extends java.lang.Object {

	public static String			HEADER_INDEX	= "<img ";

	static {
		try {
			HEADER_INDEX = "<".concat(eMsSystem.getProperty("mapping.tag.name", "img").toLowerCase()).concat(" ");
		}
		catch(Exception e) {
		}
	}

	public synchronized static String process(String src) {
		String source = src.toLowerCase().replace('\'', '\"');

		StringBuffer buffer = null;
		try {
			buffer = new StringBuffer(512);

			int idx1 = 0;
			int idx2 = 0;

			while (true) {
				idx2 = source.indexOf(HEADER_INDEX, idx1);

				if( idx2 < 0 )
					break;

				// img tag 이외의 사이 부분 append
				buffer.append(src.substring(idx1, idx2));

				idx1 = source.indexOf(">", idx2);

				if( idx1 < 0 )
					break;

				idx1++;

				// img tag 부분을 파싱해서 append
				buffer.append(parse(src.substring(idx2, idx1)));
			}

			if( idx2 > 0 ) {
				buffer.append(src.substring(idx2));
			}
			else {
				buffer.append(src.substring(idx1));
			}

			return buffer.toString();
		}
		catch(RuntimeException e) {
			throw e;
		}
		finally {
			buffer = null;
		}
	}

	private static String parse(String original) {
		if (log.isDebugEnabled()) 
			log.debug("PARSE=>", original);
		String src = original.toLowerCase();

		int idxOfStart = src.indexOf("alt=\"${");

		if( idxOfStart < 0 ) {
			idxOfStart = src.indexOf("alt=${");
			if( idxOfStart < 0 ) {
				if (log.isDebugEnabled()) 
					log.debug("NO ALT INDEX=>", original);
				return original;
			}
		}

		idxOfStart = src.indexOf("${", idxOfStart);

		int idxOfEnd = src.indexOf("}", idxOfStart);

		if( idxOfEnd < 0 ) {
			if (log.isDebugEnabled()) 
				log.debug("NO ALT CLOSE INDEX=>", original);
			return original;
		}

		if (log.isDebugEnabled()) 
			log.debug("RESULT=>", original.substring(idxOfStart, idxOfEnd + 1));
		return original.substring(idxOfStart, idxOfEnd + 1);
	}

	public static Vector getMappingVariables(String source) {
		Vector returnValue = new Vector();

		int idx1 = 0;
		int idx2 = 0;

		while (true) {
			idx1 = source.indexOf("${", idx2);

			if( idx1 < 0 )
				break;

			idx2 = source.indexOf("}", idx1 + 2);

			if( idx2 < 0 )
				break;

			String key = source.substring(idx1 + 2, idx2);

			if( !returnValue.contains(key) ) {
				returnValue.addElement(key);
			}
		}

		return returnValue;
	}
}
