/*
 * @(#)LinkContent.java            2004. 11. 26.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.common.util;

import pluto.util.StringUtil;
/**
 * 
 * 
 * @version		
 * @author 		dragon
 *
 */
public class LinkContent
{
	
	/** Holds value of property linkCnt. */
	private int linkCnt;
	
	/** Holds value of property alt. */
	private String alt;
	
	/** Holds value of property content. */
	private String content;
	
	/** Holds value of property url. */
	private String url;
	
	/** Holds value of property original. */
	private String original;
	
	/** Holds value of property ID. */
	private String ID;
	
	/** Creates new LinkContent */
	public LinkContent( int link , String Alt , String Content, String Url, String Original)
	{
		this.linkCnt = link;
		this.alt = Alt==null?"":Alt;
		this.content = Content==null?"":Content;
		this.url = Url==null?"":Url;
		this.original = Original==null?"":Original;
	}

	/** Getter for property linkCnt.
	 * @return Value of property linkCnt.
 */
	public int getLinkCnt() {
		return linkCnt;
	}
	
	/** Getter for property alt.
	 * @return Value of property alt.
 */
	public String getAlt() {
		return alt;
	}
	
	/** Getter for property content.
	 * @return Value of property content.
 */
	public String getContent() {
		return content;
	}
	
	/** Getter for property url.
	 * @return Value of property url.
 */
	public String getUrl() {
		return url;
	}
	
	/** Getter for property original.
	 * @return Value of property original.
 */
	public String getOriginal() {
		return original;
	}
	
	/** Getter for property linkConvert.
	 * @return Value of property linkConvert.
 */
	public String getLinkConvert( String url ) {
		return StringUtil.switchAttribute( this.original , "href" , url );
	}
	
	public String toString(){
		return this.original;
	}
	
	/** Getter for property ID.
	 * @return Value of property ID.
 */
	public String getID() {
		if( ID != null ) return ID;
		
		ID = String.valueOf( linkCnt );
		
		while( ID.length() < 3 )
		{
			ID = "0".concat( ID );
		}
		
		return ID;
	}
}
