/*
 * @(#)SearchContentPD.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.common.producer;

import java.util.Properties;

import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;

/**
 * 컨텐츠를 만들지 않고 이미 만들어서 등록되어 있는 contents info를 메모리에서 찾는다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
public class SearchContentPD extends ContentPD{
	
	protected Properties SCHEDULE_INFO = null;
	
	protected String POST_ID = null;
	
	protected ContentInfo SEND_CONTENT_INFO = null;
	
	/** Creates a new instance of SearchContentPD */
	public SearchContentPD() {
	}
	
	/** 처리한 결과로 생성된 ContentInfo를 반환한다.
	 * @return 생성된 ContentInfo
	 */
	public ContentInfo getContentInfo() {
		return this.SEND_CONTENT_INFO;
	}
	
	
	protected void initProperty(Properties info) throws Exception {
		this.SCHEDULE_INFO = info;
		
		this.POST_ID = this.SCHEDULE_INFO.getProperty("POST_ID");
		
		this.setName( this.POST_ID + " 's SearchContentPD" );
	}
	
	/** Content를 처리하는 로직을 정의한다.
	 * @param info 발송 스케쥴 정보
	 * @throws Exception 생성에러
	 */
	public void process_main() throws Exception {
		this.SEND_CONTENT_INFO = ContentInfoManager.getContentInfo( this.POST_ID );
		
		if( this.SEND_CONTENT_INFO == null ){
			throw new RuntimeException( "CONTENT INFO IS NOT REGIST..." );
		}
	}

	protected void initResource() throws Exception {
		// TODO Auto-generated method stub

	}
	protected void initError(Throwable thw){
		// TODO 일단 아무일도 안하는 것으로 하지만. 특별한 에러처리가 필요할 경우 override한다.  
	}
	protected void mainError(Throwable thw){
		// TODO 일단 아무일도 안하는 것으로 하지만. 특별한 에러처리가 필요할 경우 override한다.  
	}

	protected void exec_close() {
		// TODO Auto-generated method stub
	}
}
