/*
 * @(#)ContentPD.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.producer;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.basic.ContentInfo;
import pluto.config.eMsSystem;
import pluto.lang.Name;

/**
 * 발송 제작물을 처리하는 일련의 작업을 정의한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public abstract class ContentPD extends Name {

	public static final String		KEY_MESSAGE_CLASS			= "A";

	public static final String		KEY_BODY_PARSER_CLASS		= "B";

	public static final String		KEY_MAILBODY_CLASS			= "Z";

	public static final String		KEY_CONTENT_TYPE			= "C";

	public static final String		VALUE_HTML_TYPE				= "D";

	public static final String		VALUE_TEXT_TYPE				= "E";

	public static final String		KEY_CONTENT_CHARSET			= "F";

	public static final String		KEY_CONTENT_ENC_TYPE		= "G";

	public static final String		KEY_HEADER_CHARSET			= "H";

	public static final String		KEY_HEADER_ENC_TYPE			= "I";

	public static final String		VALUE_BASE64				= "1";

	public static final String		VALUE_8BIT					= "2";

	public static final String		VALUE_7BIT					= "3";

	public static final String		VALUE_QP					= "4";

	public static final String		VALUE_UUENCODE				= "5";

	public static final String		KEY_REPLAY_TO				= "J";

	public static final String		KEY_CONTENT_URL				= "K";

	public static final String		KEY_FROM_EMAIL				= "L";

	public static final String		KEY_FROM_NAME				= "M";

	public static final String		KEY_TO_EMAIL				= "N";

	public static final String		KEY_TO_NAME					= "O";

	public static final String		KEY_RETURN_PATH				= "P";

	public static final String		KEY_SUBJECT					= "Q";

	/**
	 * 컨텐트 정보가 파일 이름만 지정이 되어 있을 경우 기본으로 추가되는 URL
	 */
	public static String			CONTENTS_BASE_URL			= null;

	/**
	 * 컨텐트를 파싱한 결과를 저장하는 디렉토리
	 */
	public static String			CONTENTS_STORE_DIRECTORY	= null;

	/**
	 * 공용으로 사용하는 StringBuffer add 2004.11.02
	 */
	protected StringBuffer		TMP_BUFFER								= null;

	static {
		CONTENTS_BASE_URL = eMsSystem.getProperty("contents.base.url");
		CONTENTS_STORE_DIRECTORY = eMsSystem.getProperty("content.store.directory");
		if (log.isDebugEnabled()) {
			// foo
		}
	}

	/**
	 * Content를 처리하는 로직을 정의한다.
	 * 
	 * @param info
	 *            발송 스케쥴 정보
	 * @throws Exception
	 *             생성에러
	 */
	public final void process(Properties info) throws Exception {
		try {
			this.initResource();
			this.initProperty(info);
		}
		catch(Throwable thw) {
			this.initError(thw);
			this.exec_close();

			if( thw instanceof Exception ) {
				throw (Exception) thw;
			}

			throw new Exception(thw);
		}
/*		
		finally {
			this.exec_close();
		}
*/		
		try {
			this.process_main();
		}
		catch(Throwable thw) {
			this.mainError(thw);
			if( thw instanceof Exception ) {
				throw (Exception) thw;
			}

			throw new Exception(thw);
		}
		finally {
			this.exec_close();
		}
	}
	
	protected abstract void initResource() throws Exception;
	
	/**
	 * 작업 정보를 초기화 한다.
	 * 
	 * @param info
	 *            작업정보
	 * @throws Exception
	 *             실행오류
	 */
	protected abstract void initProperty(Properties info) throws Exception;

	/**
	 * 실제 실행 로직을 정의한다.
	 * 
	 * @param info
	 * @throws Exception
	 */
	protected abstract void process_main() throws Exception;

	/**
	 * 초기화 에러를 처리한다.
	 * 
	 * @param thw
	 *            실행에러
	 */
	protected abstract void initError(Throwable thw);

	/**
	 * 메일 프로세스 실행 에러를 처리한다.
	 * 
	 * @param thw
	 *            실행오류
	 */
	protected abstract void mainError(Throwable thw);

	/**
	 * 어찌되었거나 끝날때 정리해야할 녀석들은 정리를 해야한다.
	 */
	protected abstract void exec_close();

	/**
	 * 처리한 결과로 생성된 ContentInfo를 반환한다.
	 * 
	 * @return 생성된 ContentInfo
	 */
	public abstract ContentInfo getContentInfo();
}
