/*
 * @(#)CommonContentPD.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.producer;

import java.util.Properties;

import mercury.contents.auto.producer.BasicContentPD;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import mercury.contents.common.util.TrackingInfoConvertor;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.io.eMsFileWriter;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.BASE64;

/**
 * 기본 컨텐츠 producer를 정의한다
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public abstract class CommonContentPD extends ContentPD {

	/**
	 * 트래킹 정보를 저장할때 DB연결
	 */
	protected eMsConnection			EMS_CONNECTION							= null;

	/**
	 * 작업하는 파일의 기본 이름을 지정한다.
	 */
	protected String				WORK_FILE_ID							= null;

	/**
	 * 메일 아이디
	 */
	protected String				POST_ID									= null;

	/**
	 * 생성된 컨텐트 정보를 저장한다.
	 */
	protected ContentInfo			SEND_CONTENT_INFO						= null;

	/**
	 * 생성된 컨텐트 정보를 저장한다.
	 */
	protected Properties			SCHEDULE_INFO							= null;

	protected String				instance_ATTACH_CONTENT_SELECT_QUERY	= null;

	/** Creates new WindForceContentPD */
	public CommonContentPD() {
	}

	/**
	 * 데이터 베이스 연결을 재설정한다.
	 *  
	 */
	protected final void refreshDBConnection() throws Exception {
		if( this.EMS_CONNECTION == null ) {
			this.EMS_CONNECTION = ConnectionPool.getConnection();
		}
		else {
			this.EMS_CONNECTION.recycle();
			this.EMS_CONNECTION = ConnectionPool.getConnection();
		}
	}

	protected final void closeDBConnection() {
		if( this.EMS_CONNECTION != null ) {
			this.EMS_CONNECTION.recycle();
			this.EMS_CONNECTION = null;
		}
	}

	protected void initResource() throws Exception {
		// 공용 버퍼초기화 add 2004.11.02
		this.TMP_BUFFER = new StringBuffer(2048);

		// TODO 디비연결 초기화
		this.refreshDBConnection();
	}

	protected void initProperty(Properties info) throws Exception {
		this.SCHEDULE_INFO = info;
	}

	protected void initError(Throwable thw) {
		// TODO 일단 아무일도 안하는 것으로 하지만. 특별한 에러처리가 필요할 경우 override한다.
	}

	protected void mainError(Throwable thw) {
		// TODO 일단 아무일도 안하는 것으로 하지만. 특별한 에러처리가 필요할 경우 override한다.
	}

	/**
	 * 어찌되었거나 끝날때 정리해야할 녀석들은 정리를 해야한다.
	 */
	protected void exec_close() {
		closeDBConnection();
		this.TMP_BUFFER.setLength(0);
		this.TMP_BUFFER = null;
	}

	/**
	 * Content를 처리하는 로직을 정의한다.
	 * 
	 * @throws Exception
	 *             생성에러
	 */
	protected void process_main() throws Exception {
		String __DB_CONTENT__ = this.SCHEDULE_INFO.getProperty("CONTENT");

		String __CONTENT_URL_ = null;

		if( __DB_CONTENT__.startsWith("http://") || __DB_CONTENT__.startsWith("https://") || __DB_CONTENT__.startsWith("ftp://")
				|| __DB_CONTENT__.startsWith("file://") ) {
			__CONTENT_URL_ = __DB_CONTENT__;
		}
		else {
			__CONTENT_URL_ = CONTENTS_BASE_URL + __DB_CONTENT__;
		}

		String __CONTENT__ = null;
		try {
			__CONTENT__ = FileElement.getFileBody(__CONTENT_URL_);
		}
		catch(Exception e) {
			log.error(__CONTENT_URL_, e);
			throw e;
		}

		if (log.isDebugEnabled()) {
			log.debug("CONTENT", __CONTENT__);
		}
		
		
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		// 안심메일 테그를 입힌다. 
		boolean SAFEMAIL_YN = this.SCHEDULE_INFO.getProperty("SAFEMAIL_YN","N").equalsIgnoreCase("Y");
		
		if(SAFEMAIL_YN){
			__CONTENT__ = addSafeMailSource(__CONTENT__);
		}
		

		// 외부에서 임의의 매핑이 진행된다고 했을때 우리쪽 매핑 인덱스로 전환하는 로직
		if( this.SCHEDULE_INFO.getProperty("CONTENT_MAPPING_SERIALIZE_FLAG", "N").equalsIgnoreCase("Y") ) {
			__CONTENT__ = StringUtil.GeneralizeContents(__CONTENT__, "${", "}", "map_");
		}

		log.debug( " pass get contents ");

		// 컨텐트 처리하러 들어갈때 기본 헤더 테일을 붙인다.( 기능추가 2004-02-26 )
		__CONTENT__ = execute_ContentProcess(eMsLocale.CONTENT_DEFAULT_HEADER + __CONTENT__ + eMsLocale.CONTENT_DEFAULT_TAIL);

		// 컨텐츠를 파일에 저장한다.
		execute_ContentSave(__CONTENT__);

		// 컨텐트의 저장이 종료되고 ContentInfo를 생성한다.
		log.debug( " pass result contents ");
		execute_createContentInfo();
		log.debug( " pass regist contensts infomation ");
	}
	
	/**
	 * 
	 * @param source
	 * @return
	 */
	protected String addSafeMailSource(String source) {
		String result = "";
		//String return_str = "";
		StringBuffer return_str = new StringBuffer();
		
		
		String SAFEMAIL_TAG_START = eMsSystem.getProperty("safemail.tag.start");
		String SAFEMAIL_TAG_END   = eMsSystem.getProperty("safemail.tag.end");
		String CUST_ID            = eMsSystem.getProperty("cust.id");
		String width              = this.SCHEDULE_INFO.getProperty("TMS_M_WIDTH","800");
		
		String enc_cid = BASE64.encode( "CUST_ID="+CUST_ID );
		//String enc_pid = BASE64.encode( "POST_ID="+this.POST_ID );
		String enc_pid = BASE64.encode( "POST_ID="+this.POST_ID ); //AB-TEST post_id와 맞지않아 AB_ID 제외시킨다.
		
		Properties prop = new Properties();
		prop.setProperty("ENC_CID",     enc_cid);
		prop.setProperty("ENC_PID",     enc_pid);
		prop.setProperty("TMS_M_WIDTH", width  );
		String SAFEMAIL_TAG_START_ENC_PID =  StringUtil.ConvertString(SAFEMAIL_TAG_START, prop, "@{", "}");
		
		
		int sStart = 0;
		int sEnd = 0;
		int eStart = 0;
		int eEnd = 0;
		
		sStart = source.toLowerCase().indexOf("<body");
		if(sStart < 0) {
			sEnd = 0;
			eStart = source.length();
		} else {
			sEnd = source.toLowerCase().indexOf(">", sStart) + 1;
			eStart = source.toLowerCase().lastIndexOf("</body");
		}
		
		StringBuffer sbuffer = new StringBuffer();
		sbuffer.append(source.substring(0,sEnd)).append("\n");
		sbuffer.append(SAFEMAIL_TAG_START_ENC_PID);
		sbuffer.append(source.substring(sEnd, eStart)).append("\n");
		sbuffer.append(SAFEMAIL_TAG_END);
		sbuffer.append(source.substring(eStart, source.length()));
		
		result = sbuffer.toString();
		//link 태그를 막는다.
		/*
		while((sStart = result.toLowerCase().indexOf("<link")) > 0) {
			if(sStart < 0) {
				sEnd = 0;
				eStart = result.length();
				eEnd = result.length();
			} else {
				sEnd = result.toLowerCase().indexOf(">", sStart) + 1;
				eStart = result.toLowerCase().lastIndexOf("</link");
				eEnd = result.toLowerCase().lastIndexOf(">", eStart) + 1;
			}
			return_str.append(result.substring(0,sStart));
			if(eStart > 0) {
				return_str.append(result.substring(sEnd, eStart));
				return_str.append(result.substring(eEnd, result.length()));
			} else {
				return_str.append(result.substring(sEnd, result.length()));
			}
			result = return_str.toString();
		}*/

		return result;
	}
	
	
	

	/**
	 * 처리한 결과로 생성된 ContentInfo를 반환한다.
	 * 
	 * @return 생성된 ContentInfo
	 */
	public ContentInfo getContentInfo() {
		return this.SEND_CONTENT_INFO;
	}

	/**
	 * 최종 발송에 필요한 컨텐트를 파일로 저장하고 저장된 파일이름은 100번 테이블로 업데이트한다. 트래킹을 할경우에는
	 * execute_ContentTrackingParsing Method 에서 호출 되고 트래킹을 하지 않을 경우에는
	 * execute_ContentProcess Method 에서 호출 된다.
	 */
	protected void execute_ContentSave(String source) throws Exception {

		String __THIS_DATE__ = Cal.getDayDate();

		// 컨텐트 변환 저장
		String __CONTENT_SAVE_FILE_NAME__ = FileElement.CheckSubDirectory(CONTENTS_STORE_DIRECTORY, __THIS_DATE__) + "/" + this.WORK_FILE_ID
				+ ".contents";
		eMsFileWriter wt = new eMsFileWriter(__CONTENT_SAVE_FILE_NAME__);
//=====================================================
//client : 타이드스퀘어
//날짜 : 2013.10.
//작업자: 강석원	
//내용 : sms, lms 인경우 enter key가 GeneralizeMailContents() 적용 안됨.
//     입력한 문구가 그대로 들어가야 됨.
//원본 : 	wt.write(StringConvertUtil.GeneralizeMailContents(source));	
//=====================================================		
		try {
			if(!"EM".equals(SCHEDULE_INFO.get("CHANNEL_TYPE").toString().trim())) wt.write(source);
			else wt.write(StringConvertUtil.GeneralizeMailContents(source));
		} catch (Exception e) {
			wt.write(StringConvertUtil.GeneralizeMailContents(source)); 
		}
//=====================================================		
		wt.flush();
		if(wt != null){
			wt.close();
		}
		this.SCHEDULE_INFO.setProperty("CONTENT", "file://" + __CONTENT_SAVE_FILE_NAME__);
	}

	protected void execute_createContentInfo() throws Exception {
		String send_type = this.SCHEDULE_INFO.getProperty("SEND_TYPE");
		String send_state = this.SCHEDULE_INFO.getProperty("SEND_STATE");
		String mail_enc_type = this.SCHEDULE_INFO.getProperty("MAIL_ENC_TYPE","");
		String header_mime_char_set = this.SCHEDULE_INFO.getProperty("HEADER_MIME_CHAR_SET", eMsLocale.HEADER_MIME_CHAR_SET);
		/*
		 * 엔코딩 타입을 스케즐 쿼리에서 받아올 수 있도록 수정.
		 * 스케즐 쿼리에 정의된 것이 없다면 환경파일에서 가져옴
		 */
		Short nMailEncType = mail_enc_type.equals("")?new Short(eMsLocale.MAIL_ENC_TYPE):new Short( mail_enc_type );

		// BodyParser Instance 준비
		BodyParser __BODY_PARSER__ = (BodyParser) InstanceFactory.getInstance(send_type, send_state, eMsTypes.BODYPARSER_INSTANCE);
		__BODY_PARSER__.setContents(this.SCHEDULE_INFO.getProperty("CONTENT"));

		// Message Instance준비
		Message myMessage = (Message) InstanceFactory.getInstance(send_type, send_state, eMsTypes.MESSAGE_INSTANCE);

		// 메세지에 파서 지정
		myMessage.setContent(__BODY_PARSER__);

		// 컨텐트 타입 설정
		if( this.SCHEDULE_INFO.getProperty("CONTENT_TYPE", "H").equals("H") ) {
			myMessage.setContentType(new Short(eMsTypes.TEXT_HTML));
		}
		else {
			myMessage.setContentType(new Short(eMsTypes.TEXT_PLAIN));
		}

		// 케릭터 셋 설정

		myMessage.setCharSet(header_mime_char_set.equals("")?eMsLocale.MAIL_MIME_CHAR_SET:header_mime_char_set);
		
		// 인코딩 타입 설정
		myMessage.setContentEncoding(nMailEncType);

		// Message ID 세팅
		myMessage.setMessageID(this.POST_ID);

		// MailBody Instance 생성
		MailBody __MAILBODY__ = (MailBody) InstanceFactory.getInstance(send_type, send_state, eMsTypes.MAILBODY_INSTANCE);

		// 보내는 사람 정보
		__MAILBODY__.setFromEmail(this.SCHEDULE_INFO.getProperty("FROM_EMAIL"));
		__MAILBODY__.setFromName(this.SCHEDULE_INFO.getProperty("FROM_NAME"));

		// 받는 사람 정보 세팅
		// 원투원일 경우에는 매핑도 넣을 수 있다. 지금은 웹에서 지원이 안되기 때문에 근야 디폴트 값으로 박아 넣는다.
		__MAILBODY__.setToEmail(this.SCHEDULE_INFO.getProperty("TO_EMAIL", "${TMS_M_TOKEN}"));
		__MAILBODY__.setToName(this.SCHEDULE_INFO.getProperty("TO_NAME", "${TMS_M_NAME}"));

		// Subject Setting
		__MAILBODY__.setSubject(this.SCHEDULE_INFO.getProperty("SUBJECT"));

		// Default Header Info Setting
		__MAILBODY__.setEtcHeader(eMsLocale.DEFAULT_HEADER);

		// set Message to MailBody
		__MAILBODY__.setMessage(myMessage);

		// 첨부파일을 점검하여 첨부 Message도 지정한다.
		if( eMsLocale.ATTACH_LOGIC_EXECUTE_FLAG && this.instance_ATTACH_CONTENT_SELECT_QUERY != null ) {
			// 디비 연결 초기화
			refreshDBConnection();

			eMsStatement stmt = null;
			eMsResultSet rs = null;

			try {
				stmt = this.EMS_CONNECTION.createStatement();

				// execute Attach File Info Query -> 쿼리를 바로 실행하기 때문에 매핑이 완료된
				// 쿼리여야한다.
				rs = stmt.executeQuery(this.instance_ATTACH_CONTENT_SELECT_QUERY);

				Properties prop = new Properties();
				int file_cnt = 0;

				while (rs.next()) {
					++file_cnt;
					
					// ResultSet to Hash..
					rs.putToMap(prop, false);

					String sAttachState = prop.getProperty("ATTACH_TYPE", "O");
					String aAttachFileUrl = prop.getProperty("ATTACH_FILE");
					String aAttachFileName = prop.getProperty("ATTACH_NAME");
					String aAttachCharset = SCHEDULE_INFO.getProperty("CHAR_SET",eMsLocale.FILE_SYSTEM_OUT_CHAR_SET ); //utf-8
					
					String aAttachContentType = prop.getProperty("CONTENT_TYPE", "B");
					String aAttachContentEncode = prop.getProperty("CONTENT_ENCODE", "B");
					
					if (this.SCHEDULE_INFO.getProperty("CHANNEL_TYPE").equals("SM")) {
						this.SCHEDULE_INFO.setProperty("MMS_ATTACH_PATH_"+file_cnt,aAttachFileUrl);
					} else {		

						// create BodyParser Instance
						BodyParser aBodyParser = (BodyParser) InstanceFactory.getInstance("ATTACH", sAttachState, eMsTypes.BODYPARSER_INSTANCE);
	
						// set Attach Content URL
						aBodyParser.setContents(aAttachFileUrl);
	
						// create attach Message Instance
						Message mMessage = (Message) InstanceFactory.getInstance("ATTACH", sAttachState, eMsTypes.MESSAGE_INSTANCE);
	
						// set BodyParser to Message
						mMessage.setContent(aBodyParser);
	
						// set charset to Message
						mMessage.setCharSet(aAttachCharset);
	
						// set Attach ContentType
						if( aAttachContentType.equalsIgnoreCase("T") ) {
							// set Text Attach Type
							mMessage.setContentType(new Short(eMsTypes.ATTACH_TEXT_MESSAGE));
						}
						else if( aAttachContentType.equalsIgnoreCase("H") ) {
							// set Html Attach Type
							mMessage.setContentType(new Short(eMsTypes.ATTACH_HTML_MESSAGE));
						}
						else {
							// set default Binary Attach Type
							mMessage.setContentType(new Short(eMsTypes.ATTACH_BINARY_MESSAGE));
						}
	
						// set Attach Content Encoding
						if( aAttachContentEncode.equalsIgnoreCase("N") ) {
							// Normal Text type 8BIT Encoding
							mMessage.setContentEncoding(new Short(eMsTypes.ENC_8BIT));
						}
						else if( aAttachContentEncode.equalsIgnoreCase("Q") ) {
							// Text QP Encoding
							mMessage.setContentEncoding(new Short(eMsTypes.ENC_QP));
						}
						else {
							// default BASE64 Encoding
							mMessage.setContentEncoding(new Short(eMsTypes.ENC_BASE64));
						}
	
						// set Attach FileName
						mMessage.setContentName(aAttachFileName);
	
						__MAILBODY__.setMessage(mMessage);
					}
				}
				if (this.SCHEDULE_INFO.getProperty("CHANNEL_TYPE").equals("SM")) {	
					this.SCHEDULE_INFO.setProperty("MMS_ATTACH_CNT",Integer.toString(file_cnt));
				}
			}
			finally {
				this.EMS_CONNECTION.recycleStatement(stmt);
				if( rs != null ) {
					try {
						rs.close();
					}
					catch(Exception ignore) {
						// ignore
					}
				}
			}
		}

		// 첨부파일이 있을 경우에 메세지를 추가 지정한다.

		/* 발송할 사항에 대해서 ContentInfoManager에 등록을 한다. 그래야지 재발송이 가능하니깐.. */
		this.SEND_CONTENT_INFO = new ContentInfo();
		this.SEND_CONTENT_INFO.setID(this.POST_ID);
		this.SEND_CONTENT_INFO.setScheduleInfo(this.SCHEDULE_INFO);
		this.SEND_CONTENT_INFO.setMappingHeader(this.getMappingHeader());
		this.SEND_CONTENT_INFO.setMailBody(__MAILBODY__);
		this.SEND_CONTENT_INFO.setReturnPath(this.SCHEDULE_INFO.getProperty("RETURN_PATH"));
		this.SEND_CONTENT_INFO.setSendType(this.SCHEDULE_INFO.getProperty("SEND_TYPE"));
	}

	/**
	 * 원본 제작물의 변환을 진행한다.
	 * 
	 * @param source
	 *            원본 소스
	 * @return 변환된 결과
	 * @throws Exception
	 *             실행중 오류
	 */
	protected abstract String execute_ContentProcess(String source) throws Exception;

	protected abstract String getMappingHeader() throws Exception;
}
