/*
 * @(#)SimpleBodyParser.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.parser;

import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Properties;

import pluto.io.FileElement;
import pluto.lang.Name;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import freemarker20.template.SimpleHash;

/**
 * 매핑이나 기타 변환이 없는 아주 단순한 받은대로 돌려주는 녀석이다
 * 
 * @version
 * @author dragon
 *  
 */
public class SimpleBodyParser extends Name implements BodyParser {

	protected String			origin					= null;

	protected String			contents				= null;

	//	protected eMsByteArrayOutputStream INNER_BYTE_ARRAY_STREAM = null;

	/**
	 * Creates new SimpleBodyParser
	 */
	public SimpleBodyParser() {
		//		this.INNER_BYTE_ARRAY_STREAM = new eMsByteArrayOutputStream(1024);
		setName("SimpleBodyParser");
	}

	/**
	 * 컨텐츠를 세팅한다.
	 * 
	 * @param src
	 *            메세지 원본 String
	 * @throws Exception
	 *             발생할 일은 없다.
	 */
	public synchronized void setContents(String src) throws Exception {

		this.origin = src;

		ByteArrayOutputStream byteBuffer = null;
		
		try {
			byteBuffer = new ByteArrayOutputStream(2048);

			FileElement fe = FileElement.getFileElement(src);
			fe.putStream(byteBuffer);
			this.contents = byteBuffer.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
			setName(fe.getName());
			fe.close();
		}
		finally {
			try {
				if(byteBuffer != null) {
					byteBuffer.close(); 
				}
			} catch(Exception e) {}
			byteBuffer = null;
		}
	}

	/**
	 * 저장 정보로 부터 컨텐츠를 복원할때 사용을 한다. 경로로 세팅을 했을 경우에 시간이 지나 없어질수 있기때문이다.
	 * 
	 * @param original
	 *            URL
	 * @param contents
	 *            파싱이나 읽어온 원본
	 * @param contents
	 *            이름
	 * @throws Exception
	 *             생성에러
	 */
	public void setContents(String original, String contents, String name) throws Exception {

		this.origin = original;
		this.contents = contents;
		setName(name);
	}

	/**
	 * 목적이되는 최종 산출물을 만드는 작업을 수행 <br>
	 * 여기서는 개인화가 되지 않으므로 세팅된 Contents를 그대로 반환한다.
	 * 
	 * @param info1
	 *            최종 산출물을 생성할때 필요한 개인 매핑데이터 <br>
	 *            그러나 무시된다.
	 * @param info1
	 *            최종 산출물을 생성할때 필요한 공용 매핑데이터 <br>
	 *            그러나 무시된다.
	 * @throws Exception
	 *             생성중에러
	 * @return 세팅된 Contents를 그대로 반환한다.
	 */
	public synchronized String convert(Object info1, Object info2, Properties prop) throws Exception {

		StringBuffer buffer = new StringBuffer(2048);
		
		StringConvertUtil.ConvertString(buffer, contents, prop, "${", "}", false, true);

		String tmpString = buffer.toString();

		buffer.setLength(0);

		if( info1 != null ) {
			if( info1 instanceof Map || info1 instanceof SimpleHash ) {
				StringConvertUtil.ConvertString(buffer, tmpString, info1, "${", "}", false, false);
			}
			else {
				throw new RuntimeException("UNSUPPORTED HASH TYPE");
			}
			tmpString = buffer.toString();
			buffer.setLength(0);
		}

		StringConvertUtil.ConvertString(buffer, tmpString, info2, "@{", "}", false, false);
		return buffer.toString();
	}

	/**
	 * 세팅된 컨텐츠를 반환한다.
	 * 
	 * @return 컨텐츠
	 */
	public synchronized String getContents() {
		return this.contents;
	}

	/**
	 * setContents에서 지정된 원본을 반환한다.
	 */
	public String getOriginal() {
		return this.origin;
	}

	// 혹시나 GC가 호출해주기를 바라며....
	protected void finalize() throws Throwable {
	}
}
