/*
 * @(#)LinkParser.java            2004. 11. 26.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.common.parser;

import java.util.Iterator;
import java.util.LinkedList;

import mercury.contents.common.util.LinkContent;
import pluto.io.FileElement;
import pluto.util.StringUtil;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
public class LinkParser extends LinkedList {
	private static final String TAG_START = "<";
	private static final String TAG_END = ">";
	
	// private String body = null;
	
	/** Creates new LinkParser */
	public LinkParser(){}
	
	/*
	 * [2017.04.17]TMSP-627
	 * 주석 제거 함수
	 */
	public static String remarkCleaner(String html){
		while(true) {
			if (html.indexOf("<!--") != -1) {
				int start = html.indexOf("<!--");
				int end = html.indexOf("-->");
				html = html.substring(0, start) + html.substring(end+3, html.length());
			} else {
				break;
			}
		}
		return html;
	}
	
	public void parse( String src ) {
		/**파싱을 시작하기 전에 초기화 한다.
		 */
		this.clear();
		
		//[2017.04.17]TMSP-627
		src = remarkCleaner(src);
		
		String source = src.toLowerCase();
		
		int idx1 = 0;
		int idx2 = 0;
		int idx3 = 0;
		int idx4 = 0;
		
		int linkCount = 1;
		
		String tag = null;
		String org_tag = null;
		
		String url = null;
		String content = null;
		String alt = null;
		
		while( true ) {
			idx1 = source.indexOf( TAG_START , idx2 );
			
			if( idx1 < 0 ) break;
			
			this.addLast( src.substring( idx2 , idx1 ) );
			
			idx2 = source.indexOf( TAG_END , idx1 );
			
			if( idx2 < 0 ) break;
			
			idx2++;
			
			tag = source.substring( idx1 , idx2 );
			org_tag = src.substring( idx1 , idx2 );

			if( tag.startsWith( "<a " ) ) {
				url = StringUtil.getAttribute( org_tag , "href" );
				alt = StringUtil.getAttribute( org_tag , "alt" );
				
				idx3 = source.indexOf( "</a" , idx2 );
				if( idx3 < 0 ){ // 본문 테그의 종료가 없다면 그냥 넘어가야쥐
					this.addLast( src.substring( idx1 , idx2 ) );
					continue;
				}
				
				idx4 = source.indexOf( TAG_END , idx3 );
				if( idx4 < 0 ){// 본문 테그의 종료가 없다면 그냥 넘어가야쥐
					this.addLast( src.substring( idx1 , idx2 ) );
					continue;
				}
				
				content = src.substring( idx2 , idx3 );
				idx2 = idx4 + 1;

				// 수신거부 일 경우에는 클릭아이디를 임의로 설정을 한다.
				if(content.indexOf("${REJECT}")>0){
					this.addLast( new LinkContent( 9999 , alt , content, url , src.substring( idx1 , idx2 ) ) );
					continue;
				}

				this.addLast( new LinkContent( linkCount++ , alt , content, url , src.substring( idx1 , idx2 ) ) );
				continue;
			}
			
			if( tag.startsWith( "<area " ) ) {
				url = StringUtil.getAttribute( org_tag , "href" );
				alt = StringUtil.getAttribute( org_tag , "alt" );
				
				if( alt == null || alt.length() == 0 ) alt = "IMAGE MAP";
				this.addLast( new LinkContent( linkCount++ , alt , alt, url , src.substring( idx1 , idx2 ) ) );
				continue;
			}
			
			this.addLast( src.substring( idx1 , idx2 ) );
		}
		
		if( idx1 < 0 ) this.addLast( src.substring( idx2 ) );
		if( idx2 < 0 ) this.addLast( src.substring( idx1 ) );
	}
}
