/*
 * @(#)FreemarkerBodyParser.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.parser;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import pluto.io.FileElement;
import pluto.io.eMsByteArrayOutputStream;
import pluto.io.eMsStringWriter;
import lombok.extern.slf4j.Slf4j;
import mercury.contents.auto.producer.BasicContentPD;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import freemarker20.template.SimpleHash;
import freemarker20.template.Template;

/**
 * 원본이 파일인 제작물을 사용, 파싱한다
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class FreemarkerBodyParser extends SimpleBodyParser {

	protected Template				body				= null;

	protected PrintWriter			writerContentComposer	= null;

	protected eMsStringWriter		writerStringBuffer	= null;

	public FreemarkerBodyParser() throws Exception {
		super();
		writerStringBuffer = new eMsStringWriter();
		writerContentComposer = new PrintWriter(writerStringBuffer);
	}

	/**
	 * 컨텐츠를 세팅한다.
	 * 
	 * @param src
	 *            메세지 원본 혹은 URL
	 * @throws Exception
	 *             생성에러
	 */
	public synchronized void setContents(String src) throws Exception {
		this.origin = src;

		FileElement fe = null;
		eMsByteArrayOutputStream INNER_BYTE_ARRAY_STREAM = null;
		try {
			INNER_BYTE_ARRAY_STREAM = eMsByteArrayOutputStream.getInstance();
			INNER_BYTE_ARRAY_STREAM.reset();

			fe = FileElement.getFileElement(src);
			fe.putStream(INNER_BYTE_ARRAY_STREAM);

			this.contents = INNER_BYTE_ARRAY_STREAM.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
			if (log.isDebugEnabled()) {
				log.debug("read template", this.contents);
			}
			setName(fe.getName());
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			if( fe != null ) {
				fe.close();
			}
			eMsByteArrayOutputStream.recycleInstance(INNER_BYTE_ARRAY_STREAM);
		}

		this.body = new Template();
		this.body.compileFromString(this.contents);
	}

	/**
	 * 저장 정보로 부터 컨텐츠를 복원할때 사용을 한다. 경로로 세팅을 했을 경우에 시간이 지나 없어질수 있기때문이다.
	 * 
	 * @param original
	 *            URL
	 * @param contents
	 *            파싱이나 읽어온 원본
	 * @throws Exception
	 *             생성에러
	 */
	public void setContents(String original, String contents, String name) throws Exception {
		this.origin = original;
		this.contents = contents;
		setName(name);
		if (log.isDebugEnabled()) {
			log.debug("recover template", this.contents);
		}
		this.body = new Template();
		this.body.compileFromString(this.contents);
	}

	/**
	 * 목적이되는 최종 산출물을 만드는 작업을 수행
	 * 
	 * @param a
	 *            최종 산출물을 생성할때 필요한 매핑데이터
	 * @throws Exception
	 *             생성중에러
	 * @return 매핑이 완료된 최종 제작물
	 */
	public synchronized String convert(Object info1, Object info2, Properties prop) throws Exception {
		SimpleHash map = null;

		if( info1 instanceof Map ) {
			map = ConvertMapToSimpleHash((Map) info1);
		}
		else if( info1 instanceof SimpleHash ) {
			map = (SimpleHash) info1;
		}
		else {
			throw new RuntimeException(" INVALID MAPPING OBJECT ");
		}

		String returnValue = null;

		// 스케쥴 정보로 들어오는 녀석을 매핑해야할 경우를 위한 조치임
		// 정보테이블( EBAD0020 / AUTO100 ) 등의 특정 값을 컨텐츠에 매핑해야할 경우에 SELECT한 INDEX를
		// 제작물에서 그대로 사용
		// 가능하게 하는 기능이 있다.
		if( prop != null ) {
			map.putMissedElement(prop);
		}

		writerContentComposer.flush();
		writerStringBuffer.reset();

		this.body.process(map, writerContentComposer);

		writerContentComposer.flush();

		returnValue = writerStringBuffer.toString();

		StringBuffer buffer = writerStringBuffer.getBuffer();
		if( info2 != null ) {
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, returnValue, info2, "@{", "}", info1, "${", "}", false, false);
			returnValue = buffer.toString();
		}

		return returnValue;
	}

	// 혹시나 GC가 호출해주기를 바라며....
	protected void finalize() throws Throwable {
		if( this.writerStringBuffer != null ) {
			this.writerStringBuffer.close();
			this.writerStringBuffer = null;
		}
	}

	protected static SimpleHash ConvertMapToSimpleHash(Map src) {
		SimpleHash returnValue = new SimpleHash();

		Iterator ENUM = src.keySet().iterator();
		Object key = null;
		while (ENUM.hasNext()) {
			key = ENUM.next();
			returnValue.put((String) key, (String) src.get(key));
		}

		return returnValue;
	}
}
