/*
 * @(#)DynamicMappingAttachBodyParser.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.parser;

import java.io.OutputStream;
import java.util.Map;

import pluto.io.BASE64EncodeOutputStream;
import pluto.io.FileElement;
import pluto.io.eMsByteArrayOutputStream;
import freemarker20.template.SimpleHash;

/**
 * contents를 넘겨 받을 때는 특별한 작업이 없음. ( 원본을 보존 )<br>
 * 
 * @version
 * @author dragon
 *  
 */
public class DynamicMappingAttachBodyParser extends SimpleBodyParser {
	protected eMsByteArrayOutputStream	bufferByteArray		= null;

	protected OutputStream				streamConvertBASE64	= null;

	/** Creates a new instance of DynamicMappingAttachBodyParser */
	public DynamicMappingAttachBodyParser() {
		super();
		this.bufferByteArray = new eMsByteArrayOutputStream(1024);
		this.streamConvertBASE64 = new BASE64EncodeOutputStream(bufferByteArray);
	}

	/**
	 * 컨텐츠를 셋팅한다. <br>
	 * 이녀석은 아마도 최종 결과물을 넘겨 받을때 매핑 변수일 것이다... <br>
	 * 신한생명에서 특정 컬럼을 매핑해야하기 때문에 새로이 생성되는 녀석이다.
	 * 
	 * @param src
	 *            메세지 원본 매핑 컬럼
	 * @throws Exception
	 *             생성에러
	 */
	public synchronized void setContents(String src) throws Exception {
		this.origin = src;
		setName(src);
	}

	/**
	 * 저장 정보로 부터 컨텐츠를 복원할때 사용을 한다. 경로로 세팅을 했을 경우에 시간이 지나 없어질수 있기때문이다.
	 * 
	 * @param original
	 *            URL
	 * @param contents
	 *            파싱이나 읽어온 원본
	 * @param contents
	 *            이름
	 * @throws Exception
	 *             생성에러
	 */
	public void setContents(String original, String contents, String name) throws Exception {
		this.origin = original;
		setName(original);
	}

	public synchronized String getContents() {
		return this.origin;
	}

	/**
	 * 목적이 되는 최종 산출물을 만드는 작업을 수행 <br>
	 * 여기서는 개인화가 되지 않으므로 세팅된 Contents를 그대로 반환한다.
	 * 
	 * @param info1
	 *            최종 산출물을 생성할때 필요한 개별 매핑데이터 <br>
	 *            그러나 무시된다.
	 * @param info2
	 *            최종 산출물을 생성할때 필요한 공용 매핑데이터 <br>
	 *            그러나 무시된다.
	 * @throws Exception
	 *             생성중에러
	 * @return 세팅된 Contents를 그대로 반환한다.
	 */
	public String convert(Object info1, Object info2) throws Exception {

		Map target = null;

		if( info1 instanceof Map ) {
			target = (Map) info1;
		}
		else if( info1 instanceof SimpleHash ) {
			target = ((SimpleHash) info1).getAsHashmap();
		}
		else {
			throw new RuntimeException("Unsupported Mapping Type : " + info1.getClass().getName());
		}

		// 매핑 요소중 지정된 어떤 녀석을 잡아 올리고...
		Object targetUrl = target.get(this.origin);

		// 없으면 에러고
		if( targetUrl == null ) {
			throw new RuntimeException("TargetFile Mapping Index Missing : " + this.origin);
		}

		// 대상 URL을 만들어서 올리면 되쥐....
		streamConvertBASE64.flush();
		bufferByteArray.reset();
		FileElement.putFileBodyToStream(targetUrl.toString(), streamConvertBASE64);
		streamConvertBASE64.flush();

		return bufferByteArray.toString();
	}
}
