/*
 * @(#)BodyParser.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.common.parser;

import java.util.Properties;

/**
 * 메일의 컨텐츠 내용을 Message로 전달하는 역할을 담당한다.
 * 
 * @version		
 * @author 		dragon
 *
 */
public interface BodyParser {
	
	
	/** 컨텐츠를 세팅한다.
	 * @param src 메세지 원본 혹은 URL
	 * @throws Exception 생성에러
	 */
	public void setContents( String src ) throws Exception;
	
	/** 저장 정보로 부터 컨텐츠를 복원할때 사용을 한다. 경로로 세팅을 했을 경우에 시간이 지나 없어질수 있기때문이다.
	 * @param original URL
	 * @param contents 파싱이나 읽어온 원본
	 * @param contents 이름
	 * @throws Exception 생성에러
	 */
	public void setContents( String original , String contents , String name ) throws Exception;
	
	/** 목적이되는 최종 산출물을 만드는 작업을 수행
	 * @param info1 최종 산출물을 생성할때 필요한 개인 매핑데이터
	 * @param info2 최종 산출물을 생성할때 필요한 공용 매핑데이터
	 * @throws Exception 생성중에러
	 * @return 매핑이 완료된 최종 제작물
	 */
	public String convert( Object info1, Object info2 , Properties prop ) throws Exception;
	
	/** 파일을 첨부해서 사용할 일이 있을때 파일이름을 반환한다.
	 * @return 파일이름
	 */
	public String getName();
	
	/** 세팅된 컨텐츠를 반환한다.
	 * @return 컨텐츠
	 */
	public String getContents();
	

	/** setContents에서 지정된 원본을 반환한다.
	 */	
	public String getOriginal();
	
}
