/*
 * @(#)BinaryAttachBodyParser.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.parser;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.io.BASE64EncodeOutputStream;
import pluto.io.FileElement;
import pluto.io.eMsByteArrayOutputStream;
import pluto.lang.eMsLocale;

/**
 * 바이너리 파일을 첨부할때 해당 파일을 읽어서 인코딩 까지 진행을 한다. <br>
 * 사용되는 경우는 일반 첨부파일이나 페이지 내의 이미지 첨부( 바코드 )일때 사용한다. <br>
 * 이거는 웹서버에서 ContentInfo 만들고 발송서버에서 땡기는 구조에서만 사용해야한다. <br>
 * 일반 자동메일이나 발송이 ContentInfo를 만들때 쓰면 안된다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class BinaryAttachBodyParser extends SimpleBodyParser {

	/** Creates new BinaryAttachBodyParser */
	public BinaryAttachBodyParser() {
		super();
	}

	/**
	 * 컨텐츠를 세팅한다. <br>
	 * 이부분은 대량의 경우 아마도 웹서버에서 호출된다. <br>
	 * 자동의 경우에는 발송엔진에서 호출된다.
	 * 
	 * @param src
	 *            메세지 원본 URL
	 * @throws Exception
	 *             생성에러
	 */
	public synchronized void setContents(String src) throws Exception {
		this.origin = src;
		this.contents = src;

		eMsByteArrayOutputStream INNER_BYTE_ARRAY_STREAM = null;
		try {
			INNER_BYTE_ARRAY_STREAM = eMsByteArrayOutputStream.getInstance();
			// 웹에서 저장할때는 그냥 검증하고 이름만 알아낸다.
			INNER_BYTE_ARRAY_STREAM.reset();

			BASE64EncodeOutputStream out = new BASE64EncodeOutputStream(INNER_BYTE_ARRAY_STREAM);

			FileElement fe = FileElement.getFileElement(this.origin);
			fe.putStream(out);
			out.flush();
			// 컨텐츠의 이름은 Message에서 지정되기 때문에 여기서 지정되는 이름은 사용되지 않는다.
			setName(fe.getName());
			fe.close();
		}
		finally {
			eMsByteArrayOutputStream.recycleInstance(INNER_BYTE_ARRAY_STREAM);
		}
	}
	
	/**
	 * 자동메일의 개별첨부에 사용되는 메소드. [use AttachableMailBody.java]
	 * @param src
	 * @throws Exception
	 */
	public synchronized void setContentsAttach(String src) throws Exception {
		this.origin = src;

		eMsByteArrayOutputStream INNER_BYTE_ARRAY_STREAM = null;
		
		FileElement fe = null;
		BASE64EncodeOutputStream out = null;
		
		try {
			INNER_BYTE_ARRAY_STREAM = eMsByteArrayOutputStream.getInstance();
			INNER_BYTE_ARRAY_STREAM.reset();

			out = new BASE64EncodeOutputStream(INNER_BYTE_ARRAY_STREAM);
			
			//[JOO] FTP ////////////////////////
			/**
			 * FTP로 전송된 첨부파일을 발송시 FTP로 가져와 첨부한다.
			 * 1. ftp를 통해 첨부파일을 local로 가져온다.
			 * 2. url을 local로 변경한 후 local파일 첨부를 진행한다. 
			 * 
			 * 주의: 전달되는 src는 확장자를 포함한 파일명만 전달한다. => ex) test.pdf
			 */
			//if(AttachableMailBody.FTP_USE_YN){
			//	this.origin = FtpClient.ftpDownload(AttachableMailBody.PROP_FTP_INFO, this.origin);
			//}
			////////////////////////////////////

			fe = FileElement.getFileElement(this.origin);
			fe.putStream(out);
			out.flush();
			//content setting
			this.contents = INNER_BYTE_ARRAY_STREAM.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
			
			setName(fe.getName());
			fe.close();
		} catch(Exception e) {
			log.error("Exception",e);
			throw e;
		}
		finally {
			if(out != null){
				out.close();
				out = null;
			}
			
			if(fe != null){
				fe.close();
				fe = null;
			}
			
			eMsByteArrayOutputStream.recycleInstance(INNER_BYTE_ARRAY_STREAM);
		}
	}	
	
	
	/**
	 * 자동메일의 개별첨부에 사용되는 메소드. [use AttachableMailBody.java]
	 * @param src
	 * @throws Exception
	 */
	public synchronized void setContentSslife(String src) throws Exception {
		this.origin = src;

		eMsByteArrayOutputStream INNER_BYTE_ARRAY_STREAM = null;
		
		FileElement fe = null;
		BASE64EncodeOutputStream out = null;
		
		try {
			INNER_BYTE_ARRAY_STREAM = eMsByteArrayOutputStream.getInstance();
			INNER_BYTE_ARRAY_STREAM.reset();

			out = new BASE64EncodeOutputStream(INNER_BYTE_ARRAY_STREAM);

			fe = FileElement.getFileElement(this.origin);
			fe.putStream(out);
			out.flush();
			//content setting
			this.contents = INNER_BYTE_ARRAY_STREAM.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
			
			setName(fe.getName());
			fe.close();
		} catch(Exception e) {
			log.error("Exception",e);
			throw e;
		}
		finally {
			if(out != null){
				out.close();
				out = null;
			}
			
			if(fe != null){
				fe.close();
				fe = null;
			}
			
			eMsByteArrayOutputStream.recycleInstance(INNER_BYTE_ARRAY_STREAM);
		}
	}	
	
	

	/**
	 * 세팅된 컨텐츠를 반환한다.
	 * 
	 * @return 컨텐츠
	 */
	public synchronized String getContents() {
		return this.origin;
	}

	/**
	 * 저장 정보로 부터 컨텐츠를 복원할때 사용을 한다. 경로로 세팅을 했을 경우에 시간이 지나 없어질수 있기때문이다.
	 * 
	 * @param original
	 *            URL
	 * @param contents
	 *            파싱이나 읽어온 원본
	 * @param contents
	 *            이름
	 * @throws Exception
	 *             생성에러
	 */
	public void setContents(String original, String contents, String name) throws Exception {
		this.origin = original;

		eMsByteArrayOutputStream INNER_BYTE_ARRAY_STREAM = null;
		try {
			INNER_BYTE_ARRAY_STREAM = eMsByteArrayOutputStream.getInstance();
			// 발송에서 복원할때는 원본을 가져다가 로컬에 저장하고 사용한다. 사라질지도 모르기 때문이다.
			INNER_BYTE_ARRAY_STREAM.reset();

			BASE64EncodeOutputStream out = new BASE64EncodeOutputStream(INNER_BYTE_ARRAY_STREAM);

			FileElement fe = FileElement.getFileElement(this.origin);
			fe.putStream(out);
			out.flush();
			this.contents = INNER_BYTE_ARRAY_STREAM.toString();
			setName(fe.getName());
			fe.close();
			// 컨텐츠의 이름은 Message에서 지정되기 때문에 여기서 지정되는 이름은 사용되지 않는다.
			setName(name);
		}finally {
			eMsByteArrayOutputStream.recycleInstance(INNER_BYTE_ARRAY_STREAM);
		}
	}

	/**
	 * 목적이되는 최종 산출물을 만드는 작업을 수행 <br>
	 * 여기서는 개인화가 되지 않으므로 세팅된 Contents를 그대로 반환한다.
	 * 
	 * @param info1
	 *            최종 산출물을 생성할때 필요한 개별 매핑데이터 <br>
	 *            그러나 무시된다.
	 * @param info2
	 *            최종 산출물을 생성할때 필요한 공용 매핑데이터 <br>
	 *            그러나 무시된다.
	 * @throws Exception
	 *             생성중에러
	 * @return 세팅된 Contents를 그대로 반환한다.
	 */
	public String convert(Object info1, Object info2, Properties prop) throws Exception {
		if( this.contents == null ) {
			eMsByteArrayOutputStream INNER_BYTE_ARRAY_STREAM = null;
			try {
				INNER_BYTE_ARRAY_STREAM = eMsByteArrayOutputStream.getInstance();
				INNER_BYTE_ARRAY_STREAM.reset();

				BASE64EncodeOutputStream out = new BASE64EncodeOutputStream(INNER_BYTE_ARRAY_STREAM);

				FileElement fe = FileElement.getFileElement(this.origin);
				fe.putStream(out);
				out.flush();
				this.contents = INNER_BYTE_ARRAY_STREAM.toString();
				setName(fe.getName());
				fe.close();
			}
			finally {
				eMsByteArrayOutputStream.recycleInstance(INNER_BYTE_ARRAY_STREAM);
			}
		}
		return this.contents;
	}
}
