/*
 * @(#)Message.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.message;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;

import mercury.contents.common.parser.BodyParser;

/**
 * 메세지 생성 룰을 정의한다.
 * 
 * @version
 * @author dragon
 *  
 */
public interface Message extends Serializable {

	/**
	 * Content 타입을 정의한다. <br>[ TEXT , HTML ]
	 * 
	 * @param type
	 *            Content 타입
	 * @see kr.co.amail.lang.eMsTypes#TEXT_PLAIN
	 * @see kr.co.amail.lang.eMsTypes#TEXT_HTML
	 */
	public void setContentType(Short type);

	/**
	 * Content type을 반환한다.
	 * 
	 * @return Content type
	 */
	public Short getContentType();

	/**
	 * 메세지의 케릭터 셋을 지정
	 * 
	 * @param charset
	 *            케릭터 셋
	 */
	public void setCharSet(String charset);

	/**
	 * 케릭터 셋을 반환한다.
	 * 
	 * @return 케릭터 셋
	 */
	public String getCharSet();

	/**
	 * 메세지의 인코딩 방식을 지정한다.
	 * 
	 * @param enc_type
	 *            메세지의 인코딩 방식
	 * @see kr.co.amail.lang.eMsTypes#ENC_BASE64
	 * @see kr.co.amail.lang.eMsTypes#ENC_QP
	 * @see kr.co.amail.lang.eMsTypes#ENC_UUENCODE
	 * @see kr.co.amail.lang.eMsTypes#ENC_8BIT
	 * @see kr.co.amail.lang.eMsTypes#ENC_7BIT
	 */
	public void setContentEncoding(Short enc_type);

	/**
	 * 컨텐트 인코딩 타입을 반환한다.
	 * 
	 * @return 컨텐트 인코딩 타입
	 * @see kr.co.amail.lang.eMsTypes#ENC_BASE64
	 * @see kr.co.amail.lang.eMsTypes#ENC_QP
	 * @see kr.co.amail.lang.eMsTypes#ENC_UUENCODE
	 * @see kr.co.amail.lang.eMsTypes#ENC_8BIT
	 * @see kr.co.amail.lang.eMsTypes#ENC_7BIT
	 */
	public Short getContentEncoding();

	/**
	 * Content를 작성하는 BodyParser를 지정한다.
	 * 
	 * @param content
	 *            Content를 작성하는 BodyParser
	 */
	public void setContent(BodyParser content);

	/**
	 * Content를 작성하는 BodyParser를 반환한다.
	 * 
	 * @return Content를 작성하는 BodyParser
	 */
	public BodyParser getContent();

	/**
	 * 메세지의 아이디를 지정한다.
	 * 
	 * @param id
	 *            메세지의 아이디
	 */
	public void setMessageID(String id);

	/**
	 * 메세지의 아이디를 반환한다.
	 * 
	 * @return 메세지의 아이디
	 */
	public String getMessageID();

	/**
	 * 메세지 본문을 반환한다.
	 * 
	 * @param info1
	 *            개인화 매핑 데이터
	 * @param info2
	 *            기본 매핑 데이터
	 * @throws Exception
	 *             작성시 에러
	 * @return 메세지 본문
	 */
	public String getStringMessage(Object info1, Object info2, Properties prop) throws Exception;

	public void putStringMessageToStream(Object info1, Object info2, Properties prop, OutputStream out) throws Exception;

	/**
	 * 메세지의 헤더를 반환한다.
	 * 
	 * @return 메세지 헤더
	 */
	public String getHeader();

	public void putHeaderToStream(OutputStream out) throws Exception;

	public void setContentName(String name);

	public String getContentName();
}
