/*
 * @(#)SingleTonMailBody.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.body;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import mercury.contents.common.message.Message;
import pluto.io.eMsByteArrayOutputStream;
import pluto.lang.eMsLocale;
import pluto.lang.eMsStringBuffer;
import pluto.lang.eMsTypes;
import pluto.util.Cal;
import pluto.util.convert.MimeConvertor;

/**
 * 기본적인 메일 Body를 생성하는 로직을 정의한다.
 * 
 * @version
 * @author dragon
 *  
 */
public class SingleTonMailBody implements MailBody {

	protected Message					myMessages				= null;

	protected Properties				ETC_HEADER				= null;

	protected String					SUBJECT					= null;

	protected String					FROM_NAME				= null;

	protected String					FROM_EMAIL				= null;

	protected String					TO_NAME					= null;

	protected String					TO_EMAIL				= null;

	protected String					ETC_HEADER_STRING		= null;

	protected String					HeaderString			= null;

	protected String					Body					= null;

	protected int						BODY_TYPE				= eMsTypes.SIMPLE_BODY;

	// 조립에 사용되는
	protected eMsByteArrayOutputStream	streamComposeContent	= null;

	/** Creates new SimpleMailBody */
	public SingleTonMailBody() {
		this.streamComposeContent = eMsByteArrayOutputStream.getInstance();
	}

	/**
	 * 메일의 기본 헤더를 제외한 추가헤더를 지정한다.
	 * 
	 * @param prop
	 *            헤더의 key/value Property
	 */
	public void setEtcHeader(Properties prop) {
		this.ETC_HEADER = prop;

		Enumeration keys = this.ETC_HEADER.propertyNames();
		eMsStringBuffer stringComposeBuffer = null;
		try {
			stringComposeBuffer = eMsStringBuffer.getInstance();
			stringComposeBuffer.setLength(0);

			String key = null;
			String value = null;

			while (keys.hasMoreElements()) {
				key = (String) keys.nextElement();

				if( !key.startsWith("X-") ) {
					continue;
				}

				value = this.ETC_HEADER.getProperty(key);

				stringComposeBuffer.append(key);
				stringComposeBuffer.append(": ");
				stringComposeBuffer.append(value);
				stringComposeBuffer.append("\r\n");
			}

			keys = this.ETC_HEADER.propertyNames();

			while (keys.hasMoreElements()) {
				key = (String) keys.nextElement();
				if( key.startsWith("X-") ) {
					continue;
				}
				value = this.ETC_HEADER.getProperty(key);

				stringComposeBuffer.append(key);
				stringComposeBuffer.append(": ");
				stringComposeBuffer.append(value);
				stringComposeBuffer.append("\r\n");
			}

			this.ETC_HEADER_STRING = stringComposeBuffer.toString();
		}
		finally {
			eMsStringBuffer.recycleInstance(stringComposeBuffer);
		}
	}

	/**
	 * 추가 헤더를 반환한다.
	 * 
	 * @return 추가 헤더
	 */
	public Properties getEtcHeader() {
		return this.ETC_HEADER;
	}

	/**
	 * 제목을 지정한다.
	 * 
	 * @param Subject
	 *            제목
	 */
	public void setSubject(String Subject) {
		this.SUBJECT = Subject;
	}

	/**
	 * 제목을 반환한다.
	 * 
	 * @return 메일 제목
	 */
	public String getSubject() {
		return this.SUBJECT;
	}

	/**
	 * 보낸사람 이름을 지정한다.
	 * 
	 * @param from_name
	 *            보내는 사람 이름
	 */
	public void setFromName(String from_name) {
		this.FROM_NAME = from_name;
	}

	/**
	 * 보내는 사람 이름을 반환한다.
	 * 
	 * @return 보내는 사람 이름
	 */
	public String getFromName() {
		return this.FROM_NAME;
	}

	/**
	 * 보내는사람 이메일을 지정한다.
	 * 
	 * @param from_email
	 *            보내는 사람 이메일
	 */
	public void setFromEmail(String from_email) {
		this.FROM_EMAIL = from_email;
	}

	/**
	 * 보내는 사람 이메일을 지정한다.
	 * 
	 * @return 보내는 사람 이메일
	 */
	public String getFromEmail() {
		return this.FROM_EMAIL;
	}

	/**
	 * 받는 사람이름을 지정한다.
	 * 
	 * @param to_name
	 *            받는 사람이름
	 */
	public void setToName(String to_name) {
		this.TO_NAME = to_name;
	}

	/**
	 * 받는 사람이름을 반환한다.
	 * 
	 * @return 받는 사람이름
	 */
	public String getToName() {
		return this.TO_NAME;
	}

	/**
	 * 받는사람 이메일을 지정한다.
	 * 
	 * @param to_email
	 *            받는사람 이메일
	 */
	public void setToEmail(String to_email) {
		this.TO_EMAIL = to_email;
	}

	/**
	 * 받는사람 이메일을 반환한다.
	 * 
	 * @return 받는사람 이메일
	 */
	public String getToEmail() {
		return this.TO_EMAIL;
	}

	/**
	 * 메일 구성 메세지를 지정한다.
	 * 
	 * @param msg
	 *            메일 구성 메세지
	 */
	public void setMessage(Message msg) {
		myMessages = msg;
	}

	/**
	 * 메일 구성 메세지를 반환한다.
	 * 
	 * @return 메일 구성 메세지
	 */
	public Vector getMessage() {
		// do nothing
		throw new RuntimeException("NOT IMPLEMENTS");
	}

	// public static final byte[]	NEW_LINE	= "\r\n".getBytes();	
	protected static final byte[]	NEW_LINE	= "\r\n".getBytes();

	/**
	 * 개인매핑데이터와 기본매핑데이터 둘다 사용하는 메일을 생성한다.
	 * 
	 * @param info1
	 *            개인매핑데이터
	 * @param info2
	 *            기본매핑데이터
	 * @throws Exception
	 *             생성에러
	 * @return 최종생성된 메일
	 */
	public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
		this.streamComposeContent.reset();

		setHeaderString(info1, info2, SCHEDULE_INFO, this.streamComposeContent);

		/* 메세지 헤더를 추가 */
		myMessages.putHeaderToStream(this.streamComposeContent);

		/* 헤더와 본문의 구분 개행 문자 추가 */
		this.streamComposeContent.write(NEW_LINE);
		this.streamComposeContent.write(NEW_LINE);

		/* 본문 추가 */
		myMessages.putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.streamComposeContent);
		this.streamComposeContent.write(NEW_LINE);

		return this.streamComposeContent.toString();
	}

	/////////////// MailBody Interface에는 선언되지 않았지만 내부적으로 사용하게 되는 method들 이다.

	/**
	 * 개인화매핑과 기본매핑을 동시에한 헤더를 반환한다.
	 * 
	 * @param info1
	 *            개인화 매핑데이터
	 * @param info2
	 *            기본 매핑데이터
	 * @return 생성된 헤더
	 */
	protected void setHeaderString(Object info1, Object info2, Properties prop, eMsByteArrayOutputStream tmpOutStream) throws Exception {
		// 보내는 사람 이름 붙이기

		String HEADER_BASE_CHAR_SET = prop.getProperty("HEADER_BASE_CHAR_SET", eMsLocale.HEADER_BASE_CHAR_SET);
        String HEADER_MIME_CHAR_SET = prop.getProperty("HEADER_MIME_CHAR_SET", eMsLocale.HEADER_MIME_CHAR_SET);
        
		tmpOutStream.write("From: \"".getBytes(HEADER_BASE_CHAR_SET));
		
		if( eMsLocale.HEADER_ENCODE ) {
			MimeConvertor.putHeaderToStream(tmpOutStream, this.FROM_NAME, HEADER_BASE_CHAR_SET, HEADER_MIME_CHAR_SET, eMsTypes.ENC_BASE64);
		}
		else {
			tmpOutStream.write(this.FROM_NAME.getBytes( HEADER_BASE_CHAR_SET ));
		}

		tmpOutStream.write("\" <".getBytes());
		tmpOutStream.write(this.FROM_EMAIL.getBytes());
		tmpOutStream.write(">\r\n".getBytes());

		//받는 사람 붙이기
		tmpOutStream.write("To: \"".getBytes());

		if( eMsLocale.HEADER_ENCODE ) {
			MimeConvertor.putHeaderToStream(tmpOutStream, this.TO_NAME, eMsLocale.MAIL_BASE_CHAR_SET, HEADER_MIME_CHAR_SET, eMsTypes.ENC_BASE64);
		}
		else {
			tmpOutStream.write(this.TO_NAME.getBytes(HEADER_BASE_CHAR_SET));
		}

		tmpOutStream.write("\" <".getBytes());
		tmpOutStream.write(this.TO_EMAIL.getBytes());
		tmpOutStream.write(">\r\n".getBytes());

		// Reply - to 붙이기
		tmpOutStream.write("Reply-to: <".getBytes());
		tmpOutStream.write(this.FROM_EMAIL.getBytes());
		tmpOutStream.write(">\r\n".getBytes());

		// Subject 붙이기
		tmpOutStream.write("Subject: ".getBytes(HEADER_BASE_CHAR_SET));

		// 길 제목은 잘라서 붙여야 하므로.. 수정.
		MimeConvertor.putSubjectToStream(tmpOutStream, this.SUBJECT, HEADER_BASE_CHAR_SET, HEADER_MIME_CHAR_SET,eMsLocale.HEADER_ENCODE);

		tmpOutStream.write("\r\n".getBytes());

		tmpOutStream.write("Date: ".getBytes());
		tmpOutStream.write(Cal.getHeaderDate().getBytes());

		tmpOutStream.write("\r\n".getBytes());

		tmpOutStream.write("X-WORKER_ID: <".getBytes());
		tmpOutStream.write(Thread.currentThread().getName().getBytes());
		tmpOutStream.write(">\r\n".getBytes());

		tmpOutStream.write(this.ETC_HEADER_STRING.getBytes());

		return;
	}

	/**
	 * 마임타입 메일을 생성할때 바운더리를 생성한다.
	 * 
	 * @return 생성된 Boundary
	 */
	protected String getBoundaryString() {
		return "_nextpart_" + Cal.getBoundaryDate() + "." + System.currentTimeMillis();
	}

	/**
	 * 개인매핑데이터와 기본매핑데이터 둘다 사용하는 PreView용 메일본문을 생성한다.
	 * 
	 * @param info1
	 *            개인매핑데이터
	 * @param info2
	 *            기본매핑데이터
	 * @throws Exception
	 *             생성에러
	 * @return 최종생성된 메일
	 */
	public String getPreViewMailBody(Object info1, Object info2, Properties prop) throws Exception {
		//
		throw new RuntimeException("NOT IMPLEMENT");
	}
	
	public String getSpoolPrev(Object info1, Object info2, Properties prop) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	// 혹시나 GC가 호출해주기를 바라며....
	protected void finalize() throws Throwable {
		eMsByteArrayOutputStream.recycleInstance(this.streamComposeContent);
	}
}
