/*
 * @(#)SimpleMailBody.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.body;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

import mercury.contents.auto.producer.BasicContentPD;
import mercury.contents.common.message.Message;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.convert.BASE64;
import pluto.util.convert.MimeConvertor;
import pluto.util.convert.TrackingInfoConvertor;
import freemarker20.template.SimpleHash;

/**
 * 기본적인 메일 body의 구성 / 헤더와 메시지 작성, 인코딩 처리 등을 담당
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class SimpleMailBody implements MailBody {

	// public static final byte[]			NEW_LINE				= "\r\n".getBytes();
	
	protected static final byte[]			NEW_LINE				= "\r\n".getBytes();

	protected Vector					myMessages				= new Vector();

	protected Properties				ETC_HEADER				= null;

	protected String					SUBJECT					= null;

	protected String					FROM_NAME				= null;

	protected String					FROM_EMAIL				= null;

	protected String					TO_NAME					= null;

	protected String					TO_EMAIL				= null;

	protected String					ETC_HEADER_STRING		= null;

	protected String					HeaderString			= null;

	protected String					Body					= null;

	protected int						BODY_TYPE				= eMsTypes.SIMPLE_BODY;

	//	 hmall by hakji 2009.04.17
	protected ByteArrayOutputStream		byteBuffer				= null;
	
	/** Creates new SimpleMailBody */
	public SimpleMailBody() {
		// hmall by hakji 2009.04.17
		byteBuffer = new ByteArrayOutputStream(512);
	}

	/**
	 * 메일의 기본 헤더를 제외한 추가헤더를 지정한다.
	 * 
	 * @param prop
	 *            헤더의 key/value Property
	 */
	public synchronized void setEtcHeader(Properties prop) throws Exception {
		this.ETC_HEADER = prop;

		Enumeration keys = this.ETC_HEADER.propertyNames();

		ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(512);
		
		String key = null;
		String value = null;

		while (keys.hasMoreElements()) {
			key = (String) keys.nextElement();

			if( !key.startsWith("X-") ) {
				continue;
			}

			value = this.ETC_HEADER.getProperty(key);

			byteBuffer.write(key.getBytes(eMsLocale.CHAR_SET));
			byteBuffer.write(": ".getBytes());
			byteBuffer.write(value.getBytes(eMsLocale.CHAR_SET));
			byteBuffer.write(NEW_LINE);
		}

		keys = this.ETC_HEADER.propertyNames();

		while (keys.hasMoreElements()) {
			key = (String) keys.nextElement();
			if( key.startsWith("X-") ) {
				continue;
			}
			value = this.ETC_HEADER.getProperty(key);

			byteBuffer.write(key.getBytes( eMsLocale.CHAR_SET ));
			byteBuffer.write(": ".getBytes());
			byteBuffer.write(value.getBytes( eMsLocale.CHAR_SET ));
			byteBuffer.write(NEW_LINE);
		}

		this.ETC_HEADER_STRING = byteBuffer.toString();
	}

	/**
	 * 추가 헤더를 반환한다.
	 * 
	 * @return 추가 헤더
	 */
	public synchronized Properties getEtcHeader() {
		return this.ETC_HEADER;
	}

	/**
	 * 제목을 지정한다.
	 * 
	 * @param Subject
	 *            제목
	 */
	public void setSubject(String Subject) {
		this.SUBJECT = Subject;
	}

	/**
	 * 제목을 반환한다.
	 * 
	 * @return 메일 제목
	 */
	public String getSubject() {
		return this.SUBJECT;
	}

	/**
	 * 보낸사람 이름을 지정한다.
	 * 
	 * @param from_name
	 *            보내는 사람 이름
	 */
	public void setFromName(String from_name) {
		this.FROM_NAME = from_name;
	}

	/**
	 * 보내는 사람 이름을 반환한다.
	 * 
	 * @return 보내는 사람 이름
	 */
	public String getFromName() {
		return this.FROM_NAME;
	}

	/**
	 * 보내는사람 이메일을 지정한다.
	 * 
	 * @param from_email
	 *            보내는 사람 이메일
	 */
	public void setFromEmail(String from_email) {
		this.FROM_EMAIL = from_email;
	}

	/**
	 * 보내는 사람 이메일을 지정한다.
	 * 
	 * @return 보내는 사람 이메일
	 */
	public String getFromEmail() {
		return this.FROM_EMAIL;
	}

	/**
	 * 받는 사람이름을 지정한다.
	 * 
	 * @param to_name
	 *            받는 사람이름
	 */
	public void setToName(String to_name) {
		this.TO_NAME = to_name;
	}

	/**
	 * 받는 사람이름을 반환한다.
	 * 
	 * @return 받는 사람이름
	 */
	public String getToName() {
		return this.TO_NAME;
	}

	/**
	 * 받는사람 이메일을 지정한다.
	 * 
	 * @param to_email
	 *            받는사람 이메일
	 */
	public void setToEmail(String to_email) {
		this.TO_EMAIL = to_email;
	}

	/**
	 * 받는사람 이메일을 반환한다.
	 * 
	 * @return 받는사람 이메일
	 */
	public String getToEmail() {
		return this.TO_EMAIL;
	}

	/**
	 * 메일 구성 메세지를 지정한다.
	 * 
	 * @param msg
	 *            메일 구성 메세지
	 */
	public void setMessage(Message msg) {
		this.myMessages.addElement(msg);
		this.BODY_TYPE = this.myMessages.size() > 1 ? eMsTypes.MIME_BODY : eMsTypes.SIMPLE_BODY;
	}

	/**
	 * 메일 구성 메세지를 반환한다.
	 * 
	 * @return 메일 구성 메세지
	 */
	public Vector getMessage() {
		return this.myMessages;
	}

	/**
	 * 개인매핑데이터와 기본매핑데이터 둘다 사용하는 메일을 생성한다.
	 * 
	 * @param info1
	 *            개인매핑데이터
	 * @param info2
	 *            기본매핑데이터
	 * @throws Exception
	 *             생성에러
	 * @return 최종생성된 메일
	 */
	public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
		
		ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(512);
		String returnStr = "";
		
		try {
			
			setHeaderString(info1, info2, SCHEDULE_INFO, byteBuffer);
	
			if (log.isDebugEnabled()) {
				log.debug("header", byteBuffer.toString());
			}
	
			switch (this.BODY_TYPE) {
				case eMsTypes.SIMPLE_BODY: {
	
					/* 메세지 헤더를 추가 */
					((Message) this.myMessages.get(0)).putHeaderToStream(byteBuffer);
	
					/* 헤더와 본문의 구분 개행 문자 추가 */
					byteBuffer.write(NEW_LINE);
	
					// 메세지 헤더 추가된후 거시기 보기
					if (log.isDebugEnabled()) {
						log.debug(Thread.currentThread().getName() + "'s add message HEADER => " + byteBuffer.toString());
					}
	
					/* 본문 추가 */
					((Message) this.myMessages.get(0)).putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
					byteBuffer.write(NEW_LINE);
	
					// 메세지 헤더 추가된후 거시기 보기
					if (log.isDebugEnabled()) {
						log.debug(Thread.currentThread().getName() + "'s add message BODY => " + byteBuffer.toString());
					}
					break;
				}
	
				case eMsTypes.MIME_BODY: {
					/* 바운더리 생성 */
					String boundary = getBoundaryString();
	
					/* 마임메세지 헤더를 추가 */
					byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
					byteBuffer.write("\tboundary=\"".getBytes());
					byteBuffer.write(boundary.getBytes());
	
					/* 헤더와 본문의 구분 개행 문자 추가 */
					byteBuffer.write("\"\r\n\r\n".getBytes());
	
					/* 기본 메세지 추가 */
					byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());
	
					Message tmpMessage = null;
					for (int i = 0; i < this.myMessages.size(); i++) {
						tmpMessage = (Message) this.myMessages.get(i);
						byteBuffer.write("\n--".getBytes());
						byteBuffer.write(boundary.getBytes());
						byteBuffer.write(NEW_LINE);
						// 헤더쓰기
						tmpMessage.putHeaderToStream(byteBuffer);
	
						byteBuffer.write(NEW_LINE);
	
						// 본문쓰기
						tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
	
						byteBuffer.write(NEW_LINE);
					}
					byteBuffer.write("\r\n--".getBytes());
					byteBuffer.write(boundary.getBytes());
					byteBuffer.write("--\r\n\r\n".getBytes());
				}
			}
	
			returnStr = byteBuffer.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
		//} catch(Exception e) {
		
		}catch(UnsupportedEncodingException ex){
			log.error(ex.getMessage());
		}catch(Exception e){
			
			throw new Exception(e);
		}finally {
		
			byteBuffer.close();
			byteBuffer = null;
		}
		
		return returnStr;
	}

	/////////////// MailBody Interface에는 선언되지 않았지만 내부적으로 사용하게 되는 method들 이다.

	/**
	 * 개인화매핑과 기본매핑을 동시에한 헤더를 반환한다.
	 * 
	 * @param info1
	 *            개인화 매핑데이터
	 * @param info2
	 *            기본 매핑데이터
	 * @return 생성된 헤더
	 */
	protected void setHeaderString(Object info1, Object info2, Properties prop, ByteArrayOutputStream tmpOutStream) throws Exception {
		Map INFO_MAP1 = null;

		Object mail_id = null;
		Object tbl_id = null;
		Object member_id = null;
		Object send_type = null;

        boolean HEADER_ENCODE = prop.getProperty("HEADER_ENCODE", "none").equals("none") ? eMsLocale.HEADER_ENCODE : prop.getProperty("HEADER_ENCODE").equals("true");

        String HEADER_BASE_CHAR_SET = prop.getProperty("HEADER_BASE_CHAR_SET", eMsLocale.HEADER_BASE_CHAR_SET);
        String HEADER_MIME_CHAR_SET = prop.getProperty("HEADER_MIME_CHAR_SET", eMsLocale.HEADER_MIME_CHAR_SET);
        if("".equals(HEADER_BASE_CHAR_SET)){
        	HEADER_BASE_CHAR_SET = eMsLocale.HEADER_BASE_CHAR_SET;
        	HEADER_MIME_CHAR_SET = eMsLocale.HEADER_MIME_CHAR_SET;
        }
        
		// 첫번째 매핑이 있다면
		if( info1 != null ) {
			if( info1 instanceof Map ) {
				INFO_MAP1 = (Map) info1;
			}
			else if( info1 instanceof SimpleHash ) {
				INFO_MAP1 = ((SimpleHash) info1).getAsHashmap();
			}
			else {
				throw new RuntimeException("UNSUPPORTED HASH TYPE");
			}

			mail_id = prop.getProperty("POST_ID");
			mail_id = mail_id == null ? null : TrackingInfoConvertor.enc_MAIL_ID(mail_id.toString());
			tbl_id = prop.getProperty("LIST_TABLE");
			tbl_id = tbl_id == null ? null : TrackingInfoConvertor.enc_LIST_TABLE(tbl_id.toString());
			member_id = INFO_MAP1.get("enc_mid");
			send_type = INFO_MAP1.get("enc_s_type");
		}

		String from_name = this.FROM_NAME;
		String from_email = this.FROM_EMAIL;
		String to_name = this.TO_NAME;
		String to_email = this.TO_EMAIL;

		String subject = this.SUBJECT;

		//테스트 발송을 한다라고 하면 추가되는 헤더가 있을지도 모르기 때문에 생성
		String TEST_ATTACH_HEADER = prop.getProperty("TEST_ATTACH_HEADER");
		if( TEST_ATTACH_HEADER != null ) {
			subject = this.SUBJECT.concat(TEST_ATTACH_HEADER);
		}

		String etc_header_string = this.ETC_HEADER_STRING;

		/*
		 * 1차 매핑
		 */
		StringBuffer buffer = new StringBuffer(128);
		if( info1 != null ) {
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, from_name, info1, "${", "}", false, false);
			from_name = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, from_email, info1, "${", "}", false, false);
			from_email = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, to_name, info1, "${", "}", false, false);
			to_name = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, to_email, info1, "${", "}", false, false);
			to_email = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, subject, info1, "${", "}", false, false);
			subject = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, etc_header_string, info1, "${", "}", false, false);
			etc_header_string = buffer.toString();
		}

		/*
		 * 2차 매핑
		 */
		if( info2 != null ) {
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, from_name, info2, "@{", "}", false, false);
			from_name = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, from_email, info2, "@{", "}", false, false);
			from_email = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, to_name, info2, "@{", "}", false, false);
			to_name = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, to_email, info2, "@{", "}", false, false);
			to_email = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, subject, info2, "@{", "}", false, false);
			subject = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, etc_header_string, info2, "@{", "}", false, false);
			etc_header_string = buffer.toString();
		}
		
		tmpOutStream.write("From: \"".getBytes(HEADER_BASE_CHAR_SET));

		if( HEADER_ENCODE ) {
			MimeConvertor.putHeaderToStream(tmpOutStream, from_name, HEADER_BASE_CHAR_SET, HEADER_MIME_CHAR_SET, eMsTypes.ENC_BASE64);
		}
		else {
			tmpOutStream.write(from_name.getBytes(HEADER_BASE_CHAR_SET));
		}

		tmpOutStream.write("\" <".getBytes());
		tmpOutStream.write(from_email.getBytes());
		tmpOutStream.write(">\r\n".getBytes());

		//받는 사람 붙이기
		tmpOutStream.write("To: \"".getBytes());

		if( HEADER_ENCODE ) {
			MimeConvertor.putHeaderToStream(tmpOutStream, to_name, HEADER_BASE_CHAR_SET, HEADER_MIME_CHAR_SET, eMsTypes.ENC_BASE64);
		}
		else {
			tmpOutStream.write(to_name.getBytes(HEADER_BASE_CHAR_SET));
		}

		tmpOutStream.write("\" <".getBytes());
		tmpOutStream.write(to_email.getBytes());
		tmpOutStream.write(">\r\n".getBytes());

		// Reply - to 붙이기
		tmpOutStream.write("Reply-to: <".getBytes());
		tmpOutStream.write(prop.getProperty("REPLY_TO", from_email).getBytes());
		tmpOutStream.write(">\r\n".getBytes());

		// Subject 붙이기
		tmpOutStream.write("Subject: ".getBytes(HEADER_BASE_CHAR_SET));

		// 길 제목은 잘라서 붙여야 하므로.. 수정.
		MimeConvertor.putSubjectToStream(tmpOutStream, subject, HEADER_BASE_CHAR_SET, HEADER_MIME_CHAR_SET,HEADER_ENCODE);

		tmpOutStream.write("\r\n".getBytes());

		tmpOutStream.write("Date: ".getBytes());
		tmpOutStream.write(Cal.getHeaderDate().getBytes());

		tmpOutStream.write("\r\n".getBytes());

		tmpOutStream.write("X-WORKER_ID: <".getBytes());
		tmpOutStream.write(Thread.currentThread().getName().getBytes());
		tmpOutStream.write(">\r\n".getBytes());

		if( mail_id != null ) {
			tmpOutStream.write("X-MAIL_ID: <".getBytes());
			tmpOutStream.write(mail_id.toString().getBytes());
			tmpOutStream.write(">\r\n".getBytes());
		}

		if( member_id != null ) {
			tmpOutStream.write("X-MEMBER_ID: <".getBytes());
			tmpOutStream.write(member_id.toString().getBytes(HEADER_BASE_CHAR_SET));
			tmpOutStream.write(">\r\n".getBytes());
		}

		if( send_type != null ) {
			tmpOutStream.write("X-SEND_TYPE: <".getBytes());
			tmpOutStream.write(send_type.toString().getBytes());
			tmpOutStream.write(">\r\n".getBytes());
		}

		if( tbl_id != null ) {
			tmpOutStream.write("X-LIST_TABLE: <".getBytes());
			tmpOutStream.write(tbl_id.toString().getBytes());
			tmpOutStream.write(">\r\n".getBytes());
		}
		
		tmpOutStream.write(etc_header_string.getBytes());
		return;
	}

	/**
	 * 마임타입 메일을 생성할때 바운더리를 생성한다.
	 * 
	 * @return 생성된 Boundary
	 */
	protected String getBoundaryString() {
		return "_nextpart_" + Cal.getBoundaryDate() + "." + System.currentTimeMillis();
	}

	/**
	 * 개인매핑데이터와 기본매핑데이터 둘다 사용하는 PreView용 메일본문을 생성한다.
	 * 
	 * @param info1
	 *            개인매핑데이터
	 * @param info2
	 *            기본매핑데이터
	 * @throws Exception
	 *             생성에러
	 * @return 최종생성된 메일
	 */
	public String getPreViewMailBody(Object info1, Object info2, Properties prop) throws Exception {
		String content = ((Message)this.myMessages.get( 0 )).getStringMessage( info1 , info2 , null );
		return BASE64.encode(content);
		//return content;
	}
	//kdy0831 start
	public String getSpoolPrev(Object info1, Object info2, Properties prop) throws Exception {
		String content = ((Message)this.myMessages.get( 0 )).getStringMessage( info1 , info2 , null );
		return content;
	}
	//kdy0831 end

	// 혹시나 GC가 호출해주기를 바라며....
	protected void finalize() throws Throwable {
	}
}
