/*
 * @(#)SimpleBulkMailBody.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.body;

import java.io.ByteArrayOutputStream;
import java.util.Properties;

import pluto.io.eMsByteArrayOutputStream;

/**
 * 기본적인 동보 메일 body
 * 
 * @version
 * @author dragon
 *  
 */
public class SimpleBulkMailBody extends SimpleMailBody {

	private String	MAKED_BODY		= null;

	private byte[]	MAKED_HEADER	= null;

	/** Creates new SimpleBulkMailBody */
	public SimpleBulkMailBody() {
	}

	public String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
		if( MAKED_BODY == null )
			MAKED_BODY = super.getMailBody(info1, info2, SCHEDULE_INFO);
		return MAKED_BODY;
	}

	protected void setHeaderString(Object info1, Object info2, Properties prop, eMsByteArrayOutputStream tmpOutStream) throws Exception {

		if( MAKED_HEADER == null ) {

			ByteArrayOutputStream byteBuffer = null;

			try {
				byteBuffer = new ByteArrayOutputStream(1024);;
				super.setHeaderString(info1, info2, prop, byteBuffer);
				MAKED_HEADER = byteBuffer.toByteArray();
			}
			catch(Exception e) {
				throw new RuntimeException(e.toString());
			}
			finally {
				if(byteBuffer != null) {
					byteBuffer.close();
					byteBuffer = null;
				}
			}
		}
		tmpOutStream.write(MAKED_HEADER);
	}
}
