/*
 * @(#)SecureMailBody.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.body;

import java.io.ByteArrayOutputStream;
import java.util.Properties;

import freemarker20.template.SimpleHash;
import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.message.Message;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.io.eMsByteArrayOutputStream;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.util.StringConvertUtil;
import pluto.util.convert.MimeConvertor;

/**
 * 보안 메일 내용의 기본 로직에 대한 구조를 정의한다
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public abstract class SecureMailBody extends SimpleMailBody {

	/** Creates new SimpleMailBody */
	protected static boolean		DEFAULT_ATTACH				= false;

	protected static String			SECURE_INTRO_TEMPLATE	= null;

	protected static String			EXCEPT_DOMAIN				= null;

	protected static String			SECURE_ATTACH_FILE_NAME		= null;

	protected String				REAL_ATTACH_TEMPLATE		= null;
	
	protected String				NO_SECURE_INTRO_TEMPLATE	= null;

	protected static boolean		NON_SECURE_ATTACH_FLAG		= false;
	
	public static String            CONTENTS_BASE_URL = null;
	
	public static String            NO_ATTACH_INTRO   = "/samsunglife/intro/intro_no_secure.html";
	
	
	static{
		CONTENTS_BASE_URL = eMsSystem.getProperty("contents.base.url");
	}
	
	
	public SecureMailBody() {
		super();
	}

	protected abstract String getSecureMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception;

	protected String getOriginalMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
		return super.getMailBody(info1, info2, SCHEDULE_INFO);
	}
	
	protected String getNoSecureBodyNBase(Object info1, Object info2, Properties SCHEDULE_INFO) {
		String body_string = "";
		return body_string;
	}

	/**
	 * 개인매핑데이터와 기본매핑데이터 로 암호화된 메일을 생성한다.
	 * 
	 * @param info1
	 *            개인매핑데이터
	 * @param info2
	 *            기본매핑데이터
	 * @throws Exception
	 *             생성에러
	 * @return 최종생성된 메일
	 */
	public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
		SimpleHash __INFO1__ = (SimpleHash) info1;

		// 초기 메세지 원문을 암호화 하는 것을 하부 구현 클래스에서 받아온다.
		String body_string = getSecureMailBody(info1, info2, SCHEDULE_INFO);

		// 널을 반환받으면 보안취소
		if( body_string == null ) {
			return super.getMailBody(info1, info2, SCHEDULE_INFO);
		}
		
//		String domain = StringUtil.getDomain(__INFO1__.getAsStringWithError("TMS_M_TOKEN"));

		// 작업버퍼를 초기화한다.
		ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(2048);
		StringBuffer buffer = new StringBuffer(2048);
		String returnStr = "";
		
		try {

			// ActiveX 지원하지 않는 도메인이나 멀티파트일 경우와 그냥 메세지만 보내는 경우를 분리하여 메일 생성

			// 일단 기본 메일 헤더를 붙인다.
			setHeaderString(info1, info2, SCHEDULE_INFO, byteBuffer);
			
			
		/*	
			if(__INFO1__.getAsString("EMS_M_SECURE", "0").equalsIgnoreCase("1") && __INFO1__.getAsString("EMS_M_SECURE_ATTACH", "0").equalsIgnoreCase("1")) {
				// 암호화 메일 대상이 아니고 첨부파일 발송이 아닐 때
				makeExceptMailBody(byteBuffer, body_string, info1, info2, SCHEDULE_INFO);
			}
			else if( (DEFAULT_ATTACH && EXCEPT_DOMAIN.indexOf(domain) > 0) || (!DEFAULT_ATTACH && EXCEPT_DOMAIN.indexOf(domain) < 0) ) {
				// 디폴트가 첨부이면서 예외도메인에 속해있거나 디폴트가 삽입이면서 예외도메인에 속해있지 않다면 삽입방식이 된다.
				// 첨부로 보내지 않아도 되는메일
				// 첨부파일은 보안메일 안에 포함되어 암호화 되기 때문에 여기서는 추가로 첨부하지 않는다.
				//첨부파일추가  by jini
				if(NON_SECURE_ATTACH_FLAG){
					makeExceptMailBody(byteBuffer, body_string, info1, info2, SCHEDULE_INFO);
				}else{
					((Message) this.myMessages.get(0)).putHeaderToStream(byteBuffer);
					byteBuffer.write(NEW_LINE);
					byteBuffer.write(body_string.getBytes( eMsLocale.CHAR_SET));
					byteBuffer.write(NEW_LINE);
				}
			}
			else {
				*/
				
				
				// 첨부해서 나가지 않는 도메인일 경우에 일반 메세지만 있는경우와 첨부파일이 있는 경우 다르게 생성이 된다. 첨부 파일이
				// 없으면 일단 기본 템플릿을 메세지로 하고 암호화메일을 첨부를 한다. 첨부파일이 있을 경우 다음에 계속 붙여 나가면
				// 된다.
	
				/* 바운더리 생성 */
				String boundary = getBoundaryString();
	
				/* 마임메세지 헤더를 추가 */
				byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
				byteBuffer.write("\tboundary=\"".getBytes());
				byteBuffer.write(boundary.getBytes(eMsLocale.MAIL_BASE_CHAR_SET));
	
				/* 헤더와 본문의 구분 개행 문자 추가 */
				byteBuffer.write("\"\r\n\r\n\r\n".getBytes());
	
				/* 마임 메세지 추가 */
				byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());
	
				
				// intro 페이지 
				String INTRO_TEMPLATE = "";
				String EMS_M_SECURE = __INFO1__.getAsString("EMS_M_SECURE", "Y");
				if( EMS_M_SECURE.equalsIgnoreCase("N") || EMS_M_SECURE.equalsIgnoreCase("1") ) {
					//삼성생명 전용 코딩. 비보안 첨부일때 사용할 intro 
					if(this.NO_SECURE_INTRO_TEMPLATE == null){
						String base_template = "";
						String ATTACH_TEMPLATE = NO_ATTACH_INTRO;
						
						if (log.isDebugEnabled()) 
							log.debug("attach_key", ATTACH_TEMPLATE);
		
						if( ATTACH_TEMPLATE == null ) {
							throw new RuntimeException("NO_SECURE_INTRO_TEMPLATE IS NOT SET!!!");
						}
						
						if( ATTACH_TEMPLATE.startsWith("/") ){
							buffer.setLength(0);
							buffer.append(CONTENTS_BASE_URL);
							buffer.append(ATTACH_TEMPLATE);
							base_template =  buffer.toString();
						}else{
							base_template = ATTACH_TEMPLATE;
						}
		
						eMsByteArrayOutputStream out = null;
						try {
							out = eMsByteArrayOutputStream.getInstance();
							out.reset();
							FileElement.putFileBodyToStream(base_template, out);
							this.NO_SECURE_INTRO_TEMPLATE = out.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
						}finally {
							eMsByteArrayOutputStream.recycleInstance(out);
						}
		
						// 바닥 템플릿을 인코딩 하지 않기 때문에 "." 를 ".."로 전환해야한다.
						this.NO_SECURE_INTRO_TEMPLATE = StringConvertUtil.GeneralizeMailContents(this.NO_SECURE_INTRO_TEMPLATE);
		
						if (log.isDebugEnabled()) {
							log.debug("SECURE ATTACH CHOICE", "default attache template");
						}
					}
					//기본 비보안 intro 세팅
					INTRO_TEMPLATE = this.NO_SECURE_INTRO_TEMPLATE;
				}else{
					//삼성생명 전용 코딩. 보안 첨부일때 사용할 intro 
					if( this.REAL_ATTACH_TEMPLATE == null ) {
						String base_template = "";
						String ATTACH_TEMPLATE = SCHEDULE_INFO.getProperty("SECURE_INTRO_TEMPLATE", SECURE_INTRO_TEMPLATE);
						
						if (log.isDebugEnabled()) 
							log.debug("attach_key", ATTACH_TEMPLATE);
		
						if( ATTACH_TEMPLATE == null ) {
							throw new RuntimeException("SECURE_INTRO_TEMPLATE IS NOT SET!!!");
						}
						if( ATTACH_TEMPLATE.startsWith("/") ){
							buffer.setLength(0);
							buffer.append(CONTENTS_BASE_URL);
							buffer.append(ATTACH_TEMPLATE);
							base_template =  buffer.toString();
						}else{
							base_template = ATTACH_TEMPLATE;
						}
		
						eMsByteArrayOutputStream out = null;
						try {
							out = eMsByteArrayOutputStream.getInstance();
							out.reset();
							FileElement.putFileBodyToStream(base_template, out);
							this.REAL_ATTACH_TEMPLATE = out.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
						}finally {
							eMsByteArrayOutputStream.recycleInstance(out);
						}
		
						// 바닥 템플릿을 인코딩 하지 않기 때문에 "." 를 ".."로 전환해야한다.
						this.REAL_ATTACH_TEMPLATE = StringConvertUtil.GeneralizeMailContents(this.REAL_ATTACH_TEMPLATE);
		
						if (log.isDebugEnabled()) {
							log.debug("SECURE ATTACH CHOICE", "default attache template");
						}
					}
					//세팅된 보안 intro 세팅
					INTRO_TEMPLATE = this.REAL_ATTACH_TEMPLATE;
				}
				
	
				// 혹시 첨부 바닥 템플릿에 매핑이 있을지 모르므로 매핑을 진행한다.
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, INTRO_TEMPLATE, SCHEDULE_INFO, "${", "}", false, true);
				String tmpStr = buffer.toString();
	
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, tmpStr, info1, "${", "}", false, false);
	
				// 일단은 기본 템플릿은 기본으로 붙여 넣는다.
	
				//바운더리 넣고
				byteBuffer.write("\r\n--".getBytes());
				byteBuffer.write(boundary.getBytes());
				byteBuffer.write("\r\n".getBytes());
				byteBuffer.write("Content-Type: text/html;\r\n\tcharset=\"".getBytes());
				byteBuffer.write(eMsLocale.MAIL_MIME_CHAR_SET.getBytes());
				byteBuffer.write("\"\r\nContent-Transfer-Encoding: 8bit\r\n\r\n".getBytes());
				byteBuffer.write(buffer.toString().getBytes());
				byteBuffer.write("\r\n\r\n".getBytes());
	
				byteBuffer.write("\r\n--".getBytes());
				byteBuffer.write(boundary.getBytes());
				byteBuffer.write("\r\n".getBytes());
				byteBuffer.write("Content-Type: text/html;\r\n\tname=\"".getBytes());
				byteBuffer.write(SECURE_ATTACH_FILE_NAME.getBytes());
				byteBuffer.write("\"\r\nContent-Transfer-Encoding: base64\r\n".getBytes());
				byteBuffer.write("Content-Disposition: attachment;\r\n\tfilename=\"".getBytes());
				byteBuffer.write(SECURE_ATTACH_FILE_NAME.getBytes());
				byteBuffer.write("\"\r\n\r\n".getBytes());
	
				// 보안처리된 스트링 붙이기
				MimeConvertor.putMimeToStream(byteBuffer, body_string, eMsLocale.MAIL_BASE_CHAR_SET, eMsLocale.MAIL_MIME_CHAR_SET, eMsTypes.ENC_BASE64);
	
				byteBuffer.write("\r\n".getBytes());
				/*
				 * 일반 첨부 추가시작  by jini
				 */
				if(NON_SECURE_ATTACH_FLAG){
					Message tmpMessage = null;
					for (int i = 1; i < this.myMessages.size(); i++) {
						tmpMessage = (Message) this.myMessages.get(i);
						byteBuffer.write("\n--".getBytes());
						byteBuffer.write(boundary.getBytes());
						byteBuffer.write(NEW_LINE);
						// 헤더쓰기
						tmpMessage.putHeaderToStream(byteBuffer);
	
						byteBuffer.write(NEW_LINE);
	
						// 본문쓰기
						tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
	
						byteBuffer.write(NEW_LINE);
					}
				}
				/*
				 * 일반 첨부 여기까지..
				 */
	
				byteBuffer.write("\r\n--".getBytes());
				byteBuffer.write(boundary.getBytes());
				byteBuffer.write("--\r\n\r\n".getBytes());
//			}

			returnStr = byteBuffer.toString();
			
		} catch(Exception e) {
			
			throw new Exception(e);
		} finally {

			byteBuffer.close();
			byteBuffer = null;
		}
		
		return returnStr;
	}
	
	
	private void makeExceptMailBody(ByteArrayOutputStream byteBuffer, String body_string, Object info1, Object info2, Properties SCHEDULE_INFO) 
		throws Exception{
			switch (this.BODY_TYPE) {
			case eMsTypes.SIMPLE_BODY: {
				
				/* 메세지 헤더를 추가 */
				((Message) this.myMessages.get(0)).putHeaderToStream(byteBuffer);
				/* 헤더와 본문의 구분 개행 문자 추가 */
				byteBuffer.write(NEW_LINE);
				/* 본문 추가 */
				byteBuffer.write(body_string.getBytes());
				byteBuffer.write(NEW_LINE);			
	
				break;
			}
	
			case eMsTypes.MIME_BODY: {
				/* 바운더리 생성 */
				String boundary = getBoundaryString();
	
				/* 마임메세지 헤더를 추가 */
				byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
				byteBuffer.write("\tboundary=\"".getBytes());
				byteBuffer.write(boundary.getBytes(eMsLocale.MAIL_BASE_CHAR_SET));
	
				/* 헤더와 본문의 구분 개행 문자 추가 */
				byteBuffer.write("\"\r\n\r\n\r\n".getBytes());
	
				/* 기본 메세지 추가 */
				byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());
	
				Message tmpMessage = null;
				tmpMessage = (Message) this.myMessages.get(0);
				byteBuffer.write("\n--".getBytes());
				byteBuffer.write(boundary.getBytes());
				byteBuffer.write(NEW_LINE);
				// 헤더쓰기
				tmpMessage.putHeaderToStream(byteBuffer);
	
				byteBuffer.write(NEW_LINE);
	
				// 본문쓰기
				byteBuffer.write(body_string.getBytes());
	
				byteBuffer.write(NEW_LINE);
				
				for (int i = 1; i < this.myMessages.size(); i++) {
					tmpMessage = (Message) this.myMessages.get(i);
					byteBuffer.write("\n--".getBytes());
					byteBuffer.write(boundary.getBytes());
					byteBuffer.write(NEW_LINE);
					// 헤더쓰기
					tmpMessage.putHeaderToStream(byteBuffer);
	
					byteBuffer.write(NEW_LINE);
	
					// 본문쓰기
					tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
	
					byteBuffer.write(NEW_LINE);
				}
				byteBuffer.write("\r\n--".getBytes());
				byteBuffer.write(boundary.getBytes());
				byteBuffer.write("--\r\n\r\n".getBytes());
			}
		}		
	}
}
