package mercury.contents.common.body;

import java.util.Iterator;
import java.util.Properties;

import mercury.contents.auto.producer.BasicContentPD;
import mercury.contents.common.message.Message;
import mercury.contents.common.message.SimpleMessage;
import mercury.contents.common.parser.BinaryAttachBodyParser;
import mercury.contents.common.parser.BodyParser;
import mercury.contents.common.parser.LinkParser;
import mercury.contents.common.util.LinkContent;
import mercury.contents.common.util.TrackingInfoConvertor;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.io.eMsByteArrayOutputStream;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.lang.eMsStringBuffer;
import pluto.lang.eMsTypes;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import freemarker20.template.SimpleHash;

@Slf4j
public class OneByOneContentMailBody extends SimpleMailBody{
	
	
	protected static String			TR_URL					= null;

	static {

		TR_URL = eMsSystem.getProperty("tracking.url").concat("?${enc_mid}&${enc_s_type}&");

	}
	public OneByOneContentMailBody(){
		super();
	}
	
	// URLCall 및 개별첨부 기능을 추가한 메일바디...
	public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
		
		// ------------ START kckimMar0314 URLParam call 해서  파일 가져오기 ----------

		String ctnt_call_url = ((SimpleHash)info1).getAsString("CONTENTS");

		//urlcall방식일 경우 euc-kr로 지정
		String MIME_BASE_CHAR_SET = SCHEDULE_INFO.getProperty("MAIL_BASE_CHAR_SET",eMsLocale.URLCALL_BASE_CHAR_SET);
		
		String realContent = FileElement.getFileBody(ctnt_call_url, MIME_BASE_CHAR_SET, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
		/**
		 * 트래킹 유무에 따라 파싱 아니면 그냥 저장
		 */
		if( SCHEDULE_INFO.getProperty("TRACKING_YN", "N").equalsIgnoreCase("Y")
				&& SCHEDULE_INFO.getProperty("CONTENT_TYPE", "T").equalsIgnoreCase("H") ) {
			// 트래킹을 할경우에는 트래킹 파싱 로직을 호출한다.
			// 컨텐트를 저장하는 로직은 execute_ContentTrackingParsing 안에서 호출을 한다.
			// 링크를 파싱할때 임시로 사용하는 버퍼를 만들어서 보내는 로직으로 변경 2004.11.02
			eMsStringBuffer tmpBuffer = null;
			try {
				tmpBuffer = eMsStringBuffer.getInstance();
				realContent = addClickURL(realContent, tmpBuffer, SCHEDULE_INFO, (SimpleHash)info1);
			}
			finally {
				eMsStringBuffer.recycleInstance(tmpBuffer);
			}
		}
		((SimpleHash)info1).put("MAIL_CONTENT",realContent);

		Object[] attachMsg = makeAttachFiles((SimpleHash)info1, MIME_BASE_CHAR_SET);
		
		short BODY_TYPE =0;
		if(attachMsg != null && attachMsg.length != 0)
		{
			BODY_TYPE = eMsTypes.MIME_BODY;
		}else{
			BODY_TYPE = eMsTypes.SIMPLE_BODY;
		}
		
		//-------- END kckimMar0314 URLParam call 해서  파일 가져오기 -----------
		
		this.byteBuffer.reset();

		setHeaderString(info1, info2, SCHEDULE_INFO, this.byteBuffer);

		if (log.isDebugEnabled()) {
			log.debug("header", this.byteBuffer.toString());
		}

		//--- modify mail_contentType -------
		

		switch (BODY_TYPE) {
			case eMsTypes.SIMPLE_BODY: {
				
				/* 메세지 헤더를 추가 */
				((Message) this.myMessages.get(0)).putHeaderToStream(this.byteBuffer);

				/* 헤더와 본문의 구분 개행 문자 추가 */
				this.byteBuffer.write(NEW_LINE);

				// 메세지 헤더 추가된후 거시기 보기
				if (log.isDebugEnabled()) {
					log.debug("add message HEADER => " + this.byteBuffer.toString());
				}

				/* 본문 추가 */
				((Message) this.myMessages.get(0)).putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
				this.byteBuffer.write(NEW_LINE);

				// 메세지 헤더 추가된후 거시기 보기
				if (log.isDebugEnabled()) {
					log.debug("add message BODY => " + this.byteBuffer.toString());
				}
				break;
			}

			case eMsTypes.MIME_BODY: {
				/* 바운더리 생성 */
				
				String boundary = getBoundaryString();

				/* 마임메세지 헤더를 추가 */
				this.byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
				this.byteBuffer.write("\tboundary=\"".getBytes());
				this.byteBuffer.write(boundary.getBytes());

				/* 헤더와 본문의 구분 개행 문자 추가 */
				this.byteBuffer.write("\"\r\n\r\n".getBytes());

				/* 기본 메세지 추가 */
				this.byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());

				Message tmpMessage = null;
				for (int i = 0; i < this.myMessages.size(); i++) {
					tmpMessage = (Message) this.myMessages.get(i);
					this.byteBuffer.write("\n--".getBytes());
					this.byteBuffer.write(boundary.getBytes());
					this.byteBuffer.write(NEW_LINE);
					// 헤더쓰기
					tmpMessage.putHeaderToStream(this.byteBuffer);

					this.byteBuffer.write(NEW_LINE);

					// 본문쓰기
					
					tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);

					this.byteBuffer.write(NEW_LINE);
					
				}

				// 개별 첨부 메시지..
				if(attachMsg != null){
					for(int i=0; i< attachMsg.length;i++){
						tmpMessage = (Message)attachMsg[i];
						
						if(tmpMessage == null){
							continue;
						}
						
						this.byteBuffer.write("\n--".getBytes());
						this.byteBuffer.write(boundary.getBytes());
						this.byteBuffer.write(NEW_LINE);
						//헤더쓰기
						tmpMessage.putHeaderToStream(this.byteBuffer);
						this.byteBuffer.write(NEW_LINE);
						//본문쓰기
						tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
						this.byteBuffer.write(NEW_LINE);
					}
				}

				this.byteBuffer.write("\r\n--".getBytes());
				this.byteBuffer.write(boundary.getBytes());
				this.byteBuffer.write("--\r\n\r\n".getBytes());

			}
		}
		
		//-------------------------- end -----------------------------
		
		return this.byteBuffer.toString(eMsLocale.MAIL_BASE_CHAR_SET);
	}

	public Object[] makeAttachFiles(SimpleHash userInfo, String charSet)throws Exception{

		String[] attachPath = getAttachFilePathFromMapping(userInfo);
		
		// 첨부파일이 없으면 바로 리턴해 버린다.
		if(attachPath == null){
			return null;
		}
		
		Object[] attachMsg = new Object[attachPath.length];
		
		BodyParser bodyParser=null;
		Message msg = null;

		for(int i=0; i<attachPath.length; i++){
			if(attachPath[i].equals("")){
				continue;
			}
			bodyParser = new BinaryAttachBodyParser();
			try{
				bodyParser.setContents(attachPath[i]);
			}catch(Exception e){
				log.debug("[해당 경로에 첨부파일이  파일이 존재하지 않습니다.]");
				log.debug("Path = ["+attachPath[i]+"]");
				attachMsg[i] = null;
				continue;
			}
			msg = new SimpleMessage();
			msg.setContent(bodyParser);
			msg.setContentType(new Short(eMsTypes.ATTACH_BINARY_MESSAGE));
			msg.setCharSet(charSet);
			
			msg.setContentEncoding(new Short(eMsTypes.ENC_BASE64));
			msg.setMessageID(Thread.currentThread().getName());
			
			msg.setContentName(attachPath[i].substring(attachPath[i].lastIndexOf('/')+1));
			attachMsg[i] = (Object) msg;

		}

		return attachMsg;
	}
	
	public String[] getAttachFilePathFromMapping(SimpleHash userInfo){
		String letter1 = userInfo.getAsString("ATTACH01");
		String letter2 = userInfo.getAsString("ATTACH02");
		String letter3 = userInfo.getAsString("ATTACH03");
		String letter4 = userInfo.getAsString("ATTACH04");
		String letter5 = userInfo.getAsString("ATTACH05");
		
		String[] letterList = new String[5];
		
		if(letter1 == null && letter2 == null && letter3 == null && letter4 == null && letter5 == null )
		{
			letterList = null;	
		}
		else if(letter1 != null && letter2 != null && letter3 != null && letter4 != null && letter5 != null
				&& letter1.equals("") && letter2.equals("") && letter3.equals("") && letter4.equals("") && letter5.equals("")) 
		{	
				letterList = null;
		}else{
			letterList[0] = letter1==null?"":letter1.replace('\\', '/');
			letterList[1] = letter2==null?"":letter2.replace('\\', '/');
			letterList[2] = letter3==null?"":letter3.replace('\\', '/');
			letterList[3] = letter4==null?"":letter4.replace('\\', '/');
			letterList[4] = letter5==null?"":letter5.replace('\\', '/');
		}
		
		return letterList;
	}

	protected String addClickURL(String source, eMsStringBuffer tmpBuffer, Properties SCHEDULE_INFO, SimpleHash shash) throws Exception {

		String __FINAL_OUTPUT__ = source;
		String INSTANCE_TR_URL = null;
		StringBuffer TMP_BUFFER = new StringBuffer();
		
		String tmpTR_URL = StringConvertUtil.ConvertString(TR_URL, shash, "${", "}", false, false);		

		TMP_BUFFER.setLength(0);
		TMP_BUFFER.append(tmpTR_URL);
		TMP_BUFFER.append(TrackingInfoConvertor.enc_LIST_TABLE(SCHEDULE_INFO.getProperty("LIST_TABLE")));
		TMP_BUFFER.append("&");
		TMP_BUFFER.append(TrackingInfoConvertor.enc_MAIL_ID(SCHEDULE_INFO.getProperty("POST_ID")));
		TMP_BUFFER.append("&");
		TMP_BUFFER.append(TrackingInfoConvertor.enc_CLOSE(SCHEDULE_INFO.getProperty("QUE_CLOSE_DATE", Cal.getAddDayDate(7))));

		INSTANCE_TR_URL = TMP_BUFFER.toString();
		
		/**
		 * 클릭을 잡는다고 마킹이 되어 있다면.
		 */
		if( SCHEDULE_INFO.getProperty("CLICK_YN", "N").equalsIgnoreCase("Y") ) {
			LinkParser __LINK_PARSER__ = new LinkParser();
			__LINK_PARSER__.parse(__FINAL_OUTPUT__);

			LinkContent __LINK_CONTENT__ = null;
			Object __LINK_ELEMENT__ = null;

			TMP_BUFFER.setLength(0);

			for (Iterator __ITERATOR__ = __LINK_PARSER__.iterator(); __ITERATOR__.hasNext();) {
				__LINK_ELEMENT__ = __ITERATOR__.next();

				/**
				 * 트래킹을 잡을 것은 변환하여 append하고 일반 content나 트래킹하지 않을 것은 append하고
				 * remove한다. 그래야 db로 업데이트가 되지 않는다.
				 */
				if( __LINK_ELEMENT__ instanceof LinkContent ) {
					__LINK_CONTENT__ = (LinkContent) __LINK_ELEMENT__;

					if( __LINK_CONTENT__.getUrl().startsWith("http") ) {
						tmpBuffer.setLength(0);
						tmpBuffer.append(INSTANCE_TR_URL);
						tmpBuffer.append("&");
						tmpBuffer.append(TrackingInfoConvertor.enc_KIND("C"));
						tmpBuffer.append("&");
						tmpBuffer.append(TrackingInfoConvertor.enc_CID(__LINK_CONTENT__.getID()));
						tmpBuffer.append("&URL=");
						tmpBuffer.append(__LINK_CONTENT__.getUrl());
						TMP_BUFFER.append(__LINK_CONTENT__.getLinkConvert(tmpBuffer.toString()));
					}
					else {
						TMP_BUFFER.append(__LINK_ELEMENT__.toString());
						__ITERATOR__.remove();
					}
				}
				else {
					TMP_BUFFER.append(__LINK_ELEMENT__.toString());
					__ITERATOR__.remove();
				}
			}

			__FINAL_OUTPUT__ = TMP_BUFFER.toString();

			/**
			 * 파싱한 정보는 삭제한다.
			 */
			__LINK_PARSER__.clear();
		}

		return TMP_BUFFER.toString();
	}

}
