package mercury.contents.common.body;

import java.util.Properties;

import freemarker20.template.SimpleHash;
import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.message.Message;
import mercury.contents.common.message.SimpleMessage;
import mercury.contents.common.parser.BinaryAttachBodyParser;
import mercury.contents.common.parser.BodyParser;
import pluto.lang.eMsTypes;

@Slf4j
public class OneByOneAttachMailBody extends SimpleMailBody{
	

	public OneByOneAttachMailBody(){
		super();
	}
	
	// 개별 첨부 기능을  추가한 메일바디... 
	public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {

		String MIME_BASE_CHAR_SET = SCHEDULE_INFO.getProperty("MAIL_BASE_CHAR_SET","euc-kr");

		Object[] attachMsg = makeAttachFiles((SimpleHash)info1, MIME_BASE_CHAR_SET);
		
		short BODY_TYPE =0;
		if(attachMsg != null && attachMsg.length != 0)
		{
			BODY_TYPE = eMsTypes.MIME_BODY;
		}else{
			BODY_TYPE = eMsTypes.SIMPLE_BODY;
		}
		
		this.byteBuffer.reset();

		setHeaderString(info1, info2, SCHEDULE_INFO, this.byteBuffer);

		if (log.isDebugEnabled()) {
			log.debug("header", this.byteBuffer.toString());
		}

		// 여기서 첨부일 경우와 첨부가 아닐 경우를 구분해야 한다....
        //--- modify mail_contentType -------

		switch (BODY_TYPE) {
			case eMsTypes.SIMPLE_BODY: {
				
				/* 메세지 헤더를 추가 */
				((Message) this.myMessages.get(0)).putHeaderToStream(this.byteBuffer);

				/* 헤더와 본문의 구분 개행 문자 추가 */
				this.byteBuffer.write(NEW_LINE);

				// 메세지 헤더 추가된후 거시기 보기
				if (log.isDebugEnabled()) {
					log.debug(Thread.currentThread().getName() + "'s add message HEADER => " + this.byteBuffer.toString());
				}

				/* 본문 추가 */
				((Message) this.myMessages.get(0)).putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
				this.byteBuffer.write(NEW_LINE);

				// 메세지 헤더 추가된후 거시기 보기
				if (log.isDebugEnabled()) {
					log.debug(Thread.currentThread().getName() + "'s add message BODY => " + this.byteBuffer.toString());
				}
				break;
			}

			case eMsTypes.MIME_BODY: {
				/* 바운더리 생성 */
				String boundary = getBoundaryString();

				/* 마임메세지 헤더를 추가 */
				this.byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
				this.byteBuffer.write("\tboundary=\"".getBytes());
				this.byteBuffer.write(boundary.getBytes());

				/* 헤더와 본문의 구분 개행 문자 추가 */
				this.byteBuffer.write("\"\r\n\r\n".getBytes());

				/* 기본 메세지 추가 */
				this.byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());

				Message tmpMessage = null;
				for (int i = 0; i < this.myMessages.size(); i++) {
					tmpMessage = (Message) this.myMessages.get(i);
					this.byteBuffer.write("\n--".getBytes());
					this.byteBuffer.write(boundary.getBytes());
					this.byteBuffer.write(NEW_LINE);
					// 헤더쓰기
					tmpMessage.putHeaderToStream(this.byteBuffer);

					this.byteBuffer.write(NEW_LINE);

					// 본문쓰기
					
					tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);

					this.byteBuffer.write(NEW_LINE);
					
				}

				// 개별 첨부 메시지..
				if(attachMsg != null){
					for(int i=0; i< attachMsg.length;i++){
						tmpMessage = (Message)attachMsg[i];
						
						if(tmpMessage == null){
							continue;
						}
						
						this.byteBuffer.write("\n--".getBytes());
						this.byteBuffer.write(boundary.getBytes());
						this.byteBuffer.write(NEW_LINE);
						//헤더쓰기
						tmpMessage.putHeaderToStream(this.byteBuffer);
						this.byteBuffer.write(NEW_LINE);
						//본문쓰기
						tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
						this.byteBuffer.write(NEW_LINE);
					}
				}

				this.byteBuffer.write("\r\n--".getBytes());
				this.byteBuffer.write(boundary.getBytes());
				this.byteBuffer.write("--\r\n\r\n".getBytes());

			}
		}

		return this.byteBuffer.toString();
	}

	public Object[] makeAttachFiles(SimpleHash userInfo, String charSet)throws Exception{

		String[] attachPath = getAttachFilePathFromMapping(userInfo);
		
		// 첨부파일이 없으면 바로 리턴해 버린다.
		if(attachPath == null){
			return null;
		}
		
		Object[] attachMsg = new Object[attachPath.length];
		
		BodyParser bodyParser=null;
		Message msg = null;

		for(int i=0; i<attachPath.length; i++){
			if(attachPath[i].equals("")){
				continue;
			}
			bodyParser = new BinaryAttachBodyParser();
			try{
				bodyParser.setContents(attachPath[i]);
			}catch(Exception e){
				log.debug("[해당 경로에 첨부파일이  파일이 존재하지 않습니다.]");
				log.debug("Path = ["+attachPath[i]+"]");
				attachMsg[i] = null;
				continue;
			}
			msg = new SimpleMessage();
			msg.setContent(bodyParser);
			msg.setContentType(new Short(eMsTypes.ATTACH_BINARY_MESSAGE));
			msg.setCharSet(charSet);
			
			msg.setContentEncoding(new Short(eMsTypes.ENC_BASE64));
			msg.setMessageID(Thread.currentThread().getName());
			
			msg.setContentName(attachPath[i].substring(attachPath[i].lastIndexOf('/')+1));
			
			attachMsg[i] = (Object) msg;

		}

		return attachMsg;
	}
	
	public String[] getAttachFilePathFromMapping(SimpleHash userInfo){
		String letter1 = userInfo.getAsString("ATTACH01");
		String letter2 = userInfo.getAsString("ATTACH02");
		String letter3 = userInfo.getAsString("ATTACH03");
		String letter4 = userInfo.getAsString("ATTACH04");
		String letter5 = userInfo.getAsString("ATTACH05");
		
		String[] letterList = new String[5];
		
		if(letter1 == null && letter2 == null && letter3 == null && letter4 == null && letter5 == null )
		{
			letterList = null;	
		}
		else if(letter1 != null && letter2 != null && letter3 != null && letter4 != null && letter5 != null
				&& letter1.equals("") && letter2.equals("") && letter3.equals("") && letter4.equals("") && letter5.equals("")) 
		{	
				letterList = null;
		}
		else{
			letterList[0] = letter1==null?"":letter1.replace('\\', '/');
			letterList[1] = letter2==null?"":letter2.replace('\\', '/');
			letterList[2] = letter3==null?"":letter3.replace('\\', '/');
			letterList[3] = letter4==null?"":letter4.replace('\\', '/');
			letterList[4] = letter5==null?"":letter5.replace('\\', '/');
		}
		
		return letterList;
	}
}
