/*
 * @(#)MailBody.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.common.body;

import java.util.Properties;
import java.util.Vector;

import mercury.contents.common.message.Message;

/**
 * 메일 본문을 작성한다.
 * 
 * @version		
 * @author 		dragon
 *
 */
public interface MailBody {
	
	
	/** 메일의 기본 헤더를 제외한 추가헤더를 지정한다.
	 * @param prop 헤더의 key/value Property
	 */
	public void setEtcHeader( Properties prop ) throws Exception;
	
	/** 추가 헤더를 반환한다.
	 * @return 추가 헤더
	 */
	public Properties getEtcHeader();
	
	/** 제목을 지정한다.
	 * @param Subject 제목
	 */
	public void setSubject( String Subject );
	
	/** 제목을 반환한다.
	 * @return 메일 제목
	 */
	public String getSubject();
	
	/** 보낸사람 이름을 지정한다.
	 * @param from_name 보내는 사람 이름
	 */
	public void setFromName( String from_name );
	
	/** 보내는 사람 이름을 반환한다.
	 * @return 보내는 사람 이름
	 */
	public String getFromName();
	
	/** 보내는사람 이메일을 지정한다.
	 * @param from_email 보내는 사람 이메일
	 */
	public void setFromEmail( String from_email );
	
	/** 보내는 사람 이메일을 지정한다.
	 * @return 보내는 사람 이메일
	 */
	public String getFromEmail();
	
	/** 받는 사람이름을 지정한다.
	 * @param to_name 받는 사람이름
	 */
	public void setToName( String to_name );
	
	/** 받는 사람이름을 반환한다.
	 * @return 받는 사람이름
	 */
	public String getToName();
	
	/** 받는사람 이메일을 지정한다.
	 * @param to_email 받는사람 이메일
	 */
	public void setToEmail( String to_email );
	
	/** 받는사람 이메일을 반환한다.
	 * @return 받는사람 이메일
	 */
	public String getToEmail();
	
	/** 메일 구성 메세지를 지정한다.
	 * @param msg 메일 구성 메세지
	 */
	public void setMessage( Message msg );
	
	/** 메일 구성 메세지를 반환한다.
	 * @return 메일 구성 메세지
	 */
	public Vector getMessage();
	
	/** 개인매핑데이터와 기본매핑데이터 둘다 사용하는 메일을 생성한다.
	 * @param info1 개인매핑데이터
	 * @param info2 기본매핑데이터
	 * @throws Exception 생성에러
	 * @return 최종생성된 메일
	 */
	public String getMailBody( Object info1 , Object info2 , Properties prop ) throws Exception;
	
	/** 개인매핑데이터와 기본매핑데이터 둘다 사용하는 PreView용 메일본문을 생성한다.
	 * @param info1 개인매핑데이터
	 * @param info2 기본매핑데이터
	 * @throws Exception 생성에러
	 * @return 최종생성된 메일
	 */
	public String getPreViewMailBody( Object info1 , Object info2 , Properties prop ) throws Exception;
	
	public String getSpoolPrev( Object info1 , Object info2 , Properties prop ) throws Exception;
	
	
}
