package mercury.contents.common.body;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

import freemarker20.template.SimpleHash;
//import mercury.contents.common.util.FtpClient;
import lombok.extern.slf4j.Slf4j;

//import org.apache.commons.net.ftp.FTPClient;

import mercury.contents.common.message.Message;
import mercury.contents.common.message.SimpleMessage;
import mercury.contents.common.parser.BinaryAttachBodyParser;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.util.StringUtil;

@Slf4j
public class AttachableMailBody extends SimpleMailBody {

	public static String ATTACH_HEAD = "ATTACH"; // default

	public static int ATTACH_CNT = 5; // default

	protected static boolean ATTACH_USE = true; // default
	
	protected static HashMap ATTACH_MAP = new HashMap();
	
	public static boolean ATTACH_KEEP_YN = false; // default
	
	public static int ATTACH_KEEP_CNT = 10; // default
	
	public static String FINAL_ACT_TIME = "";
	
	protected static Properties PROP_FTP_INFO = null;
	
	public static String FTP_LOCAL_PATH = null;
	
	public static boolean FTP_USE_YN = false;
	

	public AttachableMailBody() {
		super();
	}

	public static void init(Object tmp) throws Exception {

		Properties prop = (Properties) tmp;
		
		ATTACH_HEAD     = prop.getProperty("attach.head", "ATTACH");
		ATTACH_CNT      = Integer.parseInt(prop.getProperty("attach.cnt", "5"));
		ATTACH_USE      = prop.getProperty("use.yn", "N").equals("Y");
		
		ATTACH_KEEP_YN  = prop.getProperty("attach.keep.yn", "N").equals("Y");
		ATTACH_KEEP_CNT = Integer.parseInt(prop.getProperty("attach.keep.cnt", "10"));
		
		FTP_USE_YN      = prop.getProperty("ftp.yn", "N").equals("Y");
		
		FTP_LOCAL_PATH = prop.getProperty("ftp.local.path", "");
		
		PROP_FTP_INFO = new Properties();
		PROP_FTP_INFO.setProperty("ftp.server",     prop.getProperty("ftp.server", "100.254.55.85"));
		PROP_FTP_INFO.setProperty("ftp.username",   prop.getProperty("ftp.username", "ems_user"));
		PROP_FTP_INFO.setProperty("ftp.password",   prop.getProperty("ftp.password", "apdlf$00"));
		PROP_FTP_INFO.setProperty("ftp.port",       prop.getProperty("ftp.port", "21"));
		PROP_FTP_INFO.setProperty("ftp.path",       prop.getProperty("ftp.path", "/EMAIL_ATTACH"));
		PROP_FTP_INFO.setProperty("ftp.local.path", FTP_LOCAL_PATH);
		
		if (log.isDebugEnabled()) {
			log.debug("ATTACH MAIL INIT...");
		}
	}

	/**
	 * 개인매핑데이터와 기본매핑데이터 둘다 사용하는 메일을 생성한다.
	 * 
	 * @param info1
	 *            개인매핑데이터
	 * @param info2
	 *            기본매핑데이터
	 * @throws Exception
	 *             생성에러
	 * @return 최종생성된 메일
	 */
	public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
		// conf file setting : use.yn
		if (!ATTACH_USE) {
			return super.getMailBody(info1, info2, SCHEDULE_INFO);
		}
		
		//memory check
		if (log.isDebugEnabled()) {
			log.debug("[FIRST]"+memCheck());
		}

		ByteArrayOutputStream byteBuffer = null;
		String returnStr = "";
		
		if(info1 == null){
			log.debug("[info1 is null]");
			return null;
		}
		
		
		Iterator itr = ( ( SimpleHash)info1).getKeyIterator();
		
		//test
		while(itr.hasNext()){
			log.debug("[info1_itr]"+(String)itr.next());
		}
		
		String attach_list = ( ( SimpleHash)info1).getAsString("ATTACH_LIST");
		
		//String attach_list = (String)((SimpleHash) info1).getAsStringWithError("ATTACH_LIST");
		
		
		//첫번째 null일 경우
		/*if(StringUtil.isNull(attach_list)){
			log.debug("attach_list is null==> retry");
			Thread.sleep(100);
			
			attach_list = ( ( SimpleHash)info1).getAsString("ATTACH_LIST");
			//attach_list = (String)((SimpleHash) info1).getAsStringWithError("ATTACH_LIST");
			//두번째도 null일까?
			if(StringUtil.isNull(attach_list)){
				log.debug("[re]attach_list is null");
				return super.getMailBody(info1, info2, SCHEDULE_INFO);
			}
		}*/
		
		log.debug("[attach_list] ==>"+attach_list);
		Object[] attachMsg = makeAttachFiles( (SimpleHash) info1, "UTF-8");
		
		if (attachMsg == null) {// 첨부된 파일이 없을경우
			log.debug("[AttachableMailBody] attach_file is null");
			return super.getMailBody(info1, info2, SCHEDULE_INFO);
		} else {
			log.debug("================ [AttachableMailBody] act getMailBody ================");
		}

		// attach start
		try {
			byteBuffer = new ByteArrayOutputStream(512);

			// header setting
			setHeaderString(info1, info2, SCHEDULE_INFO, byteBuffer);

			if (log.isDebugEnabled()) log.debug("[ATTACH] ==> exist attachMsg [TYPE] MIME_BODY");
			/* 바운더리 생성 */
			String boundary = getBoundaryString();

			/* 마임메세지 헤더를 추가 */
			byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
			byteBuffer.write("\tboundary=\"".getBytes());
			byteBuffer.write(boundary.getBytes());

			/* 헤더와 본문의 구분 개행 문자 추가 */
			byteBuffer.write("\"\r\n\r\n".getBytes());

			/* 기본 메세지 추가 */
			byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());

			// 메시지에 등록된 일괄첨부 실행
			Message tmpMessage = null;
			for (int i = 0; i < this.myMessages.size(); i++) {
				tmpMessage = (Message) this.myMessages.get(i);
				byteBuffer.write("\n--".getBytes());
				byteBuffer.write(boundary.getBytes());
				byteBuffer.write(NEW_LINE);
				// 헤더쓰기
				tmpMessage.putHeaderToStream(byteBuffer);

				byteBuffer.write(NEW_LINE);

				// 본문쓰기
				tmpMessage.putStringMessageToStream(info1, info2,SCHEDULE_INFO, byteBuffer);

				byteBuffer.write(NEW_LINE);
			}

			// 개별 첨부 메시지...
			for (int i = 0; i < attachMsg.length; i++) {
				if (log.isDebugEnabled()) {
					log.debug("[ATTACH COUNT] : " + (i));
				}

				tmpMessage = (Message) attachMsg[i];

				if (tmpMessage == null) {
					if (log.isDebugEnabled()) {
						log.debug("Message is null ");
					}
					continue;
				}

				byteBuffer.write("\n--".getBytes());
				byteBuffer.write(boundary.getBytes());
				byteBuffer.write(NEW_LINE);
				// 헤더쓰기
				tmpMessage.putHeaderToStream(byteBuffer);
				byteBuffer.write(NEW_LINE);
				// 본문쓰기
				tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
				byteBuffer.write(NEW_LINE);

//				if (log.isDebugEnabled()) {
//					log.debug("[MASSAGE]:" + byteBuffer.toString());
//				}
			}// end for
			
			//사용한 첨부의 메모리를 빨리 버리기를 바라며----------
			attachMsg = null;
			//-------------------------------------------

			byteBuffer.write("\r\n--".getBytes());
			byteBuffer.write(boundary.getBytes());
			byteBuffer.write("--\r\n\r\n".getBytes());

			// result mail body
			returnStr = byteBuffer.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);

		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			byteBuffer.close();
			byteBuffer = null;
		}
		
		//memory check
		if (log.isDebugEnabled()) {
			log.debug("[LAST]"+memCheck());
		}

		return returnStr;
	}
	
	/**
	 * 
	 * @return
	 */
	public static String memCheck() {

	    double[] n1 = new double[1000000];
	    double[] n2 = new double[1000000];

	    long free  = Runtime.getRuntime().freeMemory();
	    long total = Runtime.getRuntime().totalMemory();
	    long max   = Runtime.getRuntime().maxMemory();

	    String out_str = "[Total Memory]:" + Runtime.getRuntime().totalMemory()
	                   + "[Free Memory]:" + Runtime.getRuntime().freeMemory()
	                   + "[Used Memory]:" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) ;
	    
	    log.debug(out_str);
	    
	    return out_str;
	  }

	/**
	 * 첨부 bean에서 해당 URL의 소스를 가져와 첨부파일 형태로 message 를 생성한다.
	 * 
	 * @param userInfo
	 * @param charSet
	 * @return
	 * @throws Exception
	 */
	public static Object[] makeAttachFiles(SimpleHash info1, String charSet) throws Exception {
		if (log.isDebugEnabled()) {
			log.debug("[GET ATTACH FILES]");
		}
		ArrayList attachPath = getAttachFilePathFromMapping(info1);

		// 첨부파일이 없으면 바로 리턴해 버린다.
		if (attachPath == null) {
			log.debug("[attachPath.SIZE] ==> 0");
			return null;
		}

		Object[] attachMsg = new Object[attachPath.size()];

		BinaryAttachBodyParser binarybodyParser = null;
		Message msg = null;
		AttachBean abean = null;

		log.debug("[GET ATTACH START] >>>>>>>> ");
		
		//FTP file transfer
		//attachPath 의 path가 local경로로 변경되어 진다.
		//FtpClient.ftpDownloads(AttachableMailBody.PROP_FTP_INFO, attachPath );
		
		for (int i = 0; i < attachPath.size(); i++) {
			abean = (AttachBean) attachPath.get(i);
			if (abean.getFile_path().equals("")) {
				continue;
			}
			
			try {
				//content setting -----------------------------------------------------
				binarybodyParser = new BinaryAttachBodyParser();
				binarybodyParser.setContentsAttach(abean.getFile_path());
				//binarybodyParser.setContentSslife(abean.getFile_path());
				
				//---------------------------------------------------------------------

			} catch (Exception e) {
				log.debug("[not found attach file] Path = [" + abean.getFile_path() + "]");
				attachMsg[i] = null;

				//continue; //첨부가 실패하더라도 발송은 해야한다.

				throw e;// 첨부파일이 하나라도 실패하면 메일은 발송 실패로 처리한다. 
			}
			
			msg = new SimpleMessage();
			msg.setContent(binarybodyParser);
			msg.setContentType(new Short(eMsTypes.ATTACH_BINARY_MESSAGE));
			msg.setCharSet(charSet);

			msg.setContentEncoding(new Short(eMsTypes.ENC_BASE64));
			msg.setMessageID(Thread.currentThread().getName());

			msg.setContentName(abean.getFile_name());

			attachMsg[i] = (Object) msg;

			if (log.isDebugEnabled())
				log.debug("[ATTACH FILE]" + abean.getFile_path());
			
			if((new File(abean.getFile_path())).exists() ){
				log.debug("[DELETE FILE]SUCCESS" + abean.getFile_path());
			}else{
				log.debug("[DELETE FILE]FAIL" + abean.getFile_path());
			}
			
		}//end of for
		
		
		log.debug(">>>>>>>>> [GET ATTACH END]");

		return attachMsg;
	}
	
	
	
	public static boolean isFile(String url){
		String fileName = url.substring(url.lastIndexOf("/") + 1);
		
		if(StringUtil.isNull(fileName)){
			return false;
		}else{
			int dot_index = fileName.lastIndexOf(".");
			
			if(dot_index < 0 || dot_index!=fileName.length()-4){
				return false;
			}
		}		
		return true;		
	}

	/**
	 * 첨부파일 Bean을 생성해서 리스트에 저장한 후 return 한다.
	 * 
	 * 삼성생명 전용으로 수정함
	 * @param userInfo
	 * @return
	 */
	public static ArrayList getAttachFilePathFromMapping_SSLIFE(String attach_list) {

		ArrayList attachList = null;

		String attach_path = "";
		String attach_file = "";
		String attach_title = "";
		String alias = "";

		boolean is_check = true;

		//FTP_LOCAL_PATH
		Properties prop_attach = StringUtil.getProp_sslife(attach_list, AttachableMailBody.ATTACH_HEAD);
		
		StringBuffer buffer    = new StringBuffer();

		for (int i = 0; i < AttachableMailBody.ATTACH_CNT; i++) {
			buffer.setLength(0);
			buffer.append(AttachableMailBody.ATTACH_HEAD).append("_").append(i);
			alias = buffer.toString();
			
			attach_file = prop_attach.getProperty(alias);

			if (log.isDebugEnabled()) {
				log.debug("[alias]"+alias+"[attach_file]"+attach_file);
			}
			
			if (!StringUtil.isNull(attach_file)) {
				if (is_check) {
					attachList = new ArrayList();
					is_check = false;
				}
				
				attach_title = attach_file;
//				
//				buffer.setLength(0);
//				buffer.append(FTP_LOCAL_PATH).append("/").append(attach_file);
//				attach_path = buffer.toString();

				if (log.isDebugEnabled()) {
					log.debug("[attach_title]"+attach_title);
				}

				AttachBean abean = new AttachBean(attach_title, attach_title);
				attachList.add(abean);
			}
		}
		return attachList;
	}
	
// ORI_SOURCE
	public static ArrayList getAttachFilePathFromMapping(SimpleHash userInfo) {

		ArrayList attachList = null;

		String attach_path = "";
		String attach_title = "";
		String alias = "";

		boolean is_check = true;

		for (int i = 0; i < AttachableMailBody.ATTACH_CNT; i++) {
			alias = AttachableMailBody.ATTACH_HEAD + (i + 1);
			attach_path = userInfo.getAsString(alias);

			if (!StringUtil.isNull(attach_path)) {
				if (is_check) {
					attachList = new ArrayList();
					is_check = false;
				}
				attach_title = userInfo.getAsString(alias + "_NAME");

				// ATTACH1_NAME 없다면 파일이름이 attach_name 이 된다.
				if (StringUtil.isNull(attach_title)) {
					attach_title = attach_path.substring(attach_path.lastIndexOf("/") + 1);
				}
				// if (log.isDebugEnabled()) {
				// log.debug("[attach_path]"+attach_path+"
				// [attach_title]"+attach_title);}

				AttachBean abean = new AttachBean(attach_path, attach_title);
				attachList.add(abean);
			}
		}

		return attachList;
	}

}