/*
 * @(#)ContentInfoManager.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.basic;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

import mercury.contents.auto.producer.BasicContentPD;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.schedule.ScheduledMonitor;
import pluto.util.StringUtil;

/**
 * ContentInfo를 저장하고 관리한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class ContentInfoManager extends ScheduledMonitor {

	/* 10분 마다 한번씩 컨텐트의 유효기간 검사를 하게 된다. */
	public static final long			CHECK_INTERVAL			= 60 * 1000L;

	private static String				INFO_SAVE_BASE_DIR		= null;

	private static String				INFO_SAVE_BASE_URL		= null;

	private static String				INFO_SAVE_FILE_EXT		= null;

	private static String				INFO_DTD_LOCATION		= null;

	private static String				INFO_XML_CHARSET		= null;

	private static String				INFO_XML_OUT_CHARSET	= null;

	// public static Object				lock					= new Object();
	
	public static final Object			lock					= new Object();

	//	private static Thread inner_monitor = null;
	//	private static boolean inner_monitor_alive = false;

	private static Hashtable			CONTENTE_INFO_HASH		= new Hashtable();

	public static String				name					= "ContentInfoManager";

	private static ContentInfoManager	INNER_MANAGER			= null;

	static {
		INNER_MANAGER = new ContentInfoManager();
		INNER_MANAGER.start();
	}

	/**
	 * 초기화한다. <br>
	 * 
	 * <PRE>
	 * 
	 * &lt;TARGET name="DEFAULT MAPPER SAVE CONTROLL"&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;class
	 * name="Lib2002.contents.ContentInfoManager"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="base.dir"
	 * value="${base}/default_mappings"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var
	 * name="file.ext" value=".sendinfo"/&gt; &lt;/TARGET&gt;
	 * 
	 * </PRE>
	 * 
	 * <PRE>
	 * 
	 * base.dir : 컨텐트 정보를 저장할 기본 디렉토리를 지정한다. <br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;하부 디렉토리 구조는 ContentInfo의 ID중 앞6자리로 한다. <br>
	 * file.ext : Content정보파일의 확장자를 정한다.
	 * 
	 * </PRE>
	 * 
	 * @param prop
	 *            초기화 파라미터
	 * @throws Exception
	 *             초기화 에러
	 */
	public synchronized static void init(Object prop) throws Exception {

		Properties tmp = (Properties) prop;

		INFO_SAVE_BASE_DIR = tmp.getProperty("base.dir");
		INFO_SAVE_BASE_URL = tmp.getProperty("base.url");
		INFO_SAVE_FILE_EXT = tmp.getProperty("file.ext", ".xml");
		INFO_DTD_LOCATION = tmp.getProperty("dtd.location");
		INFO_XML_CHARSET = tmp.getProperty("info.xml.charset", "euc-kr");
		INFO_XML_OUT_CHARSET = tmp.getProperty("info.out.charset", "KSC5601");

		if( INFO_SAVE_BASE_URL != null && !INFO_SAVE_BASE_URL.trim().equals("") ) {
			// DTD 파일을 INFO_SAVE_BASE_DIR에 복사하고 이쪽을 DTD Location으로 잡는다.
			String xmlDtd = FileElement.getFileBody(INFO_DTD_LOCATION);
			int i = INFO_DTD_LOCATION.lastIndexOf("/");
			int j = INFO_DTD_LOCATION.lastIndexOf("\\");
			String xmlDtdFileOnlyName = INFO_DTD_LOCATION.substring(Math.max(i, j) + 1);
			FileElement.toFile(INFO_SAVE_BASE_DIR + File.separator + xmlDtdFileOnlyName, xmlDtd);
			ContentInfo.setDTDLocation(INFO_SAVE_BASE_URL + "/" + xmlDtdFileOnlyName);
		}
		else {
			ContentInfo.setDTDLocation(INFO_DTD_LOCATION);
		}

		ContentInfo.setEncoding(INFO_XML_CHARSET);
		ContentInfo.setFileEncoding(INFO_XML_OUT_CHARSET);

		if( INFO_SAVE_BASE_DIR == null ) {
			throw new RuntimeException("ContentBaseDirectory  parameter is not set!!!");
		}
	}

	public synchronized static void unload() throws Exception {
		INNER_MANAGER.close();
	}

	/**
	 * 모니터링 쓰레드를종료하고 자원을 반환한다.
	 */
	public synchronized static void destroy() throws Exception {
		CONTENTE_INFO_HASH.clear();
		// inner_monitor_alive=false;
	}

	/**
	 * Creates new ContentInfoManager <br>
	 * 내부적으로 등록된 ContentInfo를 모니터링하는 내부 Thread를 생성한다.
	 */
	private ContentInfoManager() {
		super(CHECK_INTERVAL);
	}

	protected void check() throws Exception {
		Enumeration ENUM = CONTENTE_INFO_HASH.elements();

		ContentInfo tmpInfo = null;
		if (log.isDebugEnabled()) 
			log.debug("ContentInfoManager Scan start...");
		while (ENUM.hasMoreElements()) {
			tmpInfo = (ContentInfo) ENUM.nextElement();

			if( tmpInfo.expire() ) {
				synchronized (lock) {
					log.info(tmpInfo.getID() + " is removed from ContentManager");
					CONTENTE_INFO_HASH.remove(tmpInfo.getID());
				}
			}
		}
		if (log.isDebugEnabled()) 
			log.debug("ContentInfoManager Scan end...");
	}

	/**
	 * 외부에서 호출되며 ContentInfo를 등록한다.
	 * 
	 * @param content
	 *            등록할 ContentInfo
	 * @throws Exception
	 *             등록에러
	 */
	public synchronized static void registContentInfo(ContentInfo content) throws Exception {

		// 년도 디렉토리 생성
		String store_file_name = FileElement.CheckSubDirectory(INFO_SAVE_BASE_DIR, content.getID().substring(0, 8)) + "/";
		String file_name = content.getID() + INFO_SAVE_FILE_EXT;

		File __OUT_FILE__ = new File(store_file_name + file_name);

		if( __OUT_FILE__.exists() ) {
			boolean fileDel = __OUT_FILE__.delete();
			if(!fileDel) log.error("File deletion failed");
		}

		ContentInfo.toXmlFile(store_file_name + file_name, content);
		if (log.isDebugEnabled()) {
			log.debug("REGIST ORG WRITE END");
		}
		ContentInfo returnValue = ContentInfo.XmlToContentInfo(store_file_name + file_name);
		if (log.isDebugEnabled()) {
			log.debug("REGIST ORG RECOVER END");
		}

		// xml 파일 위치를 content info 객체에 담는다.
		String path = store_file_name + file_name;
		if( INFO_SAVE_BASE_URL != null ) {
			int i = INFO_SAVE_BASE_DIR.length();
			path = INFO_SAVE_BASE_URL + store_file_name.substring(i) + file_name;
		}
		returnValue.setContentInfoPath(path);

		String push_msg = content.getScheduleInfo().getProperty("PUSH_MSG","");
		String push_title = content.getScheduleInfo().getProperty("PUSH_TITLE","");
		
		if (!StringUtil.isNull(push_msg)) {
			returnValue.getScheduleInfo().setProperty("PUSH_MSG", push_msg);
		}
		if (!StringUtil.isNull(push_title)) {
			returnValue.getScheduleInfo().setProperty("PUSH_TITLE", push_title);
		}
		
		ContentInfo.toXmlFile(store_file_name + "copy_" + file_name, returnValue);
		if (log.isDebugEnabled()) {
			log.debug("REGIST COPY WRITE END");
		}

		putContentInfo(returnValue, false);

		log.info(content.getID() + " is registed in ContentManager");
	}

	/**
	 * 외부에서 호출되며 ContentInfo를 등록한다.
	 * 
	 * @param content
	 *            등록할 ContentInfo
	 * @throws Exception
	 *             등록에러
	 */
	public synchronized static void registTestContentInfo(ContentInfo content) throws Exception {
		if (log.isDebugEnabled()) 
			log.debug("REGIST ID => " + content.getID());

		putContentInfo(content, false);

		log.info(content.getID() + " is registed in ContentManager");
	}

	/**
	 * Inner Hash에 contentinfo 정보를 넣는다. check flag가 true이면 ID로 검색하여 동일한 아이디의
	 * content가 등록되어 있으면 skip한다. false이면 검색 없이 다시 등록한다.
	 * 
	 * @param content
	 * @param check
	 * @throws Exception
	 */
	public synchronized static void putContentInfo(ContentInfo content, boolean check) throws Exception {

		content.execute();
		synchronized (lock) {
			if( check ) {
				if( CONTENTE_INFO_HASH.containsKey(content.getID()) ) {
					return;
				}
			}
			CONTENTE_INFO_HASH.put(content.getID(), content);
		}
	}

	/**
	 * 지정된 아이디에 해당하는 ContentInfo를 반환한다. <br>
	 * 만일 내부 Hash에 보관하지 않고 있다면 저장 디렉토리에서 찾아서 반환한다. <br>
	 * 그래도 없다면 null을 반환한다.
	 * 
	 * @param key
	 *            ContentInfo의 ID를 지정한다.
	 * @throws Exception
	 *             변환에러 발생
	 * @return 지정된 ContentInfo <br>
	 *         만일 저당되어 있지 않는 ContentInfo라면 null을 반환한다.
	 */
	public static ContentInfo getContentInfo(String key) throws Exception {

		if( key == null || key.length() < 2 ) {
			log.error(INNER_MANAGER.getName(), "INVALID KEY[".concat(key).concat("]"));
			return null;
		}

		if (log.isDebugEnabled()) {
			log.debug(INNER_MANAGER.getName(), "REQUEST ID => " + key);
			log.debug(INNER_MANAGER.getName(), "CHECK ID => " + key);
		}

		if( CONTENTE_INFO_HASH.containsKey(key) ) {
			if (log.isDebugEnabled()) {
				log.debug(INNER_MANAGER.getName(), "ALREADY CONTAIN => " + key);
			}
			ContentInfo returnValue = (ContentInfo) CONTENTE_INFO_HASH.get(key);
			returnValue.execute();
			return returnValue;
		}

		if (log.isDebugEnabled()) 
			log.debug(key + " is not in ContentManager so scan");

		/*
		 * < < < < File Scan 의 Rule이 다음과 같이 변화했음 2004.12.22 >>>> base dir은 메모리에
		 * (eMsSystem) "content.info.save.dir" 값으로 셋팅되어 있고 그 값 디렉토리를 뒤져서 key로
		 * 시작하는 파일을 가져온다.
		 */

		String scan_file_name = null;

		try {
			File f = new File(FileElement.CheckSubDirectory(eMsSystem.getProperty("content.info.save.dir"), key.substring(0, 8)));
			String[] fNames = f.list();

			for (int u = 0; u < fNames.length; u++) {
				if( (fNames[u].startsWith(key+"_") || fNames[u].startsWith(key+".")) && fNames[u].endsWith(".xml") ) {
					//bingo
					scan_file_name = FileElement.CheckSubDirectory(eMsSystem.getProperty("content.info.save.dir"), key.substring(0, 8))
							+ File.separator + fNames[u];
					break;
				}
			}
		}
		catch(Exception ex) {
			// 없는 셈 치자.
			log.error(ex.getMessage());
			return null;
		}

		// 못 찾은 경우는 무시하고 넘어간다.
		if( scan_file_name == null )
			return null;

		File tmpFile = new File(scan_file_name);

		/**
		 * 파일이 존재할 경우 파일을 읽어서 반환하고 파일도 없으면 널을 반환한다.
		 */
		if( tmpFile.exists() ) {
			ContentInfo returnValue = ContentInfo.XmlToContentInfo(scan_file_name);
			synchronized (lock) {
				CONTENTE_INFO_HASH.put(key, returnValue);
			}

			returnValue.execute();
			return returnValue;
		}

		log.info(INNER_MANAGER.getName(), "SCAN FILE NOT EXISTS SO RETURN NULL...");
		return null;
	}

	/*
	 * add 2002.10.18 MakeSendInfoTask의 사용의 범위가 작아졌기 때문에 삭제를 하고 남은 기능을
	 * MailSendTask로 이관을 하면서 컨텐트의 생성유무를 체그하기 위하여 추가
	 */
	/**
	 * 지정된 아이디의 ContentInfo가 존재 하는지를 체크한다.
	 * 
	 * @param key
	 *            검사할 ID
	 * @return true : 존재함 <br>
	 *         false : 존재하지 않음
	 */
	public static boolean checkContentInfo(String key) {
		synchronized (lock) {
			if( CONTENTE_INFO_HASH.containsKey(key) ) {
				return true;
			}
		}
		try {
			/*
			 * < < < < File Scan 의 Rule이 다음과 같이 변화했음 2004.12.22 >>>> base dir은
			 * 메모리에 (eMsSystem) "content.info.save.dir" 값으로 셋팅되어 있고 그 값 디렉토리를
			 * 뒤져서 key로 시작하는 파일을 가져온다.
			 */

			String scan_file_name = null;
			boolean exist = false;
			try {
				File f = new File(FileElement.CheckSubDirectory(eMsSystem.getProperty("content.info.save.dir"), key.substring(0, 8)));
				String[] fNames = f.list();

				for (int u = 0; u < fNames.length; u++) {
					if( (fNames[u].startsWith(key+"_") || fNames[u].startsWith(key+".")) && fNames[u].endsWith(".xml") ) {
						//bingo
						scan_file_name = FileElement.CheckSubDirectory(eMsSystem.getProperty("content.info.save.dir"), key.substring(0, 8))
								+ File.separator + fNames[u];
						exist = true;
						break;
					}
				}
			}
			catch(Exception ex) {
				// 없는 셈 치자.
				log.error(ex.getMessage());
				return false;
			}

			/**
			 * 파일이 존재할 경우 파일을 읽어서 반환하고 파일도 없으면 널을 반환한다.
			 */
			if( exist ) {
				ContentInfo returnValue = ContentInfo.XmlToContentInfo(scan_file_name);
				synchronized (lock) {
					CONTENTE_INFO_HASH.put(key, returnValue);
				}

				returnValue.execute();

				return true;
			}
		}
		catch(Exception e) {
			log.error("ContentInfoManager", e);
		}

		return false;
	}

	// ContentInfo 정보 ( A )
	private static final String	KEY_ID_INFO								= "AA";

	//	private static final String KEY_DEFAULT_MAPPING_INFO="AB";
	//	private static final String KEY_DEFAULT_HASH_MAPPING_INFO="AJ";
	private static final String	KEY_MAIL_BODY_INFO						= "AI";

	private static final String	KEY_MAPPING_HEADER_INFO					= "AC";

	private static final String	KEY_RETURN_PATH_INFO					= "AD";

	private static final String	KEY_SCHECULE_INFO						= "AE";

	//	private static final String KEY_SECURE_FLAG_INFO="AF";
	//	private static final String KEY_SECURE_MID_INFO="AG";
	private static final String	KEY_SEND_TYPE_INFO						= "AH";

	//	private static final String KEY_RCPT_TYPE="AZ";

	// DEFAULT_MAPPING 정보 ( AB ) -> 그냥 넣었으므로 사용은 하지 않는다.
	//	private static final String KEY_DEFAULT_SIMPLE_MAPPING_INFO="ABA";
	//	private static final String KEY_DEFAULT_LIST_MAPPING_INFO="ABB";

	// MailBody 정보 ( AI )
	private static final String	KEY_FROM_EMAIL_INFO						= "AIA";

	private static final String	KEY_FROM_NAME_INFO						= "AIB";

	private static final String	KEY_SUBJECT_INFO						= "AIC";

	private static final String	KEY_TO_NAME_INFO						= "AID";

	private static final String	KEY_TO_EMAIL_INFO						= "AIE";

	private static final String	KEY_MESSAGE_INFO						= "AIF";

	// MESSAGE 정보 ( AIF )
	private static final String	KEY_CHARSET_INFO						= "AIFA";

	private static final String	KEY_CONTENT_INFO						= "AIFB";

	private static final String	KEY_CONTENT_ENCODING_INFO				= "AIFC";

	private static final String	KEY_CONTENT_TYPE_INFO					= "AIFD";

	private static final String	KEY_MESSAGE_ID_INFO						= "AIFE";

	// BODYPARSER 정보 ( AIFB ) -> 3개의 String이므로 배열로 처리 사용하지 않는다.
	//	private static final String KEY_BODY_INFO="AIFBA";
	//	private static final String KEY_BODY_NAME_INFO="AIFBB";
	//	private static final String KEY_BODY_ORIGINAL_INFO="AIFBC";

	private static final String	BINARY_ATTACH_BODY_PARSER_CLASS_NAME	= "mercury.contents.common.parser.BinaryAttachBodyParser";

	private static Class		BINARY_ATTACH_BODY_PARSER_CLASS			= null;
	static {
		try {
			BINARY_ATTACH_BODY_PARSER_CLASS = Class.forName(BINARY_ATTACH_BODY_PARSER_CLASS_NAME);
		}
		catch(Exception e) {
			log.error("Exception",e);
		}
	}

	protected static ContentInfo HashtableToContentInfo(Hashtable src) throws Exception {
		// String SEND_TYPE = (String)src.get( KEY_SEND_TYPE_INFO );

		ContentInfo returnValue = new ContentInfo();

		/**
		 * ContentInfo중에서 단순 텍스트 데이터를 집어 넣는다.
		 */
		returnValue.setID((String) src.get(KEY_ID_INFO));
		returnValue.setMappingHeader((String) src.get(KEY_MAPPING_HEADER_INFO));
		returnValue.setReturnPath((String) src.get(KEY_RETURN_PATH_INFO));
		returnValue.setScheduleInfo((Properties) src.get(KEY_SCHECULE_INFO));
		returnValue.setSendType((String) src.get(KEY_SEND_TYPE_INFO));

		/**
		 * MailBody 부분을 정보를 Hashtable로 해부하여 담아내기 시작!
		 */
		Hashtable MailBodyInfo = (Hashtable) src.get(KEY_MAIL_BODY_INFO);

		MailBody targetMailBody = (MailBody) InstanceFactory.getInstance("O", "00", eMsTypes.MAILBODY_INSTANCE);

		targetMailBody.setEtcHeader(eMsLocale.DEFAULT_HEADER);
		targetMailBody.setFromEmail((String) MailBodyInfo.get(KEY_FROM_EMAIL_INFO));
		targetMailBody.setFromName((String) MailBodyInfo.get(KEY_FROM_NAME_INFO));
		targetMailBody.setSubject((String) MailBodyInfo.get(KEY_SUBJECT_INFO));
		targetMailBody.setToName((String) MailBodyInfo.get(KEY_TO_NAME_INFO));
		targetMailBody.setToEmail((String) MailBodyInfo.get(KEY_TO_EMAIL_INFO));
		{
			Vector Messages = (Vector) MailBodyInfo.get(KEY_MESSAGE_INFO);
			for (int i = 0; i < Messages.size(); i++) {
				Hashtable tmpMessageInfo = (Hashtable) Messages.get(i);

				Message tmpMessage = (Message) InstanceFactory.getInstance("O", "00", eMsTypes.MESSAGE_INSTANCE);

				tmpMessage.setCharSet((String) tmpMessageInfo.get(KEY_CHARSET_INFO));
				tmpMessage.setContentEncoding((Short) tmpMessageInfo.get(KEY_CONTENT_ENCODING_INFO));
				tmpMessage.setContentType((Short) tmpMessageInfo.get(KEY_CONTENT_TYPE_INFO));
				tmpMessage.setMessageID((String) tmpMessageInfo.get(KEY_MESSAGE_ID_INFO));

				String[] tmpBodyParserInfo = (String[]) tmpMessageInfo.get(KEY_CONTENT_INFO);

				/**
				 * 최고 기본 메세지는 발송 타입에따라 하지만 그 이상은 첨부이기 때문에 지정하여 파서를 생성한다.( Ver3.0
				 * 에 한정하며 마이너 업데이트에서 개선할 여지가 있다 )
				 */
				BodyParser tmpBodyParser = null;
				if( i > 0 ) {
					tmpBodyParser = (BodyParser) (BINARY_ATTACH_BODY_PARSER_CLASS.newInstance());
				}
				else {
					tmpBodyParser = (BodyParser) InstanceFactory.getInstance("O", "00", eMsTypes.BODYPARSER_INSTANCE);
				}

				tmpBodyParser.setContents(tmpBodyParserInfo[0], tmpBodyParserInfo[1], tmpBodyParserInfo[2]);

				tmpMessage.setContent(tmpBodyParser);

				targetMailBody.setMessage(tmpMessage);
			}
		}

		returnValue.setMailBody(targetMailBody);

		return returnValue;
	}
}
