/*
 * @(#)ContentInfo.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.common.basic;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

import mercury.contents.auto.producer.BasicContentPD;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import pluto.io.eMsFileWriter;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.util.xml.DOMParser;
import pluto.util.xml.XMLUtil;
import pluto.util.xml.XMLWriter;

/**
 * 기본 Contents 정보
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class ContentInfo implements Cloneable {

	private static String			DTD_LOCATION		= null;

	private static String			XML_ENC_TYPE		= null;

//	private static String			XML_OUT_CHARSET		= null;

	/** Content Info xml 파일의 위치가 담긴 path */
	private String					contentInfoPath		= "";

	private static XMLWriter		XML_WRITER_INSTANCE	= null;

	static {
		try {
			XML_WRITER_INSTANCE = new XMLWriter();
		}
		catch(Throwable th) {
			log.error(th.getMessage());
			System.exit(1);
		}
	}

	/**
	 * call from ContentInfoManager
	 */
	public synchronized static void setDTDLocation(String location) throws Exception {
		DTD_LOCATION = location;
	}

	public synchronized static void setEncoding(String enc) throws Exception {
		XML_ENC_TYPE = enc;
	}

	public synchronized static void setFileEncoding(String enc) throws Exception {
//		XML_OUT_CHARSET = enc;
	}

	protected synchronized Document getXmlDocument() throws Exception {

		Document returnValue = DOMParser.getEmptyDocument();

		/**
		 * 최상위 Element
		 */
		Element CONTENT_ELEMENTS = returnValue.createElement("CONTENT");

		/**
		 * 메일 전체 정보 Element( CONTENT -> POSTID ) 시작
		 */
		Element POSTID_ELEMENTS = returnValue.createElement("POSTID");

		POSTID_ELEMENTS.setAttribute("value", ID);

		/**
		 * ( CONTENT -> POSTID ) 노드를 ( CONTENT ) 노드에 추가
		 */
		CONTENT_ELEMENTS.appendChild(POSTID_ELEMENTS);
		// 리턴패스 Element( CONTENT -> INFO -> MAILFROM ) 종료

		/**
		 * 메일 전체 정보 Element( CONTENT -> INFO ) 시작 MAILFROM RCPT vars
		 */

		log.debug("echo");
		Element INFO_ELEMENTS = returnValue.createElement("INFO");

		/**
		 * 리턴패스 Element( CONTENT -> INFO -> MAILFROM )
		 */
		Element MAILFROM_ELEMENTS = returnValue.createElement("MAILFROM");
		MAILFROM_ELEMENTS.setAttribute("value", returnPath);

		/**
		 * ( CONTENT -> INFO -> MAILFROM ) 노드를 ( CONTENT -> INFO ) 노드에 추가
		 */
		INFO_ELEMENTS.appendChild(MAILFROM_ELEMENTS);
		// 리턴패스 Element( CONTENT -> INFO -> MAILFROM ) 종료

		/**
		 * RCPT PATTERN Element( CONTENT -> INFO -> RCPT )
		 */
		//Element RCPT_ELEMENTS = returnValue.createElement( "RCPT" );
		//RCPT_ELEMENTS.setAttribute( "value" ,
		// RCPT_PATTERN==null?eMsTypes.SHORT_SINGLE_RCPT.toString():RCPT_PATTERN.toString()
		// );
		/**
		 * ( CONTENT -> INFO -> MAILFROM ) 노드를 ( CONTENT -> INFO ) 노드에 추가
		 */
		//INFO_ELEMENTS.appendChild( RCPT_ELEMENTS );
		// RCPT PATTERN Element( CONTENT -> INFO -> RCPT ) 종료
		/**
		 * Schedule info( Properties ) 를 꺼내서 꼽아주세요~~~~~
		 */
		for (Iterator iter = scheduleInfo.keySet().iterator(); iter.hasNext();) {
			String key = (String) iter.next();
			String value = (String) scheduleInfo.get(key);

			Element VAR_ELEMENTS = returnValue.createElement("var");

			VAR_ELEMENTS.setAttribute("name", key);
			VAR_ELEMENTS.setAttribute("value", value);

			INFO_ELEMENTS.appendChild(VAR_ELEMENTS);
		}

		/**
		 * ( CONTENT -> INFO ) 노드를 ( CONTENT ) 노드에 추가
		 */
		CONTENT_ELEMENTS.appendChild(INFO_ELEMENTS);
		//메일 전체 정보 Element( CONTENT -> INFO ) 종료

		/**
		 * MailBody 정보 Element ( CONTENT -> BODY ) 시작 BODYCLASS FROMEMAIL
		 * FROMNAME SUBJECT TONAME TOEMAIL MESSAGE++
		 */
		MailBody mailbody = getMailBody();

		Element BODY_ELEMENTS = returnValue.createElement("BODY");

		/**
		 * BODYCLASS 정보( CONTENT -> BODY -> BODYCLASS ) 시작
		 */
		Element BODYCLASS_ELEMENTS = returnValue.createElement("BODYCLASS");

		BODYCLASS_ELEMENTS.setAttribute("value", getMailBody().getClass().getName());

		/**
		 * ( CONTENT -> BODY -> BODYCLASS ) 노드를 ( CONTENT -> BODY ) 노드에 추가
		 */
		BODY_ELEMENTS.appendChild(BODYCLASS_ELEMENTS);
		// BODYCLASS 정보( CONTENT -> BODY -> BODYCLASS ) 종료

		/**
		 * FROMEMAIL 헤더 정보( CONTENT -> BODY -> FROMEMAIL ) 시작
		 */
		Element FROMEMAIL_ELEMENTS = returnValue.createElement("FROMEMAIL");

		FROMEMAIL_ELEMENTS.setAttribute("value", mailbody.getFromEmail());

		/**
		 * ( CONTENT -> BODY -> FROMEMAIL ) 노드를 ( CONTENT -> BODY ) 노드에 추가
		 */
		BODY_ELEMENTS.appendChild(FROMEMAIL_ELEMENTS);
		// FROMEMAIL 헤더 정보( CONTENT -> BODY -> FROMEMAIL ) 종료

		/**
		 * 매핑 헤더 정보( CONTENT -> BODY -> FROMNAME ) 시작
		 */
		Element FROMNAME_ELEMENTS = returnValue.createElement("FROMNAME");

		FROMNAME_ELEMENTS.setAttribute("value", mailbody.getFromName());

		/**
		 * ( CONTENT -> BODY -> FROMNAME ) 노드를 ( CONTENT -> BODY ) 노드에 추가
		 */
		BODY_ELEMENTS.appendChild(FROMNAME_ELEMENTS);
		// 매핑 헤더 정보( CONTENT -> BODY -> FROMNAME ) 종료

		/**
		 * 매핑 헤더 정보( CONTENT -> BODY -> SUBJECT ) 시작
		 */
		Element SUBJECT_ELEMENTS = returnValue.createElement("SUBJECT");

		SUBJECT_ELEMENTS.setAttribute("value", mailbody.getSubject());

		/**
		 * ( CONTENT -> BODY -> SUBJECT ) 노드를 ( CONTENT -> BODY ) 노드에 추가
		 */
		BODY_ELEMENTS.appendChild(SUBJECT_ELEMENTS);
		// 매핑 헤더 정보( CONTENT -> BODY -> SUBJECT ) 종료

		/**
		 * 매핑 헤더 정보( CONTENT -> BODY -> TONAME ) 시작
		 */
		Element TONAME_ELEMENTS = returnValue.createElement("TONAME");

		TONAME_ELEMENTS.setAttribute("value", mailbody.getToName());

		/**
		 * ( CONTENT -> BODY -> TONAME ) 노드를 ( CONTENT -> BODY ) 노드에 추가
		 */
		BODY_ELEMENTS.appendChild(TONAME_ELEMENTS);
		// 매핑 헤더 정보( CONTENT -> BODY -> TONAME ) 종료

		/**
		 * 매핑 헤더 정보( CONTENT -> BODY -> TOEMAIL ) 시작
		 */
		Element TOEMAIL_ELEMENTS = returnValue.createElement("TOEMAIL");

		TOEMAIL_ELEMENTS.setAttribute("value", mailbody.getToEmail());

		/**
		 * ( CONTENT -> BODY -> TOEMAIL ) 노드를 ( CONTENT -> BODY ) 노드에 추가
		 */
		BODY_ELEMENTS.appendChild(TOEMAIL_ELEMENTS);
		// 매핑 헤더 정보( CONTENT -> BODY -> TOEMAIL ) 종료

		Vector Messages = mailbody.getMessage();

		for (int i = 0; i < Messages.size(); i++) {
			/**
			 * 매핑 헤더 정보( CONTENT -> BODY -> MESSAGE ) 시작 MESSAGECLASS
			 * BODYPARSERCLASS MESSAGECHARSET CONTENTENCODING CONTENTTYPE
			 * MESSAGEID ORIGINAL MESSAGENAME MESSAGECONTENTS
			 */
			Element MESSAGE_ELEMENTS = returnValue.createElement("MESSAGE");

			Message tmpMessage = (Message) Messages.get(i);

			/**
			 * MESSAGECLASS 정보( CONTENT -> BODY -> MESSAGE -> MESSAGECLASS ) 시작
			 */
			Element MESSAGECLASS_ELEMENTS = returnValue.createElement("MESSAGECLASS");

			MESSAGECLASS_ELEMENTS.setAttribute("value", tmpMessage.getClass().getName());

			/**
			 * ( CONTENT -> BODY -> MESSAGE -> MESSAGECLASS ) 노드를 ( CONTENT ->
			 * BODY -> MESSAGE ) 노드에 추가
			 */
			MESSAGE_ELEMENTS.appendChild(MESSAGECLASS_ELEMENTS);
			// MESSAGECLASS 정보( CONTENT -> BODY -> MESSAGE -> MESSAGECLASS ) 종료

			/**
			 * MESSAGECHARSET 정보( CONTENT -> BODY -> MESSAGE -> MESSAGECHARSET )
			 * 시작
			 */
			Element MESSAGECHARSET_ELEMENTS = returnValue.createElement("MESSAGECHARSET");

			MESSAGECHARSET_ELEMENTS.setAttribute("value", tmpMessage.getCharSet());

			/**
			 * ( CONTENT -> BODY -> MESSAGE -> MESSAGECHARSET ) 노드를 ( CONTENT ->
			 * BODY -> MESSAGE ) 노드에 추가
			 */
			MESSAGE_ELEMENTS.appendChild(MESSAGECHARSET_ELEMENTS);
			// MESSAGECHARSET 정보( CONTENT -> BODY -> MESSAGE -> MESSAGECHARSET )
			// 종료

			/**
			 * CONTENTENCODING 정보( CONTENT -> BODY -> MESSAGE -> CONTENTENCODING )
			 * 시작
			 */
			Element CONTENTENCODING_ELEMENTS = returnValue.createElement("CONTENTENCODING");

			CONTENTENCODING_ELEMENTS.setAttribute("value", tmpMessage.getContentEncoding().toString());

			/**
			 * ( CONTENT -> BODY -> MESSAGE -> CONTENTENCODING ) 노드를 ( CONTENT ->
			 * BODY -> MESSAGE ) 노드에 추가
			 */
			MESSAGE_ELEMENTS.appendChild(CONTENTENCODING_ELEMENTS);
			// CONTENTENCODING 정보( CONTENT -> BODY -> MESSAGE -> CONTENTENCODING
			// ) 종료

			/**
			 * CONTENTTYPE 정보( CONTENT -> BODY -> MESSAGE -> CONTENTTYPE ) 시작
			 */
			Element CONTENTTYPE_ELEMENTS = returnValue.createElement("CONTENTTYPE");

			CONTENTTYPE_ELEMENTS.setAttribute("value", tmpMessage.getContentType().toString());

			/**
			 * ( CONTENT -> BODY -> MESSAGE -> CONTENTTYPE ) 노드를 ( CONTENT ->
			 * BODY -> MESSAGE ) 노드에 추가
			 */
			MESSAGE_ELEMENTS.appendChild(CONTENTTYPE_ELEMENTS);
			// CONTENTTYPE 정보( CONTENT -> BODY -> MESSAGE -> CONTENTTYPE ) 종료

			/**
			 * MESSAGEID 정보( CONTENT -> BODY -> MESSAGE -> MESSAGEID ) 시작
			 */
			Element MESSAGEID_ELEMENTS = returnValue.createElement("MESSAGEID");

			MESSAGEID_ELEMENTS.setAttribute("value", tmpMessage.getMessageID());

			/**
			 * ( CONTENT -> BODY -> MESSAGE -> MESSAGEID ) 노드를 ( CONTENT -> BODY ->
			 * MESSAGE ) 노드에 추가
			 */
			MESSAGE_ELEMENTS.appendChild(MESSAGEID_ELEMENTS);
			// MESSAGEID 정보( CONTENT -> BODY -> MESSAGE -> MESSAGEID ) 종료

			BodyParser tmpBodyParser = tmpMessage.getContent();

			/**
			 * BODYPARSERCLASS 정보( CONTENT -> BODY -> MESSAGE -> BODYPARSERCLASS )
			 * 시작
			 */
			Element BODYPARSERCLASS_ELEMENTS = returnValue.createElement("BODYPARSERCLASS");

			BODYPARSERCLASS_ELEMENTS.setAttribute("value", tmpBodyParser.getClass().getName());

			/**
			 * ( CONTENT -> BODY -> MESSAGE -> BODYPARSERCLASS ) 노드를 ( CONTENT ->
			 * BODY -> MESSAGE ) 노드에 추가
			 */
			MESSAGE_ELEMENTS.appendChild(BODYPARSERCLASS_ELEMENTS);
			// BODYPARSERCLASS 정보( CONTENT -> BODY -> MESSAGE -> BODYPARSERCLASS
			// ) 종료

			/**
			 * ORIGINAL 정보( CONTENT -> BODY -> MESSAGE -> ORIGINAL ) 시작
			 */
			Element ORIGINAL_ELEMENTS = returnValue.createElement("ORIGINAL");

			CDATASection ORIGINAL_SECTION = returnValue.createCDATASection("ORIGINAL");

			ORIGINAL_SECTION.setData(tmpBodyParser.getOriginal());

			ORIGINAL_ELEMENTS.appendChild(ORIGINAL_SECTION);

			/**
			 * ( CONTENT -> BODY -> MESSAGE -> ORIGINAL ) 노드를 ( CONTENT -> BODY ->
			 * MESSAGE ) 노드에 추가
			 */
			MESSAGE_ELEMENTS.appendChild(ORIGINAL_ELEMENTS);
			// ORIGINAL 정보( CONTENT -> BODY -> MESSAGE -> ORIGINAL ) 종료

			/**
			 * MESSAGENAME 정보( CONTENT -> BODY -> MESSAGE -> MESSAGENAME ) 시작
			 */
			Element MESSAGENAME_ELEMENTS = returnValue.createElement("MESSAGENAME");

			MESSAGENAME_ELEMENTS.setAttribute("value", tmpMessage.getContentName());

			/**
			 * ( CONTENT -> BODY -> MESSAGE -> MESSAGENAME ) 노드를 ( CONTENT ->
			 * BODY -> MESSAGE ) 노드에 추가
			 */
			MESSAGE_ELEMENTS.appendChild(MESSAGENAME_ELEMENTS);
			// MESSAGENAME 정보( CONTENT -> BODY -> MESSAGE -> MESSAGENAME ) 종료

			/**
			 * MESSAGECONTENTS 정보( CONTENT -> BODY -> MESSAGE -> MESSAGECONTENTS )
			 * 시작
			 */
			Element MESSAGECONTENTS_ELEMENTS = returnValue.createElement("MESSAGECONTENTS");

			CDATASection CONTENT_SECTION = returnValue.createCDATASection("CONTENT");

			if (log.isDebugEnabled()) {
				String content = tmpBodyParser.getContents();
				log.debug("XML GET CONTENT", content);
				CONTENT_SECTION.setData(content);
			}
			else {
				CONTENT_SECTION.setData(tmpBodyParser.getContents());
			}

			MESSAGECONTENTS_ELEMENTS.appendChild(CONTENT_SECTION);

			/**
			 * ( CONTENT -> BODY -> MESSAGE -> MESSAGECONTENTS ) 노드를 ( CONTENT ->
			 * BODY -> MESSAGE ) 노드에 추가
			 */
			MESSAGE_ELEMENTS.appendChild(MESSAGECONTENTS_ELEMENTS);
			// MESSAGECONTENTS 정보( CONTENT -> BODY -> MESSAGE -> MESSAGECONTENTS
			// ) 종료

			/**
			 * ( CONTENT -> BODY -> MESSAGE ) 노드를 ( CONTENT -> BODY ) 노드에 추가
			 */
			BODY_ELEMENTS.appendChild(MESSAGE_ELEMENTS);
			// MESSAGE 정보( CONTENT -> BODY -> MESSAGE ) 종료
		}

		/**
		 * ( CONTENT -> BODY ) 노드를 ( CONTENT ) 노드에 추가
		 */
		CONTENT_ELEMENTS.appendChild(BODY_ELEMENTS);
		// CONTENT 정보( CONTENT ) 종료

		returnValue.appendChild(CONTENT_ELEMENTS);

		return returnValue;
	}

	public synchronized static void toXmlFile(String out_file, ContentInfo info) throws Exception {
		eMsFileWriter out = new eMsFileWriter(out_file);
		try {
			XML_WRITER_INSTANCE.setEncoding(XML_ENC_TYPE);
			XML_WRITER_INSTANCE.outResult(out, info.getXmlDocument(), DTD_LOCATION);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				out.flush();
			}
			catch(Exception e) {
			}
			try {
				out.close();
			}
			catch(Exception e) {
			}
		}
	}

	public synchronized static ContentInfo XmlToContentInfo(String url) throws Exception {
		log.debug("Debug-url:"+url);
		Document DOCUMENT = DOMParser.getDocumentFromUrl(url);

		ContentInfo returnValue = new ContentInfo();

		Element CONTENT_ELEMENTS = (Element) DOCUMENT.getElementsByTagName("CONTENT").item(0);

		/**
		 * 아이디 세팅
		 */
		Element POSTID_ELEMENTS = (Element) CONTENT_ELEMENTS.getElementsByTagName("POSTID").item(0);
		returnValue.setID(POSTID_ELEMENTS.getAttribute("value"));

		Element INFO_ELEMENTS = (Element) CONTENT_ELEMENTS.getElementsByTagName("INFO").item(0);

		/**
		 * 리턴패스 세팅
		 */
		Element MAILFROM_ELEMENTS = (Element) INFO_ELEMENTS.getElementsByTagName("MAILFROM").item(0);
		returnValue.setReturnPath(MAILFROM_ELEMENTS.getAttribute("value"));

		/**
		 * RCPT 패턴 세팅
		 */
		/**
		 * 나머지 프로퍼티를 세팅한다.
		 */
		NodeList PROPERTY_NODES = INFO_ELEMENTS.getElementsByTagName("var");

		Properties __SCHEDULE_INFO__ = new Properties();

		for (int i = 0; i < PROPERTY_NODES.getLength(); i++) {
			Element VAR_ELEMENTS = (Element) PROPERTY_NODES.item(i);

			__SCHEDULE_INFO__.setProperty(VAR_ELEMENTS.getAttribute("name"), VAR_ELEMENTS.getAttribute("value"));
		}

		returnValue.setScheduleInfo(__SCHEDULE_INFO__);

		/**
		 * MailBody 정보 Element ( CONTENT -> BODY ) 시작
		 */
		Element BODY_ELEMENTS = (Element) CONTENT_ELEMENTS.getElementsByTagName("BODY").item(0);

		/**
		 * BODYCLASS 정보( CONTENT -> BODY -> BODYCLASS )
		 */
		Element BODYCLASS_ELEMENTS = (Element) BODY_ELEMENTS.getElementsByTagName("BODYCLASS").item(0);

		MailBody targetMailBody = (MailBody) (Class.forName(BODYCLASS_ELEMENTS.getAttribute("value")).newInstance());

		targetMailBody.setEtcHeader(eMsLocale.DEFAULT_HEADER);

		/**
		 * FROMEMAIL 헤더 정보( CONTENT -> BODY -> FROMEMAIL )
		 */
		Element FROMEMAIL_ELEMENTS = (Element) BODY_ELEMENTS.getElementsByTagName("FROMEMAIL").item(0);
		targetMailBody.setFromEmail(FROMEMAIL_ELEMENTS.getAttribute("value"));

		/**
		 * 매핑 헤더 정보( CONTENT -> BODY -> FROMNAME )
		 */
		Element FROMNAME_ELEMENTS = (Element) BODY_ELEMENTS.getElementsByTagName("FROMNAME").item(0);
		targetMailBody.setFromName(FROMNAME_ELEMENTS.getAttribute("value"));

		/**
		 * 매핑 헤더 정보( CONTENT -> BODY -> SUBJECT )
		 */
		Element SUBJECT_ELEMENTS = (Element) BODY_ELEMENTS.getElementsByTagName("SUBJECT").item(0);
		targetMailBody.setSubject(SUBJECT_ELEMENTS.getAttribute("value"));

		/**
		 * 매핑 헤더 정보( CONTENT -> BODY -> TONAME )
		 */
		Element TONAME_ELEMENTS = (Element) BODY_ELEMENTS.getElementsByTagName("TONAME").item(0);
		targetMailBody.setToName(TONAME_ELEMENTS.getAttribute("value"));

		/**
		 * 매핑 헤더 정보( CONTENT -> BODY -> TOEMAIL ) 시작
		 */
		Element TOEMAIL_ELEMENTS = (Element) BODY_ELEMENTS.getElementsByTagName("TOEMAIL").item(0);
		targetMailBody.setToEmail(TOEMAIL_ELEMENTS.getAttribute("value"));

		NodeList MESSAGE_NODES = BODY_ELEMENTS.getElementsByTagName("MESSAGE");

		for (int i = 0; i < MESSAGE_NODES.getLength(); i++) {
			Element MESSAGE_ELEMENTS = (Element) MESSAGE_NODES.item(i);

			/**
			 * MESSAGECLASS 정보( CONTENT -> BODY -> MESSAGE -> MESSAGECLASS ) 시작
			 */
			Element MESSAGECLASS_ELEMENTS = (Element) MESSAGE_ELEMENTS.getElementsByTagName("MESSAGECLASS").item(0);

			Message tmpMessage = (Message) (Class.forName(MESSAGECLASS_ELEMENTS.getAttribute("value")).newInstance());

			/**
			 * MESSAGECHARSET 정보( CONTENT -> BODY -> MESSAGE -> MESSAGECHARSET )
			 * 시작
			 */
			Element MESSAGECHARSET_ELEMENTS = (Element) MESSAGE_ELEMENTS.getElementsByTagName("MESSAGECHARSET").item(0);
			tmpMessage.setCharSet(MESSAGECHARSET_ELEMENTS.getAttribute("value"));

			/**
			 * CONTENTENCODING 정보( CONTENT -> BODY -> MESSAGE -> CONTENTENCODING )
			 * 시작
			 */
			Element CONTENTENCODING_ELEMENTS = (Element) MESSAGE_ELEMENTS.getElementsByTagName("CONTENTENCODING").item(0);
			tmpMessage.setContentEncoding(Short.valueOf(CONTENTENCODING_ELEMENTS.getAttribute("value")));

			/**
			 * CONTENTTYPE 정보( CONTENT -> BODY -> MESSAGE -> CONTENTTYPE ) 시작
			 */
			Element CONTENTTYPE_ELEMENTS = (Element) MESSAGE_ELEMENTS.getElementsByTagName("CONTENTTYPE").item(0);
			tmpMessage.setContentType(Short.valueOf(CONTENTTYPE_ELEMENTS.getAttribute("value")));

			/**
			 * MESSAGEID 정보( CONTENT -> BODY -> MESSAGE -> MESSAGEID ) 시작
			 */
			Element MESSAGEID_ELEMENTS = (Element) MESSAGE_ELEMENTS.getElementsByTagName("MESSAGEID").item(0);
			tmpMessage.setMessageID(MESSAGEID_ELEMENTS.getAttribute("value"));

			/**
			 * BODYPARSERCLASS 정보( CONTENT -> BODY -> MESSAGE -> BODYPARSERCLASS )
			 * 시작
			 */
			Element BODYPARSERCLASS_ELEMENTS = (Element) MESSAGE_ELEMENTS.getElementsByTagName("BODYPARSERCLASS").item(0);

			BodyParser tmpBodyParser = (BodyParser) (Class.forName(BODYPARSERCLASS_ELEMENTS.getAttribute("value")).newInstance());

			/**
			 * ORIGINAL 정보( CONTENT -> BODY -> MESSAGE -> ORIGINAL ) 시작
			 */
			Element ORIGINAL_ELEMENTS = (Element) MESSAGE_ELEMENTS.getElementsByTagName("ORIGINAL").item(0);

			/**
			 * MESSAGENAME 정보( CONTENT -> BODY -> MESSAGE -> MESSAGENAME ) 시작
			 */
			Element MESSAGENAME_ELEMENTS = (Element) MESSAGE_ELEMENTS.getElementsByTagName("MESSAGENAME").item(0);

			/**
			 * MESSAGECONTENTS 정보( CONTENT -> BODY -> MESSAGE -> MESSAGECONTENTS )
			 * 시작
			 */
			Element MESSAGECONTENTS_ELEMENTS = (Element) MESSAGE_ELEMENTS.getElementsByTagName("MESSAGECONTENTS").item(0);

			String sOriginal = XMLUtil.getCDATA_SECTION(ORIGINAL_ELEMENTS).trim();
			String sContents = XMLUtil.getCDATA_SECTION(MESSAGECONTENTS_ELEMENTS);
			String sName = MESSAGENAME_ELEMENTS.getAttribute("value");
			
			tmpBodyParser.setContents(sOriginal, sContents, sName);

			// 첨부일경우에 메세지 이름을 지정해야한다.
			tmpMessage.setContentName(MESSAGENAME_ELEMENTS.getAttribute("value"));

			/**
			 * 메세지에 파서를 세팅
			 */
			tmpMessage.setContent(tmpBodyParser);

			/**
			 * 메일바디에 메세지를 세팅
			 */
			targetMailBody.setMessage(tmpMessage);
		}

		returnValue.setMailBody(targetMailBody);

		return returnValue;
	}

	/* 10분동안 호출이 한번도 일어나지 않은 상태에서 지속된 일정시간이 되면 삭제하도록 한다. */
	public static final long	NO_END_DURATION	= 10 * 60 * 1000L;

	/** Holds value of property ID. */
	private String				ID				= "";

	/** Holds value of property mailBody. */
	private MailBody			mailBody;

	/** Holds value of property returnPath. */
	private String				returnPath		= "";

	/** Holds value of property startTime. */
	private long				startTime;

	/** Holds value of property defaultMapping. */
	private Map					defaultMapping;

	/** Holds value of property scheduleInfo. */
	private Properties			scheduleInfo;

	/** Holds value of property mappingHeader. */
	private String				mappingHeader	= "";

	/** 최종 호출 시간을 기억한다. */
	private long				exec_time		= 0;

	/** Holds value of property sendType. */
	private String				sendType		= "";

	private String				SPOOL_DELIMIT	= null;

	/** Creates new ContentInfo */
	public ContentInfo() {
		this.exec_time = System.currentTimeMillis();
	}

	/**
	 * 현재의 Content가 유효한지를 반환한다. 지정된 시간동안만 재발송을 하기때문에 기준시간이상이되면 삭제되고 재발송은 진행되지
	 * 않는다. ContentInfoManager에 의해서 호출이되며 반환되는 값에 따라서 지속여부가 결정이 된다.
	 * 
	 * @return true: 만료기간이 지났으며 파기 되어야 한다. ContentInfoManager는 이 Content를 삭제한다.
	 *         false: 만료기간이 지나지 않았으며 지속되어야한다.
	 */
	public boolean expire() {
		return System.currentTimeMillis() - this.exec_time > NO_END_DURATION;
	}

	public void execute() {
		this.exec_time = System.currentTimeMillis();
	}

	/**
	 * Getter for property ID.
	 * 
	 * @return Value of property ID.
	 */
	public String getID() {
		return ID;
	}

	/**
	 * Setter for property ID.
	 * 
	 * @param ID
	 *            New value of property ID.
	 */
	public void setID(String ID) {
		this.ID = ID;
	}

	/**
	 * Getter for property mailBody.
	 * 
	 * @return Value of property mailBody.
	 */
	public MailBody getMailBody() {
		return mailBody;
	}

	/**
	 * Setter for property mailBody.
	 * 
	 * @param mailBody
	 *            New value of property mailBody.
	 */
	public void setMailBody(MailBody mailBody) {
		this.mailBody = mailBody;
	}

	/**
	 * Getter for property returnPath.
	 * 
	 * @return Value of property returnPath.
	 */
	public String getReturnPath() {
		return returnPath;
	}

	/**
	 * Setter for property returnPath.
	 * 
	 * @param returnPath
	 *            New value of property returnPath.
	 */
	public void setReturnPath(String returnPath) {
		this.returnPath = returnPath;
	}

	/**
	 * Getter for property startTime.
	 * 
	 * @return Value of property startTime.
	 */
	public long getStartTime() {
		return startTime;
	}

	/**
	 * Setter for property startTime.
	 * 
	 * @param startTime
	 *            New value of property startTime.
	 */
	public void setStartTime(long startTime) {
		this.startTime = startTime;
	}

	/**
	 * Getter for property defaultMapping.
	 * 
	 * @return Value of property defaultMapping.
	 */
	public Map getDefaultMapping() {
		return defaultMapping;
	}

	/**
	 * Setter for property defaultMapping.
	 * 
	 * @param defaultMapping
	 *            New value of property defaultMapping.
	 */
	public void setDefaultMapping(Map defaultMapping) {
		this.defaultMapping = defaultMapping;
	}

	/**
	 * Getter for property scheduleInfo.
	 * 
	 * @return Value of property scheduleInfo.
	 */
	public Properties getScheduleInfo() {
		return scheduleInfo;
	}

	/**
	 * Setter for property scheduleInfo.
	 * 
	 * @param scheduleInfo
	 *            New value of property scheduleInfo.
	 */
	public void setScheduleInfo(Properties scheduleInfo) {
		this.scheduleInfo = scheduleInfo;
	}

	/**
	 * Getter for property mappingHeader.
	 * 
	 * @return Value of property mappingHeader.
	 */
	public String getMappingHeader() {
		return mappingHeader;
	}

	/**
	 * Setter for property mappingHeader.
	 * 
	 * @param mappingHeader
	 *            New value of property mappingHeader.
	 */
	public void setMappingHeader(String mappingHeader) {
		this.mappingHeader = mappingHeader;
	}

	/**
	 * Getter for property sendType.
	 * 
	 * @return Value of property sendType.
	 */
	public String getSendType() {
		return sendType;
	}

	/**
	 * Setter for property sendType.
	 * 
	 * @param sendType
	 *            New value of property sendType.
	 */
	public void setSendType(String sendType) {
		this.sendType = sendType;
	}

	public String getResultMailBody(Object info1, Object info2, Properties prop) throws Exception {
		//if (log.isDebugEnabled())  log.debug( "MAIL BODY CLASS NAME" ,
		// mailBody.getClass().getName() );
		return mailBody.getMailBody(info1, info2, prop);
	}

	public String getResultMailBody(Object info1, Object info2) throws Exception {
		return getResultMailBody(info1, info2, this.scheduleInfo);
	}

	public String getPreViewMailBody(Object info1, Object info2) throws Exception {
		return mailBody.getPreViewMailBody(info1, info2, this.scheduleInfo);
	}

//kdy0831 start
	
	public String getSpoolPrev(Object info1, Object info2) throws Exception {
		return mailBody.getSpoolPrev(info1, info2, this.scheduleInfo);
	}
	
	//kdy0831 end
	/**
	 * Getter for property RCPT_PATTERN.
	 * 
	 * @return Value of property RCPT_PATTERN. public Short getRCPT_PATTERN() {
	 *         return
	 *         RCPT_PATTERN==null?eMsTypes.SHORT_SINGLE_RCPT:RCPT_PATTERN; }
	 */

	/**
	 * Setter for property RCPT_PATTERN.
	 * 
	 * @param RCPT_PATTERN
	 *            New value of property RCPT_PATTERN. public void
	 *            setRCPT_PATTERN(Short RCPT_PATTERN) { this.RCPT_PATTERN =
	 *            RCPT_PATTERN; }
	 * 
	 * public void setRCPT_PATTERN(short RCPT_PATTERN) { this.RCPT_PATTERN = new
	 * Short( RCPT_PATTERN ); }
	 */

	/*
	 * public synchronized Map getHEADER_KEY_MAP( String delim ){ if(
	 * mappingHeader == null || mappingHeader.length() < 10 ) return null;
	 * 
	 * if( HEADER_KEY_MAP == null ){ HEADER_KEY_MAP = SpoolHeaderParser.parse(
	 * mappingHeader , delim ); }
	 * 
	 * return HEADER_KEY_MAP; }
	 */

	public String getSPOOL_DELIMIT() {
		if( SPOOL_DELIMIT == null ) {
			SPOOL_DELIMIT = scheduleInfo.getProperty("DELIMIT", "|");
		}

		return SPOOL_DELIMIT;
	}

	public ContentInfo getClone() throws Exception {
		return (ContentInfo) clone();
	}

	public void setContentInfoPath(String cInfoPath) {
		this.contentInfoPath = cInfoPath;
	}

	public String getContentInfoPath() {
		return this.contentInfoPath;
	}
}
