/*
 * @(#)SmsBasicContentPD.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mercury.contents.auto.producer;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import mercury.contents.common.parser.LinkParser;
import mercury.contents.common.producer.CommonContentPD;
import mercury.contents.common.util.LinkContent;
import mercury.contents.common.util.MappingImgStripper;
import mercury.contents.common.util.TrackingInfoConvertor;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.util.Cal;
import pluto.util.StringUtil;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class SmsBasicContentPD extends CommonContentPD {

	protected static String			CONTENT_STORE_DIRECTORY	= null;

	protected static String			TR_URL					= null;

	protected static String			QUERY_INSERT_LINK_INFO	= null;

	static {
		try {
			QUERY_INSERT_LINK_INFO = SqlManager.getQuery("COMMON", "QUERY_INSERT_LINK_INFO");

			CONTENT_STORE_DIRECTORY = eMsSystem.getProperty("content.store.directory");
			TR_URL = eMsSystem.getProperty("tracking.url").concat("?${enc_mid}&${enc_s_type}&");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	protected String				INSTANCE_TR_URL			= null;

	/** Creates a new instance of SmsBasicContentPD */
	public SmsBasicContentPD() {
		super();
	}

	protected void initProperty(Properties prop) throws Exception {
		super.initProperty(prop);

		this.POST_ID = this.SCHEDULE_INFO.getProperty("POST_ID");

		setName(this.POST_ID + " 's SmsBasicContentPD");

		this.WORK_FILE_ID = this.POST_ID + "_real_" + Cal.getSerialDate();

		this.TMP_BUFFER.setLength(0);
		this.TMP_BUFFER.append(TR_URL);
		this.TMP_BUFFER.append(TrackingInfoConvertor.enc_LIST_TABLE(this.SCHEDULE_INFO.getProperty("LIST_TABLE")));
		this.TMP_BUFFER.append("&");
		this.TMP_BUFFER.append(TrackingInfoConvertor.enc_MAIL_ID(this.POST_ID));
		this.TMP_BUFFER.append("&");
		this.TMP_BUFFER.append(TrackingInfoConvertor.enc_SERVER_ID(this.SCHEDULE_INFO.getProperty("SERVER_ID")));
		this.TMP_BUFFER.append("&");
		this.TMP_BUFFER.append(TrackingInfoConvertor.enc_CLOSE(this.SCHEDULE_INFO.getProperty("QUE_CLOSE_DATE", Cal.getAddDayDate(7))));

		this.INSTANCE_TR_URL = this.TMP_BUFFER.toString();

		// set Attach File Info Select Query ..
		this.instance_ATTACH_CONTENT_SELECT_QUERY = StringUtil.ConvertString(SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_ATTACH_CONTENT"), this.SCHEDULE_INFO, "${", "}");
	}

	protected String execute_ContentProcess(String source) throws Exception {
		if (log.isDebugEnabled()) {
			log.debug("src=>", source);
		}
		String strip_img_source = MappingImgStripper.process(source);
		if (log.isDebugEnabled()) {
			log.debug("result=>", source);
		}
		/**
		 * 트래킹 유무에 따라 파싱 아니면 그냥 저장
		 */
		if( this.SCHEDULE_INFO.getProperty("TRACKING_YN", "N").equalsIgnoreCase("Y")
				&& this.SCHEDULE_INFO.getProperty("CONTENT_TYPE", "T").equalsIgnoreCase("H") ) {
			// 트래킹을 할경우에는 트래킹 파싱 로직을 호출한다.
			// 컨텐트를 저장하는 로직은 execute_ContentTrackingParsing 안에서 호출을 한다.
			// 링크를 파싱할때 임시로 사용하는 버퍼를 만들어서 보내는 로직으로 변경 2004.11.02
			StringBuffer buffer = null;
			try {
				buffer = new StringBuffer(1024);
				return execute_ContentTrackingParsing(strip_img_source, buffer);
			}
			finally {
				buffer = null;
			}
		}
		
		// 트래킹 파싱이 없을 경우 그냥 컨텐트를 저장한다.
		return strip_img_source;
	}

	protected String getMappingHeader() throws Exception {
		return this.SCHEDULE_INFO.getProperty("MAPPINGHEADER", " ");
	}

	
	
	/*
	 * 
	 * mms 첨부 처리 --- 실첨부 x , 파일 url만 SCHEDULE_INFO 에 담는다........
	 * @see mercury.contents.common.producer.CommonContentPD#execute_createContentInfo()
	 */
	
	protected void execute_createContentInfo() throws Exception {
		String send_type = this.SCHEDULE_INFO.getProperty("SEND_TYPE");
		String send_state = this.SCHEDULE_INFO.getProperty("SEND_STATE");
		String mail_enc_type = this.SCHEDULE_INFO.getProperty("MAIL_ENC_TYPE","");
		String header_mime_char_set = this.SCHEDULE_INFO.getProperty("HEADER_MIME_CHAR_SET", eMsLocale.HEADER_MIME_CHAR_SET);
		/*
		 * 엔코딩 타입을 스케즐 쿼리에서 받아올 수 있도록 수정.
		 * 스케즐 쿼리에 정의된 것이 없다면 환경파일에서 가져옴
		 */
		Short nMailEncType = mail_enc_type.equals("")?new Short(eMsLocale.MAIL_ENC_TYPE):new Short( mail_enc_type );

		// BodyParser Instance 준비
		BodyParser __BODY_PARSER__ = (BodyParser) InstanceFactory.getInstance(send_type, send_state, eMsTypes.BODYPARSER_INSTANCE);
		__BODY_PARSER__.setContents(this.SCHEDULE_INFO.getProperty("CONTENT"));

		// Message Instance준비
		Message myMessage = (Message) InstanceFactory.getInstance(send_type, send_state, eMsTypes.MESSAGE_INSTANCE);

		// 메세지에 파서 지정
		myMessage.setContent(__BODY_PARSER__);

		// 컨텐트 타입 설정
		if( this.SCHEDULE_INFO.getProperty("CONTENT_TYPE", "H").equals("H") ) {
			myMessage.setContentType(new Short(eMsTypes.TEXT_HTML));
		}
		else {
			myMessage.setContentType(new Short(eMsTypes.TEXT_PLAIN));
		}

		// 케릭터 셋 설정

		myMessage.setCharSet(header_mime_char_set.equals("")?eMsLocale.MAIL_MIME_CHAR_SET:header_mime_char_set);
		
		// 인코딩 타입 설정
		myMessage.setContentEncoding(nMailEncType);

		// Message ID 세팅
		myMessage.setMessageID(this.POST_ID);

		// MailBody Instance 생성
		MailBody __MAILBODY__ = (MailBody) InstanceFactory.getInstance(send_type, send_state, eMsTypes.MAILBODY_INSTANCE);

		// 보내는 사람 정보
		__MAILBODY__.setFromEmail(this.SCHEDULE_INFO.getProperty("FROM_NUMBER"));
		__MAILBODY__.setFromName(this.SCHEDULE_INFO.getProperty("FROM_NAME"));

		// 받는 사람 정보 세팅
		// 원투원일 경우에는 매핑도 넣을 수 있다. 지금은 웹에서 지원이 안되기 때문에 근야 디폴트 값으로 박아 넣는다.
		//__MAILBODY__.setToEmail(this.SCHEDULE_INFO.getProperty("TO_EMAIL", "${EMS_M_EMAIL}"));
		__MAILBODY__.setToEmail(this.SCHEDULE_INFO.getProperty("TO_EMAIL", "${TMS_M_TOKEN}"));
		__MAILBODY__.setToName(this.SCHEDULE_INFO.getProperty("TO_NAME", "${TMS_M_NAME}"));

		// Subject Setting
		__MAILBODY__.setSubject(this.SCHEDULE_INFO.getProperty("SUBJECT"));

		// Default Header Info Setting
		__MAILBODY__.setEtcHeader(eMsLocale.DEFAULT_HEADER);

		// set Message to MailBody
		__MAILBODY__.setMessage(myMessage);

		// 첨부파일을 점검하여 첨부 Message도 지정한다.
		if( eMsLocale.ATTACH_LOGIC_EXECUTE_FLAG && this.instance_ATTACH_CONTENT_SELECT_QUERY != null ) {
			// 디비 연결 초기화
			refreshDBConnection();

			eMsStatement stmt = null;
			eMsResultSet rs = null;

			try {
				stmt = this.EMS_CONNECTION.createStatement();

				// execute Attach File Info Query -> 쿼리를 바로 실행하기 때문에 매핑이 완료된
				// 쿼리여야한다.
				rs = stmt.executeQuery(this.instance_ATTACH_CONTENT_SELECT_QUERY);

				Properties prop = new Properties();
				
				
				//MMS 이미지 파일 카운트~~~
				int file_cnt = 0;
				
				while (rs.next()) {
					
					++file_cnt;
					
					// ResultSet to Hash..
					rs.putToMap(prop, false);

					//String sAttachState = prop.getProperty("ATTACH_TYPE", "O");
					String aAttachFileUrl = prop.getProperty("ATTACH_FILE");
					String aAttachFileName = prop.getProperty("ATTACH_NAME");
					String aAttachFileId = prop.getProperty("ATTACH_FILE_ID", "");
					
					this.SCHEDULE_INFO.setProperty("MMS_ATTACH_PATH_"+file_cnt,aAttachFileUrl);
					this.SCHEDULE_INFO.setProperty("MMS_ATTACH_FILE_ID_"+file_cnt,aAttachFileId);
					
				}
				
				
				this.SCHEDULE_INFO.setProperty("MMS_ATTACH_CNT",Integer.toString(file_cnt));
			}
			finally {
				this.EMS_CONNECTION.recycleStatement(stmt);
				if( rs != null ) {
					try {
						rs.close();
					}
					catch(Exception ignore) {
						// ignore
					}
				}
			}
		}

		// 첨부파일이 있을 경우에 메세지를 추가 지정한다.

		/* 발송할 사항에 대해서 ContentInfoManager에 등록을 한다. 그래야지 재발송이 가능하니깐.. */
		
		this.SEND_CONTENT_INFO = new ContentInfo();
		this.SEND_CONTENT_INFO.setID(this.POST_ID);
		this.SEND_CONTENT_INFO.setScheduleInfo(this.SCHEDULE_INFO);
		this.SEND_CONTENT_INFO.setMappingHeader(this.getMappingHeader());
		this.SEND_CONTENT_INFO.setMailBody(__MAILBODY__);
		this.SEND_CONTENT_INFO.setReturnPath(this.SCHEDULE_INFO.getProperty("RETURN_PATH"));
		this.SEND_CONTENT_INFO.setSendType(this.SCHEDULE_INFO.getProperty("SEND_TYPE"));
	}
	
	
	
	/**
	 * 트래킹을 할경우 컨텐트를 파싱하여 링크 트래킹 정보를 삽입하여 결과를 반환한다. <br>
	 * execute_ContentProcess Method 에서 호출 된다.
	 * 
	 * @param SCHEDULE_INFO
	 *            발송 스케쥴 정보
	 * @param source
	 *            파싱할 Content String
	 * @throws Exception
	 *             에러
	 */
	protected String execute_ContentTrackingParsing(String source, StringBuffer tmpBuffer) throws Exception {
		String __FINAL_OUTPUT__ = source;

		/**
		 * 클릭을 잡는다고 마킹이 되어 있다면.
		 */
		if( this.SCHEDULE_INFO.getProperty("CLICK_YN", "N").equalsIgnoreCase("Y") ) {
			LinkParser __LINK_PARSER__ = new LinkParser();
			__LINK_PARSER__.parse(__FINAL_OUTPUT__);

			LinkContent __LINK_CONTENT__ = null;
			Object __LINK_ELEMENT__ = null;

			this.TMP_BUFFER.setLength(0);

			for (Iterator __ITERATOR__ = __LINK_PARSER__.iterator(); __ITERATOR__.hasNext();) {
				__LINK_ELEMENT__ = __ITERATOR__.next();

				/**
				 * 트래킹을 잡을 것은 변환하여 append하고 일반 content나 트래킹하지 않을 것은 append하고
				 * remove한다. 그래야 db로 업데이트가 되지 않는다.
				 */
				if( __LINK_ELEMENT__ instanceof LinkContent ) {
					__LINK_CONTENT__ = (LinkContent) __LINK_ELEMENT__;

					if( __LINK_CONTENT__.getUrl().startsWith("http") ) {
						tmpBuffer.setLength(0);
						tmpBuffer.append(INSTANCE_TR_URL);
						tmpBuffer.append("&");
						tmpBuffer.append(TrackingInfoConvertor.enc_KIND("C"));
						tmpBuffer.append("&");
						tmpBuffer.append(TrackingInfoConvertor.enc_CID(__LINK_CONTENT__.getID()));
						tmpBuffer.append("&URL=");
						tmpBuffer.append(__LINK_CONTENT__.getUrl());
						this.TMP_BUFFER.append(__LINK_CONTENT__.getLinkConvert(tmpBuffer.toString()));
					}
					else {
						this.TMP_BUFFER.append(__LINK_ELEMENT__.toString());
						__ITERATOR__.remove();
					}
				}
				else {
					this.TMP_BUFFER.append(__LINK_ELEMENT__.toString());
					__ITERATOR__.remove();
				}
			}

			__FINAL_OUTPUT__ = this.TMP_BUFFER.toString();

			StroreTrackingInfoToDB(__LINK_PARSER__);

			/**
			 * 파싱한 정보는 삭제한다.
			 */
			__LINK_PARSER__.clear();
		}

		/**
		 * 오픈테그를 append해야한다.
		 */
		String head = null;
		String tail = null;

		int idxBodyEnd = __FINAL_OUTPUT__.toLowerCase().indexOf("</body");

		if( idxBodyEnd > 0 ) {
			head = __FINAL_OUTPUT__.substring(0, idxBodyEnd);
			tail = __FINAL_OUTPUT__.substring(idxBodyEnd);
		}
		else {
			head = __FINAL_OUTPUT__;
			tail = "";
		}

		this.TMP_BUFFER.setLength(0);
		this.TMP_BUFFER.append(head);
		this.TMP_BUFFER.append("<div style=\"display:none\">");
		this.TMP_BUFFER.append("<IMG width=0 height=0 src=\"");
		this.TMP_BUFFER.append(INSTANCE_TR_URL);
		this.TMP_BUFFER.append("&");
		this.TMP_BUFFER.append(TrackingInfoConvertor.enc_KIND("O"));
		this.TMP_BUFFER.append("\">");
		this.TMP_BUFFER.append("</div>");
		this.TMP_BUFFER.append(tail);

		return this.TMP_BUFFER.toString();
	}

	//protected DefaultMappingGenerator getDefaultMappingGenerator() throws
	// Exception {
	//	return (DefaultMappingGenerator)(
	// COMMON_DEFAULT_MAPPING_GENERATOR.newInstance() );
	//}

	protected void StroreTrackingInfoToDB(List __LINK_INFOS__) throws Exception {
		// 디비 연결을 한번 갱신한다.
		this.refreshDBConnection();

		eMsPreparedStatement __PS_INSERT_LINK_INFO__ = null;

		try {
			/* 파싱된 링크정보를 데이터 베이스에 반영을 한다. */
			__PS_INSERT_LINK_INFO__ = new eMsPreparedStatement(QUERY_INSERT_LINK_INFO, "${", "}");
			__PS_INSERT_LINK_INFO__.connectTo(this.EMS_CONNECTION);

			LinkContent __LINK_CONTENT__ = null;

			String __TMP_CONTENT__ = null;

			Properties __LINK_UPDATE_PROPERTIES__ = new Properties();

			/**
			 * 링크정보 업데이트 쿼리에서 사용할때 전체 스케쥴 정보를 넣어준다. 그래야 업데이트가 가능하니까...
			 */
			__LINK_UPDATE_PROPERTIES__.putAll(this.SCHEDULE_INFO);

			for (Iterator __ITERATOR__ = __LINK_INFOS__.iterator(); __ITERATOR__.hasNext();) {
				__LINK_CONTENT__ = (LinkContent) __ITERATOR__.next();

				__TMP_CONTENT__ = __LINK_CONTENT__.getContent();

				if( __TMP_CONTENT__.length() > eMsLocale.LINK_LENGTH_LIMIT ) {
					__TMP_CONTENT__ = __TMP_CONTENT__.substring(0, eMsLocale.LINK_LENGTH_LIMIT);
				}

				__LINK_UPDATE_PROPERTIES__.setProperty("CLICK_ID", __LINK_CONTENT__.getID());
				__LINK_UPDATE_PROPERTIES__.setProperty("CLICK_DESC", __TMP_CONTENT__);
				__LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL", __LINK_CONTENT__.getUrl());

				if (log.isDebugEnabled()) 
					log.debug("ID: " + __LINK_CONTENT__.getID());
				if (log.isDebugEnabled()) 
					log.debug("Content: " + __TMP_CONTENT__);
				if (log.isDebugEnabled()) 
					log.debug("URL:  " + __LINK_CONTENT__.getUrl());

				try {
					__PS_INSERT_LINK_INFO__.executeUpdate(__LINK_UPDATE_PROPERTIES__);
				}
				catch(SQLException e) {
					log.error(getName() + e);
				}
			}
		}
		catch(Exception e) {
			throw e;
		}
		catch(Throwable e) {
			throw new Exception(e.toString());
		}
		finally {
			try {
				__PS_INSERT_LINK_INFO__.close();
			}
			catch(Exception e) {
			}
		}
	}

}
