/*
 * @(#)RealtimeContentPD.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mercury.contents.auto.producer;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class RealtimeContentPD extends BasicContentPD {

	protected static String QUERY_SELECT_SCHEDULE_INFO = null;
	
	static {
		try{
			QUERY_SELECT_SCHEDULE_INFO = SqlManager.getQuery("COMMON","QUERY_SELECT_SCHEDULE_INFO");
		
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	protected String INSTANCE_QUERY_SELECT_SCHEDULE_INFO = null;
	
	/** Creates a new instance of RealtimeContentPD */
	public RealtimeContentPD() {
		super();
		INSTANCE_QUERY_SELECT_SCHEDULE_INFO = QUERY_SELECT_SCHEDULE_INFO;
	}
	
	protected void initProperty( Properties prop  ) throws Exception {
		this.init_property( prop );
		
		super.initProperty( prop );
		
		setName( this.POST_ID + " 's RealtimeContentPD" );
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	final void init_property( Properties prop ) throws Exception {
		this.refreshDBConnection();
		
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet RS_SELECTED_SCHEDULE_INFO = null;
		
		try{
			__EMS_EXEC_STATEMENT__ = this.EMS_CONNECTION.createStatement();
			
			// 버퍼로 쿼리전환 modify 2004.11.02
			this.TMP_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_BUFFER , INSTANCE_QUERY_SELECT_SCHEDULE_INFO , prop , "${" , "}" , true , false );
			
			//log.debug("QUERY : " + this.TMP_BUFFER.toString());
			
			//RS_SELECTED_SCHEDULE_INFO = __EMS_EXEC_STATEMENT__.executeQuery( INSTANCE_QUERY_SELECT_SCHEDULE_INFO , prop , "${" , "}" );
			RS_SELECTED_SCHEDULE_INFO = __EMS_EXEC_STATEMENT__.executeQuery( this.TMP_BUFFER.toString() );
			
			if( RS_SELECTED_SCHEDULE_INFO.next() ){
				RS_SELECTED_SCHEDULE_INFO.putToMap( prop , false );
			}
			else{
				throw new RuntimeException( "NO SCHEDULE INFO=>".concat( prop.toString() ) );
			}
			
			if ( "SM".equals(prop.getProperty("CHANNEL_TYPE")) ||  "KA".equals(prop.getProperty("CHANNEL_TYPE"))) {
			    try {
				     
				    eMsResultSet RS_SELECTED_ATTACH_INFO = null;
				     
				    String querySelectAttachContent = StringUtil.ConvertString(SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_ATTACH_CONTENT"), prop, "${", "}");
				    RS_SELECTED_ATTACH_INFO = __EMS_EXEC_STATEMENT__.executeQuery( querySelectAttachContent );
				 
				    Properties tmpProp = new Properties();
				     //MMS 이미지 파일 카운트
				    int file_cnt = 0;
				    while (RS_SELECTED_ATTACH_INFO.next()) {
				    	++file_cnt;
				        // ResultSet to Hash..
				    	RS_SELECTED_ATTACH_INFO.putToMap(tmpProp, false);
				    	String aAttachFileUrl = tmpProp.getProperty("ATTACH_FILE");
				    	prop.setProperty("MMS_ATTACH_PATH_" + file_cnt, aAttachFileUrl);
				     }
				     
				     prop.setProperty("MMS_ATTACH_CNT",Integer.toString(file_cnt));
				     
			     } catch (Exception e) {
			    	 log.error("ERROR MMS ATTACH FILE", e);
			     }
			 }

		}
		catch( Throwable e ){
			throw new Exception( e.toString() );
		}
		finally{
			this.EMS_CONNECTION.recycleStatement( __EMS_EXEC_STATEMENT__ );
		}
	}
}

