package mars.tracking.updator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import moon.logprocess.db.PreparedStatementGroup;
import moon.logprocess.db.TrackingPreparedStatementGroup;
import moon.logprocess.db.TrackingPreparedStatementGroupMobile;
import pluto.common.bean.PlanBean;
import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.log.Log;
import pluto.log.LogUpdator;
import pluto.util.StringUtil;
/**
 *
 */
@Slf4j
public class TargetSecondCheckSwitchUpdatorPps extends LogUpdatorImpl { 
	
	
	protected String QUERY_FIRST_CHECK = null;
	protected String QUERY_SECOND_CHECK = null;
	
	protected List QUERY_UPDATE_FIRST_OK_COMMON_INFO = null;
	protected List QUERY_UPDATE_FIRST_OK_LIST_INFO = null;
	
	protected List QUERY_UPDATE_SECOND_OK_COMMON_INFO = null;
	protected List QUERY_UPDATE_SECOND_OK_LIST_INFO = null;
	
	protected List QUERY_UPDATE_FINAL_COMMON_INFO = null;
	protected List QUERY_UPDATE_FINAL_LIST_INFO = null;
	
	protected String QUERY_UPDATE_MEMBER_INFO = null;
	protected List QUERY_INSERT_MEMBER_INFO = null;
	
	
	//by charls open point
	protected List QUERY_UPDATE_FIRST_OK_LIST_OPOINT_INFO = null;
	
	
	
	
	
	protected String QUERY_FIRST_CHECK_MOBILE = null;
	protected String QUERY_SECOND_CHECK_MOBILE = null;
	
	protected List QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE = null;
	protected List QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE = null;
	
	protected List QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE = null;
	protected List QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE = null;
	
	protected List QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE = null;
	protected List QUERY_UPDATE_FINAL_LIST_INFO_MOBILE = null;
	
	
	//flow plan data -------------------------------------------------------------------
	private static eMsPreparedStatement PPS_SELECT_FLOW_DATA = null;
	private static eMsPreparedStatement PPS_INSERT_FLOW_DATA = null;
	
	private static String QUERY_SELECT_PLAN_INFO             = SqlManager.getQuery("FLOW_PLAN", "QUERY_SELECT_PLAN_INFO");
	private static String QUERY_INSERT_FLOW_DATA             = SqlManager.getQuery("FLOW_PLAN", "QUERY_INSERT_FLOW_DATA");
	//----------------------------------------------------------------------------------
	
	
	
	/** Creates a new instance of TargetSecondCheckSwitchUpdatorPps */
	public TargetSecondCheckSwitchUpdatorPps() {
		super();
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object obj) throws Exception {
		
		String msg = "";
		Map prop = ( Map )obj;
		
		String POST_ID  = (String)prop.get( LOG_MAIL_ID );
		String __SEND_TYPE__  = (String)prop.get( LOG_SEND_TYPE );
		String __KIND__ 	  = (String)prop.get( LOG_TR_KIND );
		String __LIST_TABLE__ = (String)prop.get( LOG_LIST_TABLE );
		String __MOBILE_TYPE__ = "";
		//컨텐츠 등록 시 라인 변경없이 한줄로 작성하여 발송한 경우 수신서버에서 임의로 라인을 내리는 경우 list table 정보에 ?? 등의 개행문자 삽입되어 건수 집계에 문제가 발생
		if(__LIST_TABLE__ == null || __LIST_TABLE__.length() != 17){
			if(__SEND_TYPE__.equals("CAMP")|| __SEND_TYPE__.equals("MASS")){
				__LIST_TABLE__ = "TMS_CAMP_SEND_LIST_"+POST_ID.substring(4, 6);
				prop.put(LOG_LIST_TABLE, __LIST_TABLE__);
			}else{
				
			}
		}
		
		String key = __SEND_TYPE__+"_"+__KIND__+"_"+__LIST_TABLE__;
		
		log.info("[key]"+key+"[mobile_code]"+((Properties)prop).getProperty("MOBILE_CODE","NONE"));  
		
		boolean firstFlag = false;
		
		if(prop.containsKey("MOBILE_CODE")){
			
			key = key + "MOBILE";
			//MOBILE TYPE 으로 업데이트
			if(prop.get("MOBILE_CODE").equals("Android")){
				__MOBILE_TYPE__ = "ANDROID";
				prop.put("OPEN_CNT_ANDROID", "1");
				prop.put("CLICK_CNT_ANDROID", "1");
				prop.put("OPEN_CNT_IOS", "0");
				prop.put("CLICK_CNT_IOS", "0");
			}else if(prop.get("MOBILE_CODE").equals("iPhone") || prop.get("MOBILE_CODE").equals("iPod") || prop.get("MOBILE_CODE").equals("iPad") || prop.get("MOBILE_CODE").equals("Macintosh")){
				__MOBILE_TYPE__ = "IOS";
				prop.put("OPEN_CNT_ANDROID", "0");
				prop.put("CLICK_CNT_ANDROID", "0");
				prop.put("OPEN_CNT_IOS", "1");
				prop.put("CLICK_CNT_IOS", "1");
			}else{
				__MOBILE_TYPE__ = "ETC";
				prop.put("OPEN_CNT_ANDROID", "0");
				prop.put("CLICK_CNT_ANDROID", "0");
				prop.put("OPEN_CNT_IOS", "0");
				prop.put("CLICK_CNT_IOS", "0");
			}
			//get ppsGrp
			TrackingPreparedStatementGroupMobile ppsGrpMobile = (TrackingPreparedStatementGroupMobile)PreparedStatementGroup.PPS_GRP_MAP.get(key);
			if(ppsGrpMobile == null){//없다면 초기화 하고 map에 세팅한다.
				ppsGrpMobile = setPpsGrpMobile();
				ppsGrpMobile.setGRP_NAME(key);
				ppsGrpMobile.create(EMS_CONNECTION,__LIST_TABLE__,__MOBILE_TYPE__);
				PreparedStatementGroup.PPS_GRP_MAP.put(key,ppsGrpMobile);
			}
			
			// ppsGrp 사용 =====================================================
			List ppslist = null;
			eMsPreparedStatement pps = null;
			
			// second 필요성을 못 느낌... final로만 처리되도록 주석 처리
			
			int count = ppsGrpMobile.PPS_FIRST_CHECK_MOBILE.executeUpdate(prop);
			
			if( count > 0 ){
				//executeUpdateList( QUERY_UPDATE_FIRST_OK_COMMON_INFO , log );			
				ppslist = ppsGrpMobile.LIST_UPDATE_FIRST_OK_COMMON_INFO_MOBILE;
				if(ppslist != null){
					for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
						pps= (eMsPreparedStatement)iter.next();
						pps.executeUpdate(prop);
					}			
				}
				ppslist = ppsGrpMobile.LIST_UPDATE_FIRST_OK_LIST_INFO_MOBILE;
				if(ppslist != null){
					for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
						pps= (eMsPreparedStatement)iter.next();
						pps.executeUpdate(prop);
					}
				}
				
				ppslist = ppsGrpMobile.LIST_UPDATE_FIRST_OK_LIST_OPOINT_INFO;
				if(ppslist != null){
					for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
						pps= (eMsPreparedStatement)iter.next();
						pps.executeUpdate(prop);
					}
				}
				
				//A2_MEMBERS 테이블에 정보를 업데이트 한다.
				// 대량만 설정을 했다.
				if(QUERY_UPDATE_MEMBER_INFO != null){				
					int mem_count = ppsGrpMobile.PPS_UPDATE_MEMBER_INFO.executeUpdate(prop);
					// 업데이트 건수가 없으면, 추가한다.
					if( mem_count <= 0){
						ppslist = ppsGrpMobile.LIST_INSERT_MEMBER_INFO;
						if(ppslist != null){
							for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
								pps= (eMsPreparedStatement)iter.next();
								pps.executeUpdate(prop);
							}
						}
					}
				}
				firstFlag = true;
				msg = "MOBILE-1st OK";
			}else{
			
				/*count = ppsGrpMobile.PPS_SECOND_CHECK_MOBILE.executeUpdate(prop);
				
				if( count > 0 ){
					ppslist = ppsGrpMobile.LIST_UPDATE_SECOND_OK_COMMON_INFO_MOBILE;
					if(ppslist != null){
						for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
							pps= (eMsPreparedStatement)iter.next();
							pps.executeUpdate(prop);
						}
					}
					ppslist = ppsGrpMobile.LIST_UPDATE_SECOND_OK_LIST_INFO_MOBILE;
					if(ppslist != null){
						for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
							pps= (eMsPreparedStatement)iter.next();
							pps.executeUpdate(prop);
						}
					}
					// A2_MEMBERS 테이블에 정보를 업데이트 한다.
					// 대량만 설정을 했다.
					if(QUERY_UPDATE_MEMBER_INFO != null){
						int mem_count = ppsGrpMobile.PPS_UPDATE_MEMBER_INFO.executeUpdate(prop);
					}
					msg = "MOBILE-2nd OK";
				}else{*/
				
					/**업데이트 할 쿼리들의 Iterator
					 */
					//executeUpdateList( QUERY_UPDATE_FINAL_COMMON_INFO , log );
					ppslist = ppsGrpMobile.LIST_UPDATE_FINAL_COMMON_INFO_MOBILE;
					if(ppslist != null){
						for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
							pps= (eMsPreparedStatement)iter.next();
							pps.executeUpdate(prop);
						}
					}
					//executeUpdateList( QUERY_UPDATE_FINAL_LIST_INFO , log );
					ppslist = ppsGrpMobile.LIST_UPDATE_FINAL_LIST_INFO_MOBILE;
					if(ppslist != null){
						for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
							pps= (eMsPreparedStatement)iter.next();
							pps.executeUpdate(prop);
						}
					}
					//A2_MEMBERS 테이블에 정보를 업데이트 한다.
					// 대량만 설정을 했다.
					// 현재 사용되지 않는 쿼리이긴 하지만, 추추 발송 결과를 별도 테이블에 입력해야하는 경우 활용 할 수 있어 남겨 둠.
					// 쿼리만 트래킹 엔진쿼리에 작성하면 구동 됨.
					if(QUERY_UPDATE_MEMBER_INFO != null){
						int mem_count = ppsGrpMobile.PPS_UPDATE_MEMBER_INFO.executeUpdate(prop);
					}
					msg = "MOBILE-final OK";
				//}
			}
			
		}else{
			
			//get ppsGrp
			TrackingPreparedStatementGroup ppsGrp = (TrackingPreparedStatementGroup)PreparedStatementGroup.PPS_GRP_MAP.get(key);
			if(ppsGrp == null){//없다면 초기화 하고 map에 세팅한다.
				ppsGrp = setPpsGrp();
				ppsGrp.setGRP_NAME(key);
				ppsGrp.create(EMS_CONNECTION,__LIST_TABLE__,__MOBILE_TYPE__);
				PreparedStatementGroup.PPS_GRP_MAP.put(key,ppsGrp);
			}
			
			// ppsGrp 사용 =====================================================
			List ppslist = null;
			eMsPreparedStatement pps = null;
			
					
			int count = ppsGrp.PPS_FIRST_CHECK.executeUpdate(prop);
			
			if( count > 0 ){
				//executeUpdateList( QUERY_UPDATE_FIRST_OK_COMMON_INFO , log );			
				ppslist = ppsGrp.LIST_UPDATE_FIRST_OK_COMMON_INFO;
				if(ppslist != null){
					for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
						pps= (eMsPreparedStatement)iter.next();
						pps.executeUpdate(prop);
					}			
				}
				ppslist = ppsGrp.LIST_UPDATE_FIRST_OK_LIST_INFO;
				if(ppslist != null){
					for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
						pps= (eMsPreparedStatement)iter.next();
						pps.executeUpdate(prop);
					}
				}
				
				ppslist = ppsGrp.LIST_UPDATE_FIRST_OK_LIST_OPOINT_INFO;
				if(ppslist != null){
					for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
						pps= (eMsPreparedStatement)iter.next();
						pps.executeUpdate(prop);
					}
				}
				
				//A2_MEMBERS 테이블에 정보를 업데이트 한다.
				// 대량만 설정을 했다. 
				if(QUERY_UPDATE_MEMBER_INFO != null){				
					int mem_count = ppsGrp.PPS_UPDATE_MEMBER_INFO.executeUpdate(prop);
					// 업데이트 건수가 없으면, 추가한다.
					if( mem_count <= 0){
						ppslist = ppsGrp.LIST_INSERT_MEMBER_INFO;
						if(ppslist != null){
							for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
								pps= (eMsPreparedStatement)iter.next();
								pps.executeUpdate(prop);
							}
						}
					}
				}
				
				firstFlag = true;
				msg = "PC-1st OK";
			}else{
			
				/*count = ppsGrp.PPS_SECOND_CHECK.executeUpdate(prop);
				
				if( count > 0 ){
					ppslist = ppsGrp.LIST_UPDATE_SECOND_OK_COMMON_INFO;
					if(ppslist != null){
						for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
							pps= (eMsPreparedStatement)iter.next();
							pps.executeUpdate(prop);
						}
					}
					ppslist = ppsGrp.LIST_UPDATE_SECOND_OK_LIST_INFO;
					if(ppslist != null){
						for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
							pps= (eMsPreparedStatement)iter.next();
							pps.executeUpdate(prop);
						}
					}
					// A2_MEMBERS 테이블에 정보를 업데이트 한다.
					// 대량만 설정을 했다.
					if(QUERY_UPDATE_MEMBER_INFO != null){
						int mem_count = ppsGrp.PPS_UPDATE_MEMBER_INFO.executeUpdate(prop);
					}
					msg = "PC-2nd OK";
					
				}else{*/
				
					/**업데이트 할 쿼리들의 Iterator
					 */
					//executeUpdateList( QUERY_UPDATE_FINAL_COMMON_INFO , log );
					ppslist = ppsGrp.LIST_UPDATE_FINAL_COMMON_INFO;
					if(ppslist != null){
						for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
							pps= (eMsPreparedStatement)iter.next();
							pps.executeUpdate(prop);
						}
					}
					//executeUpdateList( QUERY_UPDATE_FINAL_LIST_INFO , log );
					ppslist = ppsGrp.LIST_UPDATE_FINAL_LIST_INFO;
					if(ppslist != null){
						for( Iterator iter = ppslist.iterator() ;  iter.hasNext() ; ){
							pps= (eMsPreparedStatement)iter.next();
							pps.executeUpdate(prop);
						}
					}
					//A2_MEMBERS 테이블에 정보를 업데이트 한다.
					// 대량만 설정을 했다.
					if(QUERY_UPDATE_MEMBER_INFO != null){
						int mem_count = ppsGrp.PPS_UPDATE_MEMBER_INFO.executeUpdate(prop);
					}
					msg = "PC-final OK";
				//}
			
			}//mobile if end
		
			
		}
		
		if(log.isDebugEnabled()){
			log.debug("[SEND_TYPE]"+__SEND_TYPE__+"[firstFlag]"+firstFlag);
		}
		
		// ### auto flow plan ###
		if(firstFlag && __SEND_TYPE__.indexOf("AUTO") > -1){ //오픈과 클릭은 최초 한번만 진행한다.
			String flowResult = insertFlowPlanData( (Properties)prop );
			if(log.isDebugEnabled()){
				log.debug("[flowResult]"+flowResult);
			}
		}else{
			if(log.isDebugEnabled()){
				log.debug("[no flow action] msg :"+msg);
			}
		}
		// ######################
		
		return msg;
		
	}
	
	/*
	[table : PLAN_ACT_LIST]
	
	create table PLAN_ACT_LIST(
			SRC_WORKDAY       varchar(8) NOT NULL, 
			SRC_SEQNO         decimal(9,0) NOT NULL,
			SRC_MEMBER_ID     varchar(20) NOT NULL,
			SRC_MEMBER_ID_SEQ varchar(10) NOT NULL,
			SRC_LIST_TABLE    varchar(100) DEFAULT NULL,
			MSG_TYPE          varchar(3) NOT NULL,
			MSG_TYPE_SEQ      varchar(3) NOT NULL,
			PLAN_STATUS       varchar(2) NOT NULL,
			PLAN_DAY          varchar(5) ,
			PLAN_HOUR         varchar(10) ,
			T_DATE            datetime,  -- 로그 일시
			ACT_DATE          datetime,  -- 작업할 일시
			REG_DATE          datetime,  -- 등록일시
			SEND_FLAG_DATE    datetime   -- 발송 완료시 update
	)
	*/
	/**
	 * 
	 * @param target
	 * @return
	 * @throws Exception 
	 */
	protected String insertFlowPlanData(Object target) throws Exception{
		Properties propLogData = ( Properties )target;
		
		String trKind 	 = propLogData.getProperty( Log.LOG_TR_KIND );
		String postId    = propLogData.getProperty( Log.LOG_MAIL_ID );
		
//		String workday   = propLogData.getProperty( Log.LOG_WORKDAY );
//		String seqNo     = propLogData.getProperty( Log.LOG_SEQNO );
//		String mId       = propLogData.getProperty( Log.LOG_MEMBER_ID );
//		String mIdSeq    = propLogData.getProperty( Log.LOG_MEMBER_ID_SEQ );
//		String listTable = propLogData.getProperty( Log.LOG_LIST_TABLE );
		
		String actType   = "SKIP";
		
		if(trKind.equals("O")){
			actType = "OPEN";
		}else if(trKind.equals("C")){
			actType = "CLICK";
		}else{
			return "SKIP";
		}
		
		//static hashtable에서 post_id에 해당하는 bean을 가져옴
		PlanBean bean = PlanBean.getPlanBean(postId);
		if(bean == null){
			bean = new PlanBean();
			/*
			SELECT B.MSG_TYPE     AS MSG_TYPE,
				   B.MSG_TYPE_SEQ AS MSG_TYPE_SEQ,
				   B.PLAN_DAY     AS PLAN_DAY,
				   B.PLAN_HOUR    AS PLAN_HOUR,
				   B.PLAN_STATUS  AS PLAN_STATUS
			  FROM TMS_AUTO_SCHD_INFO A, 
			       TMS_AUTO_MSG_INFO B
			 WHERE A.WORKDAY = '${WORKDAY}'
			   AND A.SEQNO = '${SEQNO}'
			   AND A.MSG_TYPE = B.PLAN_PARENT_MSG_TYPE
			   AND A.MSG_TYPE_SEQ = B.PLAN_PARENT_MSG_TYPE_SEQ
			   AND B.CHANNEL_TYPE = 'EM' 
			 */
			//preparedStatement를 생성
			if(PPS_SELECT_FLOW_DATA == null){
				PPS_SELECT_FLOW_DATA = EMS_CONNECTION.prepareStatement(QUERY_SELECT_PLAN_INFO,"${","}");
			}
			
			eMsResultSet rsFlowData = PPS_SELECT_FLOW_DATA.executeQuery(propLogData);
			
			ArrayList    arrTarget  = new ArrayList();
			
			while(rsFlowData.next()){
				Properties prop = new Properties();
				
				prop.setProperty("MSG_TYPE",    rsFlowData.getString("MSG_TYPE"));
				prop.setProperty("MSG_TYPE_SEQ",rsFlowData.getString("MSG_TYPE_SEQ"));
				prop.setProperty("PLAN_DAY",    rsFlowData.getString("PLAN_DAY"));
				prop.setProperty("PLAN_HOUR",   rsFlowData.getString("PLAN_HOUR"));
				prop.setProperty("PLAN_STATUS", rsFlowData.getString("PLAN_STATUS"));
				
				arrTarget.add(prop);
			}
			
			bean.setPostId(postId);
			bean.setArrTarget(arrTarget);
			
			//static hashtable에 저장
			PlanBean.setPlanBean(bean);
		}
		
		//plan 이 아닐경우 skip
		if(!bean.isPlanYn()){
			if(log.isDebugEnabled()){
				log.debug("[SKIP] no Plan");
			}
			return "SKIP";
		}

		ArrayList<Properties> dataList = bean.getArrTarget();
		
		int    dataCnt    = dataList.size();
		String msgType    = "";
		String msgTypeSeq = "";
		String planStatus = "";
		String planDay    = "";
		String planHour   = "";
		
		boolean actFlag   = false;
		
		//insert
		for(int i=0; i< dataCnt; i++){
			Properties propPlanData = dataList.get(i);
			
			msgType    = propPlanData.getProperty("MSG_TYPE");
			msgTypeSeq = propPlanData.getProperty("MSG_TYPE_SEQ");
			planStatus = propPlanData.getProperty("PLAN_STATUS");
			planDay    = propPlanData.getProperty("PLAN_DAY");
			planHour   = propPlanData.getProperty("PLAN_HOUR");
			
			/*
			 * 유효데이터인지 검증
			 */
			if(log.isDebugEnabled()){
				log.debug("[planStatus]"+planStatus+"[actType]"+actType);
			}
			
			if( "O".equals(planStatus)){ //오픈
				if( "OPEN".equals(actType) ){
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:OPEN> OPEN");
					}
				}else{
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:OPEN> SKIP: no OPEN type");
					}
					continue;
				}
			}else if( "C".equals(planStatus)){ //클릭
				if( "CLICK".equals(actType) ){
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:CLICK> CLICK");
					}
				}else{
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:CLICK> SKIP: no CLICK type");
					}
					continue;
				}
			}else{
				if(log.isDebugEnabled()){
					log.debug("[TARGET_AREA]<no Type> SKIP");
				}
				continue;
			}
						
			propLogData.setProperty("MSG_TYPE",     msgType);
			propLogData.setProperty("MSG_TYPE_SEQ", msgTypeSeq);
			propLogData.setProperty("PLAN_STATUS",  planStatus);
			propLogData.setProperty("PLAN_DAY",     StringUtil.isNull(planDay)?"0":planDay );
			propLogData.setProperty("PLAN_HOUR",    StringUtil.isNull(planHour)?"0":planHour);

			/*
			INSERT INTO PLAN_ACT_LIST(
				SRC_WORKDAY, SRC_SEQNO, SRC_MEMBER_ID, SRC_MEMBER_ID_SEQ, SRC_LIST_TABLE,
				MSG_TYPE, MSG_TYPE_SEQ,
				PLAN_STATUS, PLAN_DAY, PLAN_HOUR,
				T_DATE, 
				ACT_DATE, 
				REG_DATE )
			VALUES (
				'${WORKDAY}','${SEQNO}','${M_ID}','${M_ID_SEQ}','${LIST_TABLE}',
				'${MSG_TYPE}','${MSG_TYPE_SEQ}',
				'${PLAN_STATUS}','${PLAN_DAY}','${PLAN_HOUR}',
				DATE_FORMAT( '${T_DATE}' , '%Y-%m-%d %H:%i:%S' ),
				DATE_SUB(DATE_SUB(DATE_FORMAT( '${T_DATE}', '%Y-%m-%d %H:%i:%S' ), INTERVAL (-1*${PLAN_DAY}) DAY), INTERVAL (-1*${PLAN_HOUR}) HOUR),
				NOW() )
			 */
			//preparedStatement를 생성
			if(PPS_INSERT_FLOW_DATA == null){
				PPS_INSERT_FLOW_DATA = EMS_CONNECTION.prepareStatement(this.QUERY_INSERT_FLOW_DATA,"${","}");
			}
			
			int cnt_insert = PPS_INSERT_FLOW_DATA.executeUpdate(propLogData);
			if(cnt_insert != 1){
				log.debug("[ERROR] insert fail <FLOW_DATA> "+propLogData.toString());
			}else{
				actFlag = true;
			}
			
		}//end of for
		
		if(!actFlag){
			actType = "no Match";
		}
		
		return actType;
	}
	
	//pps group  query setting
	protected TrackingPreparedStatementGroup setPpsGrp() throws Exception{
		TrackingPreparedStatementGroup ppsGrp = new TrackingPreparedStatementGroup();
		
		ppsGrp.QUERY_FIRST_CHECK = QUERY_FIRST_CHECK;
		ppsGrp.QUERY_SECOND_CHECK = QUERY_SECOND_CHECK;
		
		ppsGrp.QUERY_UPDATE_FIRST_OK_COMMON_INFO = QUERY_UPDATE_FIRST_OK_COMMON_INFO;
		ppsGrp.QUERY_UPDATE_FIRST_OK_LIST_INFO = QUERY_UPDATE_FIRST_OK_LIST_INFO;
		
		ppsGrp.QUERY_UPDATE_SECOND_OK_COMMON_INFO = QUERY_UPDATE_SECOND_OK_COMMON_INFO;
		ppsGrp.QUERY_UPDATE_SECOND_OK_LIST_INFO = QUERY_UPDATE_SECOND_OK_LIST_INFO;
		
		ppsGrp.QUERY_UPDATE_FINAL_COMMON_INFO = QUERY_UPDATE_FINAL_COMMON_INFO;
		ppsGrp.QUERY_UPDATE_FINAL_LIST_INFO = QUERY_UPDATE_FINAL_LIST_INFO;
		
		//alpha 2
		ppsGrp.QUERY_UPDATE_MEMBER_INFO = QUERY_UPDATE_MEMBER_INFO;
		ppsGrp.QUERY_INSERT_MEMBER_INFO = QUERY_INSERT_MEMBER_INFO;
		
		ppsGrp.QUERY_UPDATE_FIRST_OK_LIST_OPOINT_INFO = QUERY_UPDATE_FIRST_OK_LIST_OPOINT_INFO;
		
		return ppsGrp;
	}
	
	//pps group  query setting
	protected TrackingPreparedStatementGroupMobile setPpsGrpMobile() throws Exception{
		TrackingPreparedStatementGroupMobile ppsGrpMobile = new TrackingPreparedStatementGroupMobile();
		
		//모바일 오픈 통계
		ppsGrpMobile.QUERY_FIRST_CHECK_MOBILE = QUERY_FIRST_CHECK_MOBILE;
		ppsGrpMobile.QUERY_SECOND_CHECK_MOBILE = QUERY_SECOND_CHECK_MOBILE;
		
		ppsGrpMobile.QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE = QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE;
		ppsGrpMobile.QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE = QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE;
		
		ppsGrpMobile.QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE = QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE;
		ppsGrpMobile.QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE = QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE;
		
		ppsGrpMobile.QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE = QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE;
		ppsGrpMobile.QUERY_UPDATE_FINAL_LIST_INFO_MOBILE = QUERY_UPDATE_FINAL_LIST_INFO_MOBILE;
		
		//alpha 2
		ppsGrpMobile.QUERY_UPDATE_MEMBER_INFO = QUERY_UPDATE_MEMBER_INFO;
		ppsGrpMobile.QUERY_INSERT_MEMBER_INFO = QUERY_INSERT_MEMBER_INFO;
		
		ppsGrpMobile.QUERY_UPDATE_FIRST_OK_LIST_OPOINT_INFO = QUERY_UPDATE_FIRST_OK_LIST_OPOINT_INFO;
		
		if (log.isDebugEnabled()) {
			log.debug("1:"+ppsGrpMobile.QUERY_FIRST_CHECK_MOBILE);
			log.debug("2:"+ppsGrpMobile.QUERY_SECOND_CHECK_MOBILE);
			log.debug("3:"+ppsGrpMobile.QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE);
			log.debug("4:"+ppsGrpMobile.QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE);
			log.debug("5:"+ppsGrpMobile.QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE);
			log.debug("6:"+ppsGrpMobile.QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE);
			log.debug("7:"+ppsGrpMobile.QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE);
			log.debug("8:"+ppsGrpMobile.QUERY_UPDATE_FINAL_LIST_INFO_MOBILE);
		}
		
		return ppsGrpMobile;
	}
	
	/** 
	 * 데이터 베이스 관련하여 내부적으로 생성한 자원들을 반환한다.
	 */
	public void clear_connection() {
		
		if( ADDITIONAL_MODULES != null ) {
			for( Iterator iterator = ADDITIONAL_MODULES.iterator() ; iterator.hasNext() ; ) {
				( ( LogUpdator )iterator.next() ).clear_connection();
			}
			ADDITIONAL_MODULES = null;
		}
		
		//plan
		if(this.PPS_SELECT_FLOW_DATA !=null){
			PPS_SELECT_FLOW_DATA.close();
			PPS_SELECT_FLOW_DATA = null; 
		}
		if(this.PPS_INSERT_FLOW_DATA !=null){
			PPS_INSERT_FLOW_DATA.close();
			PPS_INSERT_FLOW_DATA = null; 
		}
		
		PreparedStatementGroup.map_clean();
	}	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////

	
}
