package mars.tracking.updator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.PreparedStatement;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import mars.tracking.mass.updator.ErrorCorrectPreUpdator;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

@Slf4j
public class MobileDeviceUpdator {
	
	protected static PreparedStatement	EMS_P_STATEMENT						= null;
	
	//protected eMsConnection EMS_CONNECTION = null;
	
	
	
	protected StringBuffer TMP_WORK_BUFFER = null;
	
	protected eMsStatement EMS_UPDATE_STATEMENT = null;
	
	protected eMsConnection	EMS_CONNECTION	= null;
	
	protected String URL_PATH = null;
	
	protected String SOURCE_FILE = null;
	
	protected String DELIM = null;
	
	protected String LOCAL_FILE_PATH = null;
	
	public MobileDeviceUpdator(String url_path, String sourceFile, String delim, String localFilePath) {
		this.URL_PATH = url_path;
		this.SOURCE_FILE = sourceFile;
		this.DELIM = delim;		
		this.LOCAL_FILE_PATH = localFilePath;
		try {
			EMS_CONNECTION = ConnectionPool.getConnection();
		} catch (Exception e) {
			log.error(e.getMessage());
		}
	}
	
	public boolean deviceListUpdate() throws Exception {
        URLConnection conn = null; 
        
        try {
        	// CS서버에 있는 파일을 읽어온다
        	String downUrl = this.URL_PATH + "/" + this.SOURCE_FILE;
        	URL url = new URL(downUrl);
        	conn = url.openConnection();
        	
        	try(
        	InputStream in = conn.getInputStream();
        	InputStreamReader inr = new InputStreamReader(in, "utf-8");
        	BufferedReader br = new BufferedReader(inr);
        	BufferedWriter bwr = new BufferedWriter(new FileWriter(this.LOCAL_FILE_PATH));
        	){
        	
	        	// 로컬에 있는 파일을 읽어온다
	        	String localFileVer = getLocalFileVersion();
	        	boolean firstFlag;
				if(localFileVer==null) {
					firstFlag = true;
					localFileVer = "";
				} else {
					firstFlag = false;
				}
	        	
	        	String tempStr = null;
	        	
	        	int flagCnt = 0;
	        	
	        	String m_sQUERY_DELETE_MOBILE_DEVICE_LIST = SqlManager.getQuery("MobileDevice", "m_sQUERY_DELETE_MOBILE_DEVICE_LIST");
	        	String m_sQUERY_INSERT_MOBILE_DEVICE_LIST = SqlManager.getQuery("MobileDevice", "m_sQUERY_INSERT_MOBILE_DEVICE_LIST");
	        	
	        	this.EMS_UPDATE_STATEMENT = EMS_CONNECTION.createStatement();
	        	TMP_WORK_BUFFER = new StringBuffer(512);
	        	
	        	while(true) {
	        		tempStr = br.readLine();
	        		if(tempStr == null) {
	        			break;
	        		}
	        		// 로컬의 버전과 CS서버의 버전이 같으면 아무작업 하지 않는다.
	        		if(flagCnt == 0 && localFileVer.equals(tempStr)) {
	        			log.debug("로컬버전과 CS서버의 버전이 같으므로 업데이드를 진행하지 않습니다.");
	        			break;
	        		} 
	        		else {
	        			// 딱 한번만 전체 삭제 (DELETE FROM EMS_BASE_CODE_INFO WHERE CODE_TYPE = "MB")
	        			if(flagCnt ==0) {
	        	        	EMS_P_STATEMENT = EMS_CONNECTION.prepareStatement(m_sQUERY_DELETE_MOBILE_DEVICE_LIST);
	        				EMS_P_STATEMENT.executeUpdate();
	        			}
	        			// 파일쓰기 시작
	        			bwr.write(tempStr);
	        			bwr.newLine();
	        			
	        			// 인서트 시작
	        			// INSERT INTO EMS_BASE_CODE_INFO (.......) VALUES (......)
	        			if(flagCnt > 0) {
	        				String[] list = StringUtil.split(tempStr, this.DELIM);
	        				Properties obj = new Properties();
	        				obj.setProperty("NUM", list[0]);
	        				obj.setProperty("COMPANY", list[1]);
	        				obj.setProperty("PLATFORM", list[2]);
	        				obj.setProperty("MODEL_TYPE", list[3]);
	        				obj.setProperty("MODEL_NAME_KO", list[4]);
	        				obj.setProperty("MODEL_NAME_EN", list[5]);
	        				obj.setProperty("KEYWORD", list[6]);
	        				
	        				executeUpdate(m_sQUERY_INSERT_MOBILE_DEVICE_LIST, obj);
	        			}
	        		}
	        		flagCnt++;
	        	}
        	} catch(Exception ex) {
        		log.error("Exception", ex);
        	}
        } catch (Exception e) {
        	log.error("Exception",e);
        } 
		return true;
	}
	
	// 로컬파일의 버전정보를 읽어온다.
	private String getLocalFileVersion() {
		BufferedReader br = null;
		String returnStr = "";
		try {
			br = new BufferedReader(new FileReader(this.LOCAL_FILE_PATH));
			String str;
			// 버전정보는 가장 첫줄에 있기 때문에 한번만 읽으면 된다.
			returnStr = br.readLine();
			if (returnStr == null) {
				returnStr = "no version";
			}
		} catch(FileNotFoundException fe) {
			returnStr = null;
		}		
		catch(Exception e) {
			log.error("Exception",e);
		} finally {
			try {
				if(br != null) {
					br.close();
				}
			} catch (IOException e) {
				log.error("Exception",e);
			}
		}
		return returnStr;	
	}
	
	/**단순쿼리 업데이트 한다.
	 */
	protected int executeUpdate( String query , Object obj ) throws Exception{
		TMP_WORK_BUFFER.setLength( 0 );
		StringConvertUtil.ConvertString( TMP_WORK_BUFFER , query , obj , "${" , "}" , true , false );
		if (log.isDebugEnabled())  log.debug( "original=>[" + query + "]" );
		if (log.isDebugEnabled())  log.debug( "exec=>" + TMP_WORK_BUFFER.toString() );
		return this.EMS_UPDATE_STATEMENT.executeUpdate( TMP_WORK_BUFFER.toString() );
	}
}
