/*
 * @(#)MassClickUpdator.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.tracking.updator;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
/**
 * 대량 메일 클릭 정보 업데이트를 수행한다.<br>
 * 기본 로직은 pluto.common.log.TargetSecondCheckSwitchUpdator에 <br>
 * 선언되어 있고 이것을 상속받아 여기서는 쿼리를 받아오는 로직만을 <br>
 * 추가해 놓았다.
 * 
 */
@Slf4j
public class MassClickUpdator extends TargetSecondCheckSwitchUpdatorPps {
	
	
	protected static String _QUERY_FIRST_CHECK = null;
	protected static String _QUERY_SECOND_CHECK = null;
	
	protected static List _QUERY_UPDATE_FIRST_OK_COMMON_INFO = null;
	protected static List _QUERY_UPDATE_FIRST_OK_LIST_INFO = null;

	protected static List _QUERY_UPDATE_SECOND_OK_COMMON_INFO = null;
	protected static List _QUERY_UPDATE_SECOND_OK_LIST_INFO = null;
	
	protected static List _QUERY_UPDATE_FINAL_COMMON_INFO = null;
	protected static List _QUERY_UPDATE_FINAL_LIST_INFO = null;
	
	protected static String _QUERY_UPDATE_MEMBER_INFO = null;
	protected static List _QUERY_INSERT_MEMBER_INFO = null;
	
	protected static String _QUERY_FIRST_CHECK_MOBILE = null;
	protected static String _QUERY_SECOND_CHECK_MOBILE = null;
	
	protected static List _QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE = null;
	protected static List _QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE = null;

	protected static List _QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE = null;
	protected static List _QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE = null;
	
	protected static List _QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE = null;
	protected static List _QUERY_UPDATE_FINAL_LIST_INFO_MOBILE = null;
	
	protected static String _QUERY_UPDATE_MEMBER_INFO_MOBILE = null;
	protected static List _QUERY_INSERT_MEMBER_INFO_MOBILE = null;
	
	static {
		log.info("[ init ] MassClickUpdator Query initialize .... ");
		try {
			_QUERY_FIRST_CHECK = SqlManager.getQuery("WINDFORCE_CLICK", "QUERY_FIRST_CHECK");
			_QUERY_SECOND_CHECK = SqlManager.getQuery("WINDFORCE_CLICK", "QUERY_SECOND_CHECK");
			
			_QUERY_UPDATE_FIRST_OK_COMMON_INFO = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_FIRST_OK_COMMON_INFO");
			_QUERY_UPDATE_FIRST_OK_LIST_INFO = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_FIRST_OK_LIST_INFO");

			_QUERY_UPDATE_SECOND_OK_COMMON_INFO = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_SECOND_OK_COMMON_INFO");
			_QUERY_UPDATE_SECOND_OK_LIST_INFO = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_SECOND_OK_LIST_INFO");
			
			_QUERY_UPDATE_FINAL_COMMON_INFO = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_FINAL_COMMON_INFO");
			_QUERY_UPDATE_FINAL_LIST_INFO = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_FINAL_LIST_INFO");

			// A2_MEMBERS 고객 테이블에 오픈 정보 업데이트 쿼리
			_QUERY_UPDATE_MEMBER_INFO = SqlManager.getQuery("A2_MEMBER", "QUERY_UPDATE_MEMBER_CLICK_INFO");
			// A2_MEMBERS 고객 테이블에 고객 추가 쿼리
			_QUERY_INSERT_MEMBER_INFO = SqlManager.getMultiQuery("A2_MEMBER", "QUERY_INSERT_MEMBER_FROM_CLICK");	
			
			_QUERY_FIRST_CHECK_MOBILE = SqlManager.getQuery("WINDFORCE_CLICK", "QUERY_FIRST_CHECK_MOBILE");
			_QUERY_SECOND_CHECK_MOBILE = SqlManager.getQuery("WINDFORCE_CLICK", "QUERY_SECOND_CHECK_MOBILE");
			
			_QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE");
			_QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE");

			_QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE");
			_QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE");
			
			_QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE");
			_QUERY_UPDATE_FINAL_LIST_INFO_MOBILE = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_FINAL_LIST_INFO_MOBILE");
}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
		log.info("[ init ] MassClickUpdator Query initialize .... [OK]");
	}
	
	
	
	/** Creates a new instance of MassClickUpdator */
	public MassClickUpdator() {
		super();
		this.QUERY_FIRST_CHECK = _QUERY_FIRST_CHECK;
		this.QUERY_SECOND_CHECK = _QUERY_SECOND_CHECK;
		
		this.QUERY_UPDATE_FIRST_OK_COMMON_INFO = _QUERY_UPDATE_FIRST_OK_COMMON_INFO;
		this.QUERY_UPDATE_FIRST_OK_LIST_INFO = _QUERY_UPDATE_FIRST_OK_LIST_INFO;
		
		this.QUERY_UPDATE_SECOND_OK_COMMON_INFO = _QUERY_UPDATE_SECOND_OK_COMMON_INFO;
		this.QUERY_UPDATE_SECOND_OK_LIST_INFO = _QUERY_UPDATE_SECOND_OK_LIST_INFO;
		
		this.QUERY_UPDATE_FINAL_COMMON_INFO = _QUERY_UPDATE_FINAL_COMMON_INFO;
		this.QUERY_UPDATE_FINAL_LIST_INFO = _QUERY_UPDATE_FINAL_LIST_INFO;

		this.QUERY_UPDATE_MEMBER_INFO = _QUERY_UPDATE_MEMBER_INFO;
		this.QUERY_INSERT_MEMBER_INFO = _QUERY_INSERT_MEMBER_INFO;
		
		
		
		this.QUERY_FIRST_CHECK_MOBILE = _QUERY_FIRST_CHECK_MOBILE;
		this.QUERY_SECOND_CHECK_MOBILE = _QUERY_SECOND_CHECK_MOBILE;
		
		this.QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE = _QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE;
		this.QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE = _QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE;
		
		this.QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE = _QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE;
		this.QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE = _QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE;
		
		this.QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE = _QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE;
		this.QUERY_UPDATE_FINAL_LIST_INFO_MOBILE = _QUERY_UPDATE_FINAL_LIST_INFO_MOBILE;
		
		
		
		if(log.isDebugEnabled()){
			// foo
		}
		
	}
}
