
package mars.tracking.updator;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;

/**
 * 자동 메일 클릭 정보 업데이트를 수행한다.<br>
 * 기본 로직은 pluto.common.log.TargetSecondCheckSwitchUpdator에 <br>
 * 선언되어 있고 이것을 상속받아 여기서는 쿼리를 받아오는 로직만을 <br>
 * 추가해 놓았다.
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class AutoClickUpdator extends TargetSecondCheckSwitchUpdatorPps {
	
	
	protected static String _QUERY_FIRST_CHECK = null;
	protected static String _QUERY_SECOND_CHECK = null;
	
	protected static List _QUERY_UPDATE_FIRST_OK_COMMON_INFO = null;
	protected static List _QUERY_UPDATE_FIRST_OK_LIST_INFO = null;

	protected static List _QUERY_UPDATE_SECOND_OK_COMMON_INFO = null;
	protected static List _QUERY_UPDATE_SECOND_OK_LIST_INFO = null;
	
	protected static List _QUERY_UPDATE_FINAL_COMMON_INFO = null;
	protected static List _QUERY_UPDATE_FINAL_LIST_INFO = null;
	
	
	protected static String _QUERY_FIRST_CHECK_MOBILE = null;
	protected static String _QUERY_SECOND_CHECK_MOBILE = null;
	
	protected static List _QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE = null;
	protected static List _QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE = null;

	protected static List _QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE = null;
	protected static List _QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE = null;
	
	protected static List _QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE = null;
	protected static List _QUERY_UPDATE_FINAL_LIST_INFO_MOBILE = null;
	
	
	static {
		log.info("[ init ] AutoClickUpdator Query initialize .... ");
		try {
			_QUERY_FIRST_CHECK = SqlManager.getQuery("JUPITER_CLICK", "QUERY_FIRST_CHECK");
			_QUERY_SECOND_CHECK = SqlManager.getQuery("JUPITER_CLICK", "QUERY_SECOND_CHECK");
			
			_QUERY_UPDATE_FIRST_OK_COMMON_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FIRST_OK_COMMON_INFO");
			_QUERY_UPDATE_FIRST_OK_LIST_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FIRST_OK_LIST_INFO");

			_QUERY_UPDATE_SECOND_OK_COMMON_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_SECOND_OK_COMMON_INFO");
			_QUERY_UPDATE_SECOND_OK_LIST_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_SECOND_OK_LIST_INFO");
			
			_QUERY_UPDATE_FINAL_COMMON_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FINAL_COMMON_INFO");
			_QUERY_UPDATE_FINAL_LIST_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FINAL_LIST_INFO");
			
			
			_QUERY_FIRST_CHECK_MOBILE = SqlManager.getQuery("JUPITER_CLICK", "QUERY_FIRST_CHECK_MOBILE");
			_QUERY_SECOND_CHECK_MOBILE = SqlManager.getQuery("JUPITER_CLICK", "QUERY_SECOND_CHECK_MOBILE");
			
			_QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE");
			_QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE");

			_QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE");
			_QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE");
			
			_QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE");
			_QUERY_UPDATE_FINAL_LIST_INFO_MOBILE = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FINAL_LIST_INFO_MOBILE");
			
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
		log.info("[ init ] AutoClickUpdator Query initialize .... [OK]");
	}
	
	
	
	/** Creates a new instance of AutoClickUpdator */
	public AutoClickUpdator() {
		super();
		this.QUERY_FIRST_CHECK = _QUERY_FIRST_CHECK;
		this.QUERY_SECOND_CHECK = _QUERY_SECOND_CHECK;
		
		this.QUERY_UPDATE_FIRST_OK_COMMON_INFO = _QUERY_UPDATE_FIRST_OK_COMMON_INFO;
		this.QUERY_UPDATE_FIRST_OK_LIST_INFO = _QUERY_UPDATE_FIRST_OK_LIST_INFO;
		
		this.QUERY_UPDATE_SECOND_OK_COMMON_INFO = _QUERY_UPDATE_SECOND_OK_COMMON_INFO;
		this.QUERY_UPDATE_SECOND_OK_LIST_INFO = _QUERY_UPDATE_SECOND_OK_LIST_INFO;
		
		this.QUERY_UPDATE_FINAL_COMMON_INFO = _QUERY_UPDATE_FINAL_COMMON_INFO;
		this.QUERY_UPDATE_FINAL_LIST_INFO = _QUERY_UPDATE_FINAL_LIST_INFO;
		
		
		this.QUERY_FIRST_CHECK_MOBILE = _QUERY_FIRST_CHECK_MOBILE;
		this.QUERY_SECOND_CHECK_MOBILE = _QUERY_SECOND_CHECK_MOBILE;
		
		this.QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE = _QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE;
		this.QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE = _QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE;
		
		this.QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE = _QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE;
		this.QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE = _QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE;
		
		this.QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE = _QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE;
		this.QUERY_UPDATE_FINAL_LIST_INFO_MOBILE = _QUERY_UPDATE_FINAL_LIST_INFO_MOBILE;
		
		
		if(log.isDebugEnabled()){
			// foo
		}

	}
}
