package mars.tracking.parser;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;

import lombok.extern.slf4j.Slf4j;
import pluto.log.LogParser;
import pluto.log.LogProcessor;
import pluto.util.PlutoLinkedList;
import pluto.util.StringUtil;
import pluto.util.convert.TrackingInfoConvertor;

@Slf4j
public class IISLogParser extends Properties implements LogParser {

	private static final String	DATA_DIV = " ";
	

	/** Duration Time parameter의 name */
	private static final String		INDEX_DUR_TIME			= "&DT=";

	/** URL parameter의 name */
	private static final String		INDEX_GO_URL			= "&URL=";

	/**   */
	private static final String		INDEX_END_URL			= " ";

	public static String			RECEIVER_HTML			= "tr.html?";

	public static String			LOWER_RECEIVER_HTML		= "tr.html?";

	protected List					FIRST_INNER_WORK_LIST	= new PlutoLinkedList();

	protected List					SECOND_INNER_WORK_LIST	= new PlutoLinkedList();

	protected StringBuffer			__TMP_BUFFER			= new StringBuffer(128);

	private static boolean			OUT_DEBUG				= false;
	
	private static Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
	
	private static final int ADD_LOCALE_TIME = 9;//korea time (GMT+9)
	
	private static final int INDEX_YEAR = 0;
	private static final int INDEX_MONTH = 5;
	private static final int INDEX_DAY = 8;
	private static final int INDEX_HOUR = 11;
	private static final int INDEX_MINUTE = 14;
	private static final int INDEX_SECOND = 17;
	
	/** Creates new ApacheLogParser */
	public IISLogParser() {
		super();
	}

	/**
	 * 파싱룰을 정의한다.
	 * 
	 * @param tmp
	 *        초기화 파라미터
	 * @throws Exception
	 *         초기화 에러
	 */
	public void setParsingRules(Object tmp) throws Exception {

		Properties prop = (Properties) tmp;
		RECEIVER_HTML = (prop.getProperty("script.index", RECEIVER_HTML));
		RECEIVER_HTML = RECEIVER_HTML.substring(0,RECEIVER_HTML.length()-1);
		LOWER_RECEIVER_HTML = RECEIVER_HTML.toLowerCase();
		OUT_DEBUG = prop.getProperty("check.debug", "false").equals("true");
	}
	 
	
	public Object parse(String src) throws Exception {

		this.clear();
		
		String toDate = "";
		String shotDate = "";

		//-------------------------------------------------------------------------------------
		int idx1 = src.indexOf(DATA_DIV);
		
		////////
		String s_date = src.substring(0,idx1).replaceAll("-", "");
		
		if( OUT_DEBUG )
			log.debug("s_date : "+s_date+"  idx1:"+idx1);

		if( s_date.length()!=8 ) {
			if( OUT_DEBUG )
				log.debug("no TIME_YYYYMMDD");
			return null;
		}

		int idx2 = src.indexOf(DATA_DIV, idx1+1);
		String tdate = src.substring(0,idx2);
		
		if( tdate.length()!=19 ) {
			if( OUT_DEBUG )
				log.debug("no T_DATE");
			return null;
		}else{
			cal.set(Integer.parseInt(tdate.substring(INDEX_YEAR, INDEX_YEAR+4)), 
					Integer.parseInt(tdate.substring(INDEX_MONTH, INDEX_MONTH+2))-1, 
					Integer.parseInt(tdate.substring(INDEX_DAY, INDEX_DAY+2)), 
					Integer.parseInt(tdate.substring(INDEX_HOUR, INDEX_HOUR+2)), 
					Integer.parseInt(tdate.substring(INDEX_MINUTE, INDEX_MINUTE+2)), 
					Integer.parseInt(tdate.substring(INDEX_SECOND, INDEX_SECOND+2))
					);
			cal.add(Calendar.HOUR_OF_DAY, ADD_LOCALE_TIME);
			
			toDate = getToDate(cal);
			shotDate = getShotDate(cal);
		}
		
		
		if( OUT_DEBUG )
			log.debug("tdate : "+toDate+" sdate:"+shotDate);
		
		setProperty(LOG_TR_LOG_DATE, shotDate);
		setProperty(LOG_T_DATE, toDate);
		//-------------------------------------------------------------------------------------
		
		
		
		
		
		idx1 = src.indexOf(RECEIVER_HTML);

		if( idx1 < 0 ) {
			idx1 = src.toLowerCase().indexOf(LOWER_RECEIVER_HTML);
			if( OUT_DEBUG )
				log.debug("no script index");
			if( idx1 < 0 )
				return null;
		}

		/**
		 * 실제 트래킹을 가져온다.
		 */
		idx2 = src.indexOf(INDEX_GO_URL, idx1);		
		int idx3 = src.indexOf(INDEX_END_URL, idx1+ RECEIVER_HTML.length() + 1);

		if( idx2 < 0 ) {
			src = src.substring(idx1 + RECEIVER_HTML.length() + 1, idx3);
			if (log.isDebugEnabled())  log.debug("REAL_TRACKING_DATA1: "+src);
		}
		else {
			src = src.substring(idx1 + RECEIVER_HTML.length() + 1, idx2);
			if (log.isDebugEnabled())  log.debug("REAL_TRACKING_DATA2: "+src);
		}

		/**
		 * 듀레이션 이라면 ... 그것을 떼어내서 세팅하고 그 부분을 제외한다.
		 */
		idx1 = src.indexOf(INDEX_DUR_TIME);

		if( idx1 > 0 ) {
			String DUR = src.substring(idx1 + INDEX_DUR_TIME.length());
			setProperty(LOG_TR_DUR_TIME, DUR.length() > 3 ? DUR.substring(0, DUR.length() - 3) : "1");
			src = src.substring(0, idx1);
			if (log.isDebugEnabled()) 
				log.debug(src);
		}

		//		String info = null;
		//		String m_id = null;

		/*
		 * 메일 정보 부분과 회원아이디 부분을 구분한다.
		 */
		FIRST_INNER_WORK_LIST.clear();
		FIRST_INNER_WORK_LIST = StringUtil.toStringList(src, "&", FIRST_INNER_WORK_LIST);

		for (Iterator iter = FIRST_INNER_WORK_LIST.iterator(); iter.hasNext();) {
			if( !parse_tr_part(iter.next().toString()) ) {
				return null;
			}
		}

		return this;
	}

	private boolean parse_tr_part(String s) {
		String src = s.trim();

		if( src.length() < 4 )
			return true;

		try {
			if (log.isDebugEnabled()) 
				log.debug("before decript : " + src);
			src = TrackingInfoConvertor.decode(src).trim();
			if (log.isDebugEnabled()) 
				log.debug("after decript : " + src);
			SECOND_INNER_WORK_LIST.clear();
			SECOND_INNER_WORK_LIST = StringUtil.toStringList(src, "&", SECOND_INNER_WORK_LIST);
			for (Iterator iter = SECOND_INNER_WORK_LIST.iterator(); iter.hasNext();) {
				setValue(iter.next().toString());
			}
		}
		catch(Exception e) {
			if( OUT_DEBUG )
				log.debug("tr parsing error", e);
			return false;
		}
		return true;
	}

	private void setValue(String src) {

		int idx = src.indexOf("=");
		if( idx < 0 )
			return;
		setProperty(src.substring(0, idx).trim(), src.substring(idx + 1).trim());
	}

	/**
	 * 포그를 파싱하면서 추가로 작업을 해야할 LogProcessor를 지정한다.
	 */
	public void setExternalLogProcessor(LogProcessor tmp) throws Exception {
	}
	
	public String getToDate(Calendar cal){		
		return cal.get(Calendar.YEAR)
				+"-"+lengthConvert( (cal.get(Calendar.MONTH)+1) )
				+"-"+lengthConvert( cal.get(Calendar.DATE) )
				+" "+lengthConvert( cal.get(Calendar.HOUR_OF_DAY) )
				+":"+lengthConvert( cal.get(Calendar.MINUTE) )
				+":"+lengthConvert( cal.get(Calendar.SECOND) );
	}
	
	public String getShotDate(Calendar cal){		
		return ""+cal.get(Calendar.YEAR)
				+lengthConvert( (cal.get(Calendar.MONTH)+1) )
				+lengthConvert( cal.get(Calendar.DATE) );
	}
	
	public String lengthConvert(int target){
		if(target<10){
			return "0"+target;
		}else{
			return ""+target;
		}
	}
	
}
