/*
 * @(#)ApacheLogParser.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package mars.tracking.parser;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.log.LogParser;
import pluto.log.LogProcessor;
import pluto.util.PlutoLinkedList;
import pluto.util.StringUtil;
import pluto.util.convert.TrackingInfoConvertor;

/**
 * 아파치 웹서버가 적은 로그를 파싱하는 로직을 제공한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class ApacheA2LogParser extends Properties implements LogParser {

	/** Date 내용을 감싸는 괄호의 앞 부분 */
	private static final String		DATE_START				= "[";

	/** Date 내용을 감싸는 괄호의 뒷 부분 */
	private static final String		DATE_END				= "]";

	/** Date 내용을 감싸는 괄호의 중간 부분 (?) */
	private static final String		DATE_MIDDLE				= " ";

	/** Duration Time parameter의 name */
	private static final String		INDEX_DUR_TIME			= "&DT=";

	/** URL parameter의 name */
	private static final String		INDEX_GO_URL			= "&URL=";

	/**   */
	private static final String		INDEX_END_URL			= " ";

	public static String			RECEIVER_HTML			= "tr.html?";

	public static String			LOWER_RECEIVER_HTML		= "tr.html?";

	private static Hashtable		__MONTH_MAP__;

	static {
		__MONTH_MAP__ = new Hashtable();
		__MONTH_MAP__.put("jan", "01");
		__MONTH_MAP__.put("feb", "02");
		__MONTH_MAP__.put("mar", "03");
		__MONTH_MAP__.put("apr", "04");
		__MONTH_MAP__.put("may", "05");
		__MONTH_MAP__.put("jun", "06");
		__MONTH_MAP__.put("jul", "07");
		__MONTH_MAP__.put("aug", "08");
		__MONTH_MAP__.put("sep", "09");
		__MONTH_MAP__.put("oct", "10");
		__MONTH_MAP__.put("nov", "11");
		__MONTH_MAP__.put("dec", "12");
	}

	protected List					FIRST_INNER_WORK_LIST	= new PlutoLinkedList();

	protected List					SECOND_INNER_WORK_LIST	= new PlutoLinkedList();

	protected StringBuffer			__TMP_BUFFER			= new StringBuffer(128);

	private static boolean			OUT_DEBUG				= false;

	/** Creates new ApacheLogParser */
	public ApacheA2LogParser() {
		super();
	}

	/**
	 * 파싱룰을 정의한다.
	 * 
	 * @param tmp
	 *        초기화 파라미터
	 * @throws Exception
	 *         초기화 에러
	 */
	public void setParsingRules(Object tmp) throws Exception {

		Properties prop = (Properties) tmp;
		RECEIVER_HTML = prop.getProperty("script.index", RECEIVER_HTML);
		LOWER_RECEIVER_HTML = RECEIVER_HTML.toLowerCase();
		OUT_DEBUG = prop.getProperty("check.debug", "false").equals("true");
	}

	public Object parse(String src) throws Exception {

		this.clear();

		// String tmpStr = null;

		int idx1 = src.indexOf(DATE_START);

		if( idx1 < 0 ) {
			if( OUT_DEBUG )
				log.debug("no date start");
			return null;
		}

		int idx2 = src.indexOf(DATE_END);

		if( idx2 < 0 ) {
			if( OUT_DEBUG )
				log.debug("no date end");
			return null;
		}

		int idx3 = src.indexOf(DATE_MIDDLE, idx1);

		if( idx3 < 0 ) {
			if( OUT_DEBUG )
				log.debug("no date middle");
			return null;
		}

		if( idx3 > idx2 ) {
			if( OUT_DEBUG )
				log.debug("date start and end sequence");
			return null;
		}

		// 시간 파싱
		parse_date(src.substring(idx1 + DATE_START.length(), idx3));

		idx1 = src.indexOf(RECEIVER_HTML);

		if( idx1 < 0 ) {
			idx1 = src.toLowerCase().indexOf(LOWER_RECEIVER_HTML);
			if( OUT_DEBUG )
				log.debug("no script index");
			if( idx1 < 0 )
				return null;
		}

		/**
		 * 실제 트래킹을 가져온다.
		 */
		idx2 = src.indexOf(INDEX_GO_URL, idx1);
		idx3 = src.indexOf(INDEX_END_URL, idx1);

		if( idx2 < 0 ) {
			src = src.substring(idx1 + RECEIVER_HTML.length(), idx3);
			if (log.isDebugEnabled()) 
				log.debug(src);
		}
		else {
			// URL을 저장
			setValue(src.substring(idx2+1 , idx3));
			src = src.substring(idx1 + RECEIVER_HTML.length(), idx2);
			if (log.isDebugEnabled()) 
				log.debug(src);
		}

		//		String info = null;
		//		String m_id = null;

		/*
		 * 메일 정보 부분과 회원아이디 부분을 구분한다.
		 */
		FIRST_INNER_WORK_LIST.clear();
		FIRST_INNER_WORK_LIST = StringUtil.toStringList(src, "&", FIRST_INNER_WORK_LIST);

		for (Iterator iter = FIRST_INNER_WORK_LIST.iterator(); iter.hasNext();) {
			if( !parse_tr_part(iter.next().toString()) ) {
				return null;
			}
		}

		return this;
	}

	private boolean parse_tr_part(String s) {
		String src = s.trim();

		if( src.length() < 4 )
			return true;

		try {
			if (log.isDebugEnabled()) 
				log.debug("before decript : " + src);
			src = TrackingInfoConvertor.decode(src).trim();
			if (log.isDebugEnabled()) 
				log.debug("after decript : " + src);
			SECOND_INNER_WORK_LIST.clear();
			SECOND_INNER_WORK_LIST = StringUtil.toStringList(src, "&", SECOND_INNER_WORK_LIST);
			for (Iterator iter = SECOND_INNER_WORK_LIST.iterator(); iter.hasNext();) {
				setValue(iter.next().toString());
			}
		}
		catch(Exception e) {
			if( OUT_DEBUG )
				log.debug("tr parsing error", e);
			return false;
		}
		return true;
	}

	private boolean parse_date(String src) {

		try {
			String year = null;
			String month = null;
			String day = null;
			String hour = null;
			String time = null;
			int idx1 = src.indexOf("/");
			day = src.substring(0, idx1);
			int idx2 = src.indexOf("/", idx1 + 1);
			month = (String) __MONTH_MAP__.get(src.substring(idx1 + 1, idx2).toLowerCase());
			idx1 = idx2 + 1;
			idx2 = src.indexOf(":", idx1);
			year = src.substring(idx1, idx2);
			time = src.substring(idx2 + 1);
			hour = src.substring(idx2+1,idx2+3);
			
			__TMP_BUFFER.setLength(0);
			setProperty(LOG_TR_LOG_DATE, __TMP_BUFFER.append(year).append(month).append(day).toString());
			__TMP_BUFFER.setLength(0);
			setProperty(LOG_T_DATE, __TMP_BUFFER.append(year).append("-").append(month).append("-").append(day).append(" ").append(time).toString());

			// 방문자 분석을 위해서 추가 설정
			setProperty("T_YEAR",year);
			setProperty("T_MONTH",month);
			setProperty("T_DAY",day);
			setProperty("T_HOUR",hour);

		}
		catch(Exception e) {
			if( OUT_DEBUG )
				log.debug("date parsing error", e);
			return false;
		}
		return true;
	}

	private void setValue(String src) {

		int idx = src.indexOf("=");
		if( idx < 0 )
			return;
		setProperty(src.substring(0, idx).trim(), src.substring(idx + 1).trim());
	}

	/**
	 * 포그를 파싱하면서 추가로 작업을 해야할 LogProcessor를 지정한다.
	 */
	public void setExternalLogProcessor(LogProcessor tmp) throws Exception {
	}
	
	public static void main(String args[]) throws Exception {
		ApacheA2LogParser a = new ApacheA2LogParser(); 
		a.parse("TV9JRD10ZXN0MQ==&U1RZUEU9TUFTUw==&TElTVF9UQUJMRT1FTVNfTUFTU19TRU5EX0xJU1RfMDg=&UE9TVF9JRD0yMDA4MDgxOTAwMDAx&VEM9MjAwODA4MjQ=&S0lORD1P");
	}
}
