/*
 * @(#)TestDurUpdator.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.tracking.mass.updator;

import java.util.List;
import java.util.Properties;

import pluto.common.log.TargetQueryListUpdator;
import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;
/**
 * 테스트 메일 오픈 정보 업데이트를 수행한다.<br>
 * 기본 로직은 pluto.common.log.TargetQueryListUpdator에 <br>
 * 선언되어 있고 이것을 상속받아 여기서는 쿼리를 받아오는 로직만을 <br>
 * 추가해 놓았다.
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class TestDurUpdator  extends TargetQueryListUpdator {
	
	
	protected static List _QUERY_UPDATE_QUERYS = null;
	
	static {
		try {
			_QUERY_UPDATE_QUERYS = SqlManager.getMultiQuery("WINDFORCE_DUR", "QUERY_TEST_UPDATE_LIST");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}
	
	
	
	/** Creates a new instance of TestDurUpdator */
	public TestDurUpdator() {
		super();
		this.QUERY_UPDATE_QUERYS = _QUERY_UPDATE_QUERYS;
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	public String update(Object obj) throws Exception {
		String test = ( (Properties)obj ).getProperty( LOG_TR_DUR_TIME );
		if(  test == null || test.trim().length() < 1 ){
			return "DUR OPEN";
		}
		
		return super.update( obj );
	}
}
