/*
 * @(#)DurUpdator.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.tracking.mass.updator;

import java.util.List;
import java.util.Properties;

import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;
import pluto.common.log.TargetCheckResultUpdator;
/**
 * 대량 메일 Duration Time 정보 업데이트를 수행한다.<br>
 * 기본 로직은 pluto.common.log.TargetCheckResultUpdator에 <br>
 * 선언되어 있고 이것을 상속받아 여기서는 쿼리를 받아오는 로직과 <br>
 * Dur open의 경우 Skip할 부분에 대한 로직을 추가해 놓았다
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public class DurUpdator extends TargetCheckResultUpdator {
	
	
	protected static String _QUERY_TARGET_CHECK = null;
	protected static List _QUERY_UPDATE_LIST_RESULT_QUERYS = null;
	protected static List _QUERY_UPDATE_COMMON_RESULT_QUERYS = null;
	
	static {
		try {
			_QUERY_TARGET_CHECK = SqlManager.getQuery("WINDFORCE_DUR", "QUERY_TARGET_CHECK");
			_QUERY_UPDATE_LIST_RESULT_QUERYS = SqlManager.getMultiQuery("WINDFORCE_DUR", "QUERY_UPDATE_LIST_RESULT_QUERYS");
			_QUERY_UPDATE_COMMON_RESULT_QUERYS = SqlManager.getMultiQuery("WINDFORCE_DUR", "QUERY_UPDATE_COMMON_RESULT_QUERYS");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}
	
	
	
	/** Creates a new instance of DurUpdator */
	public DurUpdator() {
		super();
		this.QUERY_TARGET_CHECK = _QUERY_TARGET_CHECK;
		this.QUERY_UPDATE_LIST_RESULT_QUERYS = _QUERY_UPDATE_LIST_RESULT_QUERYS;
		this.QUERY_UPDATE_COMMON_RESULT_QUERYS = _QUERY_UPDATE_COMMON_RESULT_QUERYS;
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	public String update(Object obj) throws Exception {
		
		String test = ( (Properties)obj ).getProperty( LOG_TR_DUR_TIME );
		if(  test == null || test.trim().length() < 1 ){
			return "DUR OPEN";
		}

		return super.update( obj );
	}
}
