/*
 * TargetSecondCheckSwitchUpdator.java
 *
 * Created on 2004년 2월 5일 (목), 오전 12:43
 */

package mars.tracking.mass.updator;

import java.util.Properties;

import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
/**
 *
 * @author  t??
 */
@Slf4j
public class A2WebLogUpdator extends LogUpdatorImpl {
	
	private static final int MAX_ARRAY = 4;
	private static final String DELIM_ITEM = "&";
	private static final String DELIM_VALUE = "=";

	protected String QUERY_UPDATE_SELECT_MEMBER_CODE = null;

	protected String QUERY_SELECT_SITELIST = null;
	protected String QUERY_UPDATE_A2_SUM_VISITOR = null;
	protected String QUERY_INSERT_A2_SUM_VISITOR = null;

	protected String QUERY_UPDATE_SELECT_EVENTID = null;

	protected String QUERY_INSERT_A2_SUM_GENERAL = null;
	protected String QUERY_INSERT_TARGET_PAGE_A2_SUM_SCN = null;
	// sect_id 정보 
	protected String QUERY_SELECT_SECT_ID = null;

	//protected List QUERY_UPDATE_FIRST_OK_LIST_INFO = null;

	/** Creates a new instance of TargetSecondCheckSwitchUpdator */
	public A2WebLogUpdator() {
		super();

		log.info("[ init ] ClickUpdator Query initialize .... ");
		try {
			QUERY_UPDATE_SELECT_MEMBER_CODE = SqlManager.getQuery("A2_WEBLOG", "QUERY_UPDATE_SELECT_MEMBER_CODE");

			QUERY_SELECT_SITELIST = SqlManager.getQuery("A2_WEBLOG", "QUERY_SELECT_SITELIST");

			QUERY_UPDATE_A2_SUM_VISITOR = SqlManager.getQuery("A2_WEBLOG", "QUERY_UPDATE_A2_SUM_VISITOR");
			QUERY_INSERT_A2_SUM_VISITOR = SqlManager.getQuery("A2_WEBLOG", "QUERY_INSERT_A2_SUM_VISITOR");

			QUERY_UPDATE_SELECT_EVENTID = SqlManager.getQuery("A2_WEBLOG", "QUERY_UPDATE_SELECT_EVENTID");

			QUERY_INSERT_A2_SUM_GENERAL = SqlManager.getQuery("A2_WEBLOG", "QUERY_INSERT_A2_SUM_GENERAL");
			QUERY_INSERT_TARGET_PAGE_A2_SUM_SCN = SqlManager.getQuery("A2_WEBLOG", "QUERY_INSERT_TARGET_PAGE_A2_SUM_SCN");
			
			QUERY_SELECT_SECT_ID = SqlManager.getQuery("A2_WEBLOG", "QUERY_SELECT_SECT_ID");

			//			QUERY_UPDATE_FIRST_OK_LIST_INFO = SqlManager.getMultiQuery("WINDFORCE_CLICK", "QUERY_UPDATE_FIRST_OK_LIST_INFO");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
		log.info("[ init ] ClickUpdator Query initialize .... [OK]");

		if(log.isDebugEnabled()){
			// foo
		}
	}

	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object log) throws Exception {

		Properties SQL_PARAM = (Properties) log;
		//baiaba__ 여기서 부터 봐야 한다. 보자.......20090417
		SQL_PARAM.setProperty("A2_LIST_TABLE", "A2_SUM_GENERAL_" + SQL_PARAM.getProperty("POST_ID").substring(4,6));

		String msg = "";
		String TMP_URL = "";
		String TMP_PARAM = "";

		// 리스트 테이블에서 코드정보를 갖고옴
		TMP_WORK_BUFFER.setLength(0);
		StringConvertUtil.ConvertString( TMP_WORK_BUFFER , QUERY_UPDATE_SELECT_MEMBER_CODE , SQL_PARAM , "${" , "}" , true , false );
		this.EMS_CONNECTION.putSingleResultToMap(TMP_WORK_BUFFER.toString(), SQL_PARAM);

		// 방문로그인지를 판단한다.
		String url = SQL_PARAM.getProperty("URL");

		if(url.startsWith("VISIT_")){
			SQL_PARAM.setProperty("HOST", url.substring("VISIT_".length()));
			TMP_WORK_BUFFER.setLength(0);
			StringConvertUtil.ConvertString( TMP_WORK_BUFFER , QUERY_SELECT_SITELIST , SQL_PARAM , "${" , "}" , true , false );
			this.EMS_CONNECTION.putSingleResultToMap(TMP_WORK_BUFFER.toString(), SQL_PARAM);

			String siteId = SQL_PARAM.getProperty("SITEID");

			// 사이트가 존재하면
			if(siteId != null){
				TMP_WORK_BUFFER.setLength(0);
				StringConvertUtil.ConvertString( TMP_WORK_BUFFER , QUERY_INSERT_A2_SUM_VISITOR , SQL_PARAM , "${" , "}" , true , false );
				int count = EMS_UPDATE_STATEMENT.executeUpdate(TMP_WORK_BUFFER.toString());

				if(count>0){
					msg = "OK";					
				}else {
					msg = "Insert Fail";
				}
			} else {
				msg = url.substring("VISIT_".length()) + " don't exist in sitelist";
			}
			return msg;
		}
		
		if(url.startsWith("about:blank")){
			msg = "sitelist is about:blank....so skip";
			return msg;
		}

		
		//여기에서 SQL_PARAM 에서 URL 빼서 목표페이지로 변경하고 ?alpha2 부분전을 잘라낸다. 그리고 나서 변수선언 insert
		//baiaba
		TMP_URL = SQL_PARAM.getProperty("URL");
		if(TMP_URL != null){
			//TMP_URL.indexOf("");
			if(TMP_URL.indexOf("?") > 0){
				TMP_PARAM = TMP_URL.substring(TMP_URL.indexOf("?")+1, TMP_URL.length());
				TMP_URL = TMP_URL.substring(0,TMP_URL.indexOf("?"));
			}
			SQL_PARAM.setProperty("TMP_URL", TMP_URL);
		}

		// URL리스트에 등록이 된 URL인지를 검사
		TMP_WORK_BUFFER.setLength(0);
		StringConvertUtil.ConvertString( TMP_WORK_BUFFER , QUERY_UPDATE_SELECT_EVENTID , SQL_PARAM , "${" , "}" , true , false );
		this.EMS_CONNECTION.putSingleResultToMap(TMP_WORK_BUFFER.toString(), SQL_PARAM);

		// 등록이 안된 페이지
		String pageCode = SQL_PARAM.getProperty("PAGE_CODE");

		if(pageCode == null){
			SQL_PARAM.setProperty("EVENTID", ""); 
			SQL_PARAM.setProperty("TB_IC_CODE", "null");
			SQL_PARAM.setProperty("ITEM3DATA", "null");
			SQL_PARAM.setProperty("AMTDATA", "null");
			SQL_PARAM.setProperty("SECT_ID", "null");


			// 기본 페이지
		} else if(pageCode.equals("0")){
			SQL_PARAM.setProperty("TB_IC_CODE", "null");
			SQL_PARAM.setProperty("ITEM3DATA", "null");
			SQL_PARAM.setProperty("AMTDATA", "null");
			SQL_PARAM.setProperty("SECT_ID", "null");

			// 장바구니 페[이지
		} else if(pageCode.equals("1") && !TMP_PARAM.equals("")){
			SQL_PARAM = parseURL(SQL_PARAM , TMP_PARAM);
			// 구매 페이지
		} else if(pageCode.equals("2") && !TMP_PARAM.equals("")){			
			SQL_PARAM = parseURL(SQL_PARAM , TMP_PARAM);
		}

		TMP_WORK_BUFFER.setLength(0);
		
		//여기에 SITE_ID 가 들어가야 한다...baiaba
		StringConvertUtil.ConvertString( TMP_WORK_BUFFER , QUERY_INSERT_A2_SUM_GENERAL , SQL_PARAM , "${" , "}" , true , false );
		int count = this.EMS_UPDATE_STATEMENT.executeUpdate(TMP_WORK_BUFFER.toString());
		// 시나리오 페이지
		if(SQL_PARAM.getProperty("PAGE_CODE") != null){
			TMP_WORK_BUFFER.setLength(0);
			StringConvertUtil.ConvertString( TMP_WORK_BUFFER , QUERY_INSERT_TARGET_PAGE_A2_SUM_SCN , SQL_PARAM , "${" , "}" , true , false );
			count = this.EMS_UPDATE_STATEMENT.executeUpdate(TMP_WORK_BUFFER.toString());
		}

		msg = "final OK";

		return msg;
	}
	
	/**
	 * 파라미터 파싱한다. 
	 */
	public Properties parseURL(Properties SQL_PARAM, String TMP_PARAM) throws Exception{
		String[] tmp = new String[MAX_ARRAY];
		// 구매/장바구니페이지의 파라미터 값을 파싱한다. 
		// item_code=24920&item_num=3&item_price=2300&s_id=002 을 & 로 파싱해서 배열에 저장
		tmp = StringUtil.split(TMP_PARAM,DELIM_ITEM);
		for(int i=0;i<tmp.length;i++){
			if( tmp[i] != null ){
				// item_code=24920 에서 구분자 = 이후 값을 저장
				if( tmp[i].startsWith("item_code") ){
					SQL_PARAM.setProperty("TB_IC_CODE", tmp[i].substring(tmp[i].indexOf(DELIM_VALUE)+1));
				}else if( tmp[i].startsWith("item_num") ){
					SQL_PARAM.setProperty("ITEM3DATA", tmp[i].substring(tmp[i].indexOf(DELIM_VALUE)+1));
				}else if( tmp[i].startsWith("item_price") ){
					SQL_PARAM.setProperty("AMTDATA", tmp[i].substring(tmp[i].indexOf(DELIM_VALUE)+1));
				}else if( tmp[i].startsWith("s_id") ){
					SQL_PARAM.setProperty("SECT_ID", tmp[i].substring(tmp[i].indexOf(DELIM_VALUE)+1));
				}
			}
		}	
		//만약 SECT_ID가 없을 경우 쿼리 조회 후 값 가져 와야 함. by 2009.05.12
		if( "".equals(SQL_PARAM.getProperty("SECT_ID")) ){
			TMP_WORK_BUFFER.setLength(0);
			StringConvertUtil.ConvertString( TMP_WORK_BUFFER , QUERY_SELECT_SECT_ID , SQL_PARAM , "${" , "}" , true , false );
			this.EMS_CONNECTION.putSingleResultToMap(TMP_WORK_BUFFER.toString(), SQL_PARAM);	
		}
		
		return SQL_PARAM;		
	}
}
