/*
 * @(#)TrackingLogFilter.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.tracking.filter;

import java.util.Properties;

import pluto.log.LogFilter;

/**
 * 트래킹 로그를 파싱하여 Properties에 담아주는 역할을 한다. <br>
 * 자동메일에 대한 것만 정의가 완료되었다. <br>
 * TC=20040211 <LOG_TR_CLOSE> <br>
 * T_DATE=20031231 13:12:15 <LOG_T_DATE> <br>
 * STYPE=AUTO <LOG_SEND_TYPE><br>
 * POST_ID=20040204_34 <LOG_MAIL_ID> <br>
 * M_ID=7711171066919_1 <LOG_MEMBER_ID> <br>
 * LIST_TABLE=AUTO120 <LOG_LIST_TABLE> <br>
 * KIND=O <LOG_TR_KIND> <br>
 * 
 * @version		
 * @author 		dragon
 *
 */
public class TrackingLogFilter  implements LogFilter {
	
	
	/** Creates a new instance of TrackingLogFilter */
	public TrackingLogFilter() {
	}
	
	/** 필터링 룰을 지정한다.
	 * @param tmp 변환할 로그 데이터
	 * @throws Exception 변환에러
	 */
	public Object convert(Object target) throws Exception {
		
		Properties __LOG_DATA__ = ( Properties )target;
		
		String __TEMP__ = __LOG_DATA__.getProperty( LOG_SEND_TYPE );
		
		if( __TEMP__ != null 
				&& ( __TEMP__.equals( "AUTO" ) 
				|| __TEMP__.equals( "AUTORESEND" ) ) ) {
			
			__TEMP__ = __LOG_DATA__.getProperty( LOG_MAIL_ID );
			
			int __IDX_OF_SEP1__ = __TEMP__.indexOf( "_" );
			int __IDX_OF_SEP2__ = 0;
			
			if( __IDX_OF_SEP1__ > 1 ){
				String __WORKDAY__ = __TEMP__.substring( 0 , __IDX_OF_SEP1__ );
				String __SEQNO__ = __TEMP__.substring( __IDX_OF_SEP1__ + 1 );
				
				__LOG_DATA__.setProperty( LOG_WORKDAY , __WORKDAY__ );
				__LOG_DATA__.setProperty( LOG_SEQNO , __SEQNO__ );
			}
			
			String __MEMBER_ID__ = __LOG_DATA__.getProperty( LOG_MEMBER_ID );
			
			__IDX_OF_SEP1__ = __MEMBER_ID__.lastIndexOf( "_" );
			__IDX_OF_SEP2__ = __MEMBER_ID__.lastIndexOf( "^" );
			
			/**구분자가 있으면
			 */
			if( __IDX_OF_SEP1__ > 0 ){
				__LOG_DATA__.setProperty( LOG_MEMBER_ID , __MEMBER_ID__.substring( 0 , __IDX_OF_SEP1__ ) );
				
				if( __IDX_OF_SEP2__ > 0 ){
					if( __IDX_OF_SEP1__ > __IDX_OF_SEP2__ )  return "INVALID MEMBER_ID SEP : " + __MEMBER_ID__;
					
					__LOG_DATA__.setProperty( LOG_MEMBER_ID_SEQ , __MEMBER_ID__.substring( __IDX_OF_SEP1__ + 1 , __IDX_OF_SEP2__ ) );
					__LOG_DATA__.setProperty( LOG_WORK_SEQ , __MEMBER_ID__.substring( __IDX_OF_SEP2__ + 1 ) );
				}
				else{
					__LOG_DATA__.setProperty( LOG_MEMBER_ID_SEQ , __MEMBER_ID__.substring( __IDX_OF_SEP1__ + 1) );
				}
			}
		}
		
		if( __TEMP__ != null 
				&& __TEMP__.equals( "MASSRESEND" )  ) {
			
			
			String __MEMBER_ID__ = __LOG_DATA__.getProperty( LOG_MEMBER_ID );
			
			int __IDX_OF_SEP1__ = __MEMBER_ID__.lastIndexOf( "^" );
			
			/**구분자가 있으면
			 */
			if( __IDX_OF_SEP1__ > 0 ){
				__LOG_DATA__.setProperty( LOG_MEMBER_ID , __MEMBER_ID__.substring( 0 , __IDX_OF_SEP1__ ) );
				
				__LOG_DATA__.setProperty( LOG_WORK_SEQ , __MEMBER_ID__.substring( __IDX_OF_SEP1__ + 1 ) );
			}			

		}		
		
		return __LOG_DATA__;
	}
	
	/** 필터링 룰을 지정한다.
	 * @param target 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public void setFilteringRules(Object target) throws Exception {
	}
}

