/*
 * @(#)BackWardTrackingLogFilter.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.tracking.filter;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;

/**
 * <br>발송 구 버전의 트래킹 작업을 지원한다. 
 * <br>{T_CLOSE=20030821, ID=20030814000000000064, T_DATE=20031231 13:12:15, M_ID=323, CID=004, KIND=M}
 * <br>{T_CLOSE=20040121, ID=20040114000000000048, T_DATE=20031231 13:12:15, M_ID=43, CID=CLOSE, DT=219, KIND=M}
 * <br>{T_CLOSE=20040216, ID=7, T_DATE=20031231 13:12:15, M_ID=7108101927912_1, TBL=AUTO120, WORKDAY=20040209, CID=000, KIND=A}
 * <br>이런 형태의 대량 로그를 포함하는 pluto auto + old windforce의 로그 필터..
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class BackWardTrackingLogFilter extends TrackingLogFilter {
	
	
	
	
	/** Creates a new instance of TrackingLogFilter */
	public BackWardTrackingLogFilter() {
	}
	
	public Object convert(Object target) throws Exception {
		
		Properties __LOG_DATA__ = ( Properties )target;
		
		if (log.isDebugEnabled())  
			log.debug( "INPUT" , __LOG_DATA__.toString() );
			
		// 대량아이디를 세팅하고
		String __TEMP_1__ = __LOG_DATA__.getProperty( "ID" );
		
		if( __TEMP_1__ != null && __TEMP_1__.length() == 20 ){
			__LOG_DATA__.setProperty( LOG_MAIL_ID , __TEMP_1__ );
			__LOG_DATA__.setProperty( LOG_LIST_TABLE , "EBAD".concat( __TEMP_1__.substring( 4 , 6 )).concat( "60" ) );
			
			// 종료일
			__LOG_DATA__.setProperty( LOG_TR_CLOSE , __LOG_DATA__.getProperty( "T_CLOSE" ) );
			
			// CID를 가지고 OG_TR_KIND 를 적당히 만들어 낸다.
			__TEMP_1__ = __LOG_DATA__.getProperty( "CID" );
			
			if( __TEMP_1__.equals( "CLOSE" ) ){
				__LOG_DATA__.setProperty( LOG_TR_KIND , "D" );
			}
			else if( __TEMP_1__.equals( "000" ) ){
				__LOG_DATA__.setProperty( LOG_TR_KIND , "O" );
			}
			else{
				__LOG_DATA__.setProperty( LOG_TR_KIND , "C" );
			}
			
			// M_ID를 가지고 LOG_SEND_TYPE 를 적당히 만들어 낸다.
			__TEMP_1__ = __LOG_DATA__.getProperty( "M_ID" );
			
			if( __TEMP_1__ == null || __TEMP_1__.trim().length() < 1 ){
				__LOG_DATA__.setProperty( LOG_SEND_TYPE , "BULK" );
			}
			else{
				if( __TEMP_1__.equalsIgnoreCase("testID") ){
					__LOG_DATA__.setProperty( LOG_SEND_TYPE , "MTEST" );
				}
				else{
					__LOG_DATA__.setProperty( LOG_SEND_TYPE , "MASS" );
				}
			}
		}
		
		__TEMP_1__ = __LOG_DATA__.getProperty( "WORKDAY" );
		
		if( __TEMP_1__ != null && __TEMP_1__.length() == 8 ){
			__LOG_DATA__.setProperty( LOG_SEND_TYPE , "AUTO" );
			__LOG_DATA__.setProperty( LOG_LIST_TABLE , __LOG_DATA__.getProperty( "TBL" ) );
			__LOG_DATA__.setProperty( LOG_MAIL_ID , __LOG_DATA__.getProperty( "WORKDAY" ) + "_" + __LOG_DATA__.getProperty( "ID" ) );
			__LOG_DATA__.setProperty( LOG_MEMBER_ID ,  __LOG_DATA__.getProperty( "M_ID" ) );
			
			// 종료일
			__LOG_DATA__.setProperty( LOG_TR_CLOSE , __LOG_DATA__.getProperty( "T_CLOSE" ) );
			
			// CID를 가지고 OG_TR_KIND 를 적당히 만들어 낸다.
			__TEMP_1__ = __LOG_DATA__.getProperty( "CID" );
			
			if( __TEMP_1__.equals( "CLOSE" ) ){
				__LOG_DATA__.setProperty( LOG_TR_KIND , "D" );
			}
			else if( __TEMP_1__.equals( "000" ) ){
				__LOG_DATA__.setProperty( LOG_TR_KIND , "O" );
			}
			else{
				__LOG_DATA__.setProperty( LOG_TR_KIND , "C" );
			}
		}
		
		if (log.isDebugEnabled()) {
			log.debug( "OUTPUT" , __LOG_DATA__.toString() );
		}
		
		return super.convert( __LOG_DATA__ );
	}
}
