/*
 * @(#)BackWard2TrackingLogFilter.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.tracking.filter;

import java.util.Properties;

import pluto.util.StringUtil;
import pluto.util.eMsStringTokenizer;

/**
 * <br>발송 구 버전의 트래킹 작업을 지원한다. 
 * <br>{TC=20040229, T_DATE=20031231 13:12:15, POST_ID=20040213000000000006_EBAD0260_O, M_ID=00001, CID=001, KIND=BC}
 * <br>{TC=20040221, T_DATE=20031231 13:12:15, POST_ID=20040212000000000010_EBAD0260_T, M_ID=?????, KIND=BO}
 * <br>{TC=20040222, T_DATE=20031231 13:12:15, POST_ID=20040212000000000011_EBAD0260_T, M_ID=?????, DT=2938, KIND=BD}
 * 
 * @version		
 * @author 		dragon
 *
 */
public class BackWard2TrackingLogFilter extends TrackingLogFilter {
	
	
	protected eMsStringTokenizer POST_ID_TOKENIZER = null;
	
	
	
	/** Creates a new instance of AspOldTrackingLogFilter */
	public BackWard2TrackingLogFilter() {
		POST_ID_TOKENIZER = new eMsStringTokenizer();
	}
	
	public synchronized Object convert(Object target) throws Exception {
		Properties __LOG_DATA__ = ( Properties )target;
		
		/**대량아이디를 세팅하고.
		 */
		String __TEMP_1__ = __LOG_DATA__.getProperty( "POST_ID" );
		if( StringUtil.CountString(  __TEMP_1__ , "_" ) == 2 ){
			POST_ID_TOKENIZER.parse( __TEMP_1__ , "_" );
			
			__LOG_DATA__.setProperty( LOG_MAIL_ID , POST_ID_TOKENIZER.nextToken() );
			__LOG_DATA__.setProperty( LOG_LIST_TABLE , POST_ID_TOKENIZER.nextToken() );
			
			String __TYPE__ = POST_ID_TOKENIZER.nextToken();
			
			if( __TYPE__.equals( "O" ) ){
				__LOG_DATA__.setProperty( LOG_SEND_TYPE , "MASS" );
			}
			else if( __TYPE__.equals( "T" ) ){
				__LOG_DATA__.setProperty( LOG_SEND_TYPE , "MTEST" );
			}
			else{
				__LOG_DATA__.setProperty( LOG_SEND_TYPE , "BULK" );
			}
			
			/**종료일
			 */
			__LOG_DATA__.setProperty( LOG_TR_CLOSE , __LOG_DATA__.getProperty( "TC" ) );
			
			/** CID를 가지고 OG_TR_KIND 를 적당히 만들어 낸다.
			 */
			__TEMP_1__ = __LOG_DATA__.getProperty(  "CID" , "000" );
			
			if( __TEMP_1__.equals( "CLOSE" ) ){
				__LOG_DATA__.setProperty( LOG_TR_KIND , "D" );
			}
			else if( __TEMP_1__.equals( "000" ) ){
				__LOG_DATA__.setProperty( LOG_TR_KIND , "O" );
			}
			else{
				__LOG_DATA__.setProperty( LOG_TR_KIND , "C" );
			}
		}
		
		return super.convert( __LOG_DATA__ );
	}
}
