/*
 * @(#)JupiterErrorCorrectPreUpdator.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.tracking.auto.updator;

import java.util.List;
import java.util.Map;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;

/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class JupiterErrorCorrectPreUpdator 
		extends pluto.common.log.TargetSelectResultUpdator {
	
	
	
	protected static String _QUERY_TARGET_CHECK = null;
	protected static List _QUERY_UPDATE_LIST_RESULT_QUERYS = null;
	protected static List _QUERY_UPDATE_COMMON_RESULT_QUERYS = null;
	
	static {
		try {
			_QUERY_TARGET_CHECK = SqlManager.getQuery("JUPITER_ERROR_CORRECT", "QUERY_TARGET_CHECK");
			_QUERY_UPDATE_LIST_RESULT_QUERYS = SqlManager.getMultiQuery("JUPITER_ERROR_CORRECT", "QUERY_UPDATE_LIST_RESULT_QUERYS");
			_QUERY_UPDATE_COMMON_RESULT_QUERYS = SqlManager.getMultiQuery("JUPITER_ERROR_CORRECT", "QUERY_UPDATE_COMMON_RESULT_QUERYS");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
		if(log.isDebugEnabled()){
			// foo
		}
	}

	protected static String	CHECK_INDEX = " ";
	
	public static final void init( Object tmp ) throws Exception{
		Properties prop = ( Properties )tmp;
		CHECK_INDEX = prop.getProperty( "check.index" , " " );
	}

	/** Creates a new instance of ErrorCorrectPreUpdator */
	public JupiterErrorCorrectPreUpdator() {
		super();
		this.QUERY_TARGET_CHECK = _QUERY_TARGET_CHECK;
		this.QUERY_UPDATE_LIST_RESULT_QUERYS = _QUERY_UPDATE_LIST_RESULT_QUERYS;
		this.QUERY_UPDATE_COMMON_RESULT_QUERYS = _QUERY_UPDATE_COMMON_RESULT_QUERYS;
	}
	
	public String update(Object logMap) throws Exception {
		Map prop = ( Map )logMap;
		String __SEND_TYPE__ = (String)prop.get( LOG_SEND_TYPE );
		if( CHECK_INDEX.indexOf( __SEND_TYPE__ ) < 0 ){
			return "NONE";
		}
		
		return super.update( logMap );
	}
}

